/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.manager.config;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ItemsConfig;
import io.github.altkat.BuffedItems.manager.config.RecipesConfig;
import io.github.altkat.BuffedItems.manager.config.SetsConfig;
import io.github.altkat.BuffedItems.manager.config.UpgradesConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class ConfigManager {
    private static BuffedItems plugin;
    private static final Object CONFIG_LOCK;
    public static final String NO_PERMISSION = "NONE";
    private static int debugLevel;
    private static boolean showPotionIcons;
    private static boolean visualChat;
    private static boolean visualTitle;
    private static boolean visualActionBar;
    private static boolean visualBossBar;
    private static String bossBarColor;
    private static String bossBarStyle;
    private static String globalSuccessSound;
    private static String globalCooldownSound;
    private static String globalCostFailSound;
    public static final int DEBUG_OFF = 0;
    public static final int DEBUG_INFO = 1;
    public static final int DEBUG_TASK = 2;
    public static final int DEBUG_DETAILED = 3;
    public static final int DEBUG_VERBOSE = 4;
    private static final String PLUGIN_PREFIX_CONFIG = "&#FFD700[&#FF6347BuffedItems&#FFD700] ";
    private static final PlainTextComponentSerializer plainTextSerializer;
    private static final LegacyComponentSerializer ampersandSerializer;
    private static final LegacyComponentSerializer sectionSerializer;

    public static Component fromLegacy(String text) {
        if (text == null || text.isEmpty()) {
            return Component.empty();
        }
        TextComponent component = ampersandSerializer.deserialize(text);
        if (component.style().decoration(TextDecoration.ITALIC) == TextDecoration.State.NOT_SET) {
            return component.style(style -> style.decoration(TextDecoration.ITALIC, false));
        }
        return component;
    }

    public static List<Component> loreFromLegacy(List<String> textLines) {
        if (textLines == null || textLines.isEmpty()) {
            return Collections.emptyList();
        }
        return textLines.stream().map(ConfigManager::fromLegacy).collect(Collectors.toList());
    }

    public static Component fromSection(String text) {
        if (text == null || text.isEmpty()) {
            return Component.empty();
        }
        TextComponent component = sectionSerializer.deserialize(text);
        if (component.style().decoration(TextDecoration.ITALIC) == TextDecoration.State.NOT_SET) {
            return component.style(style -> style.decoration(TextDecoration.ITALIC, false));
        }
        return component;
    }

    public static String toSection(Component component) {
        if (component == null) {
            return "";
        }
        return sectionSerializer.serialize(component);
    }

    public static String toPlainText(Component component) {
        if (component == null) {
            return "";
        }
        return plainTextSerializer.serialize(component);
    }

    public static String stripLegacy(String legacyText) {
        if (legacyText == null || legacyText.isEmpty()) {
            return "";
        }
        return plainTextSerializer.serialize(ConfigManager.fromSection(legacyText));
    }

    public static void setup(BuffedItems pluginInstance) {
        plugin = pluginInstance;
    }

    public static void backupConfig() {
        File backupDir = new File(plugin.getDataFolder(), "backups");
        if (!backupDir.exists()) {
            backupDir.mkdirs();
        }
        File configFile = new File(plugin.getDataFolder(), "config.yml");
        File configBackup = new File(backupDir, "config.yml.backup");
        if (configFile.exists()) {
            try {
                Files.copy(configFile.toPath(), configBackup.toPath(), StandardCopyOption.REPLACE_EXISTING);
                ConfigManager.sendDebugMessage(1, () -> "[Backup] config.yml backed up to backups/ folder.");
            }
            catch (IOException e) {
                plugin.getLogger().warning("Could not create config.yml backup: " + e.getMessage());
            }
        }
        File itemsFile = new File(plugin.getDataFolder(), "items.yml");
        File itemsBackup = new File(backupDir, "items.yml.backup");
        if (itemsFile.exists()) {
            try {
                Files.copy(itemsFile.toPath(), itemsBackup.toPath(), StandardCopyOption.REPLACE_EXISTING);
                ConfigManager.sendDebugMessage(1, () -> "[Backup] items.yml backed up to backups/ folder.");
            }
            catch (IOException e) {
                plugin.getLogger().warning("Could not create items.yml backup: " + e.getMessage());
            }
        }
        File upgradesFile = new File(plugin.getDataFolder(), "upgrades.yml");
        File upgradesBackup = new File(backupDir, "upgrades.yml.backup");
        if (upgradesFile.exists()) {
            try {
                Files.copy(upgradesFile.toPath(), upgradesBackup.toPath(), StandardCopyOption.REPLACE_EXISTING);
                ConfigManager.sendDebugMessage(1, () -> "[Backup] upgrades.yml backed up to backups/ folder.");
            }
            catch (IOException e) {
                plugin.getLogger().warning("Could not create upgrades.yml backup: " + e.getMessage());
            }
        }
        File setsFile = new File(plugin.getDataFolder(), "sets.yml");
        File setsBackup = new File(backupDir, "sets.yml.backup");
        if (setsFile.exists()) {
            try {
                Files.copy(setsFile.toPath(), setsBackup.toPath(), StandardCopyOption.REPLACE_EXISTING);
                ConfigManager.sendDebugMessage(1, () -> "[Backup] sets.yml backed up to backups/ folder.");
            }
            catch (IOException e) {
                plugin.getLogger().warning("Could not create sets.yml backup: " + e.getMessage());
            }
        }
        File recipesFile = new File(plugin.getDataFolder(), "recipes.yml");
        File recipesBackup = new File(backupDir, "recipes.yml.backup");
        if (recipesFile.exists()) {
            try {
                Files.copy(recipesFile.toPath(), recipesBackup.toPath(), StandardCopyOption.REPLACE_EXISTING);
                ConfigManager.sendDebugMessage(1, () -> "[Backup] recipes.yml backed up to backups/ folder.");
            }
            catch (IOException e) {
                plugin.getLogger().warning("Could not create recipes.yml backup: " + e.getMessage());
            }
        }
    }

    public static void reloadConfig() {
        ConfigManager.reloadConfig(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadConfig(boolean silent) {
        Object object = CONFIG_LOCK;
        synchronized (object) {
            long startTime = System.currentTimeMillis();
            if (!silent) {
                ConfigManager.sendDebugMessage(1, () -> "[Config] Reloading configuration...");
            }
            plugin.reloadConfig();
            ItemsConfig.reload();
            UpgradesConfig.reload();
            SetsConfig.reload();
            RecipesConfig.reload();
            plugin.getItemManager().loadItems(silent);
            plugin.getUpgradeManager().loadRecipes(silent);
            plugin.getSetManager().loadSets(silent);
            plugin.getCraftingManager().loadRecipes(silent);
            ConfigManager.loadGlobalSettings();
            ConfigManager.invalidateAllPlayerCaches();
            if (!silent) {
                long elapsedTime = System.currentTimeMillis() - startTime;
                ConfigManager.sendDebugMessage(1, () -> "[Config] Reload complete in " + elapsedTime + "ms");
            }
        }
    }

    public static void loadGlobalSettings() {
        debugLevel = plugin.getConfig().getInt("debug-level", 0);
        if (debugLevel < 0) {
            debugLevel = 0;
        }
        showPotionIcons = plugin.getConfig().getBoolean("show-potion-icons", true);
        if (ConfigManager.isDebugLevelEnabled(1)) {
            plugin.getServer().getConsoleSender().sendMessage(ConfigManager.fromLegacy("&#FFD700[&#FF6347BuffedItems&#FFD700] &e[Debug Level " + debugLevel + "] Enabled - Detailed logs will be shown according to level."));
        }
        visualChat = plugin.getConfig().getBoolean("active-items.visuals.chat", true);
        visualTitle = plugin.getConfig().getBoolean("active-items.visuals.title", true);
        visualActionBar = plugin.getConfig().getBoolean("active-items.visuals.action-bar", true);
        visualBossBar = plugin.getConfig().getBoolean("active-items.visuals.boss-bar", true);
        bossBarColor = plugin.getConfig().getString("active-items.boss-bar-settings.color", "RED");
        bossBarStyle = plugin.getConfig().getString("active-items.boss-bar-settings.style", "SOLID");
        globalSuccessSound = plugin.getConfig().getString("active-items.sounds.success", "ENTITY_EXPERIENCE_ORB_PICKUP;1.0;1.0");
        globalCooldownSound = plugin.getConfig().getString("active-items.sounds.cooldown", "ENTITY_VILLAGER_NO;1.0;1.0");
        globalCostFailSound = plugin.getConfig().getString("active-items.sounds.cost-fail", "BLOCK_NOTE_BLOCK_HARP;1.0;0.5");
    }

    public static void sendDebugMessage(int level, Supplier<String> messageSupplier) {
        if (debugLevel >= level) {
            String message = messageSupplier.get();
            String prefix = "&#FFD700[&#FF6347BuffedItems&#FFD700] &e[L" + level + "] &r";
            plugin.getServer().getConsoleSender().sendMessage(ConfigManager.fromLegacy(prefix + message));
        }
    }

    public static void logInfo(String message) {
        if (plugin == null) {
            return;
        }
        plugin.getServer().getConsoleSender().sendMessage(ConfigManager.fromLegacy(PLUGIN_PREFIX_CONFIG + message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setItemValue(String itemId, String path, Object value) {
        Object object = CONFIG_LOCK;
        synchronized (object) {
            String fullPath;
            ConfigManager.sendDebugMessage(1, () -> "[Config] Setting value: items." + itemId + "." + path + " = " + String.valueOf(value));
            Object normalizedPath = path != null ? (path.equals("active_mode") ? "active-mode.enabled" : (path.equals("cooldown") ? "active-mode.cooldown" : (path.equals("effect_duration") ? "active-mode.duration" : (path.equals("commands") ? "active-mode.commands" : (path.equals("costs") ? "active-mode.costs" : (path.startsWith("visuals") ? "active-mode." + path : (path.startsWith("sounds") ? "active-mode." + path : (path.startsWith("usage-limit") ? "active-mode." + path : (path.startsWith("active_effects") ? path.replace("active_effects", "active-mode.effects") : path))))))))) : null;
            ConfigManager.sendDebugMessage(1, () -> ConfigManager.lambda$setItemValue$10(itemId, (String)normalizedPath, value));
            String string = fullPath = normalizedPath == null ? "items." + itemId : "items." + itemId + "." + (String)normalizedPath;
            if ("permission".equals(normalizedPath) && value == null) {
                ItemsConfig.get().set(fullPath, (Object)NO_PERMISSION);
            } else {
                ItemsConfig.get().set(fullPath, value);
            }
            ItemsConfig.save();
            plugin.getItemManager().reloadSingleItem(itemId);
            plugin.getEffectApplicatorTask().invalidateCacheForHolding(itemId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createNewItem(String itemId) {
        Object object = CONFIG_LOCK;
        synchronized (object) {
            ConfigManager.sendDebugMessage(1, () -> "[Config] Creating new item: " + itemId);
            FileConfiguration config = ItemsConfig.get();
            if (config.contains("items." + itemId)) {
                ConfigManager.sendDebugMessage(1, () -> "[Config] Item already exists: " + itemId);
                return false;
            }
            config.set("items." + itemId + ".display_name", (Object)("&f" + itemId));
            config.set("items." + itemId + ".material", (Object)"STONE");
            config.set("items." + itemId + ".lore", List.of("", "&7A new BuffedItem."));
            ItemsConfig.save();
            plugin.getItemManager().reloadSingleItem(itemId);
            ConfigManager.logInfo("&aCreated new item: &e" + itemId);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String duplicateItem(String sourceItemId, String newItemId) {
        Object object = CONFIG_LOCK;
        synchronized (object) {
            FileConfiguration config = ItemsConfig.get();
            ConfigurationSection sourceSection = config.getConfigurationSection("items." + sourceItemId);
            if (sourceSection == null) {
                ConfigManager.sendDebugMessage(1, () -> "[Config] Duplicate failed: Source item '" + sourceItemId + "' not found.");
                return null;
            }
            if (config.getConfigurationSection("items." + newItemId) != null) {
                ConfigManager.sendDebugMessage(1, () -> "[Config] Duplicate failed: Target ID '" + newItemId + "' already exists.");
                return null;
            }
            String originalDisplayName = sourceSection.getString("display_name", "&f" + sourceItemId);
            ConfigurationSection newSection = config.createSection("items." + newItemId);
            ConfigManager.deepCopySection(sourceSection, newSection);
            config.set("items." + newItemId + ".display_name", (Object)(originalDisplayName + " &7(Copy)"));
            ItemsConfig.save();
            plugin.getItemManager().reloadSingleItem(newItemId);
            ConfigManager.sendDebugMessage(1, () -> "[Config] Duplicated item '" + sourceItemId + "' to '" + newItemId + "'");
            return newItemId;
        }
    }

    private static void deepCopySection(ConfigurationSection source, ConfigurationSection target) {
        for (String key : source.getKeys(false)) {
            Object value = source.get(key);
            if (source.isConfigurationSection(key)) {
                ConfigurationSection newSubSection = target.createSection(key);
                ConfigManager.deepCopySection(source.getConfigurationSection(key), newSubSection);
                continue;
            }
            target.set(key, ConfigManager.deepCopyObject(value));
        }
    }

    private static Object deepCopyObject(Object object) {
        if (object instanceof List) {
            List originalList = (List)object;
            ArrayList<Object> newList = new ArrayList<Object>();
            for (Object item : originalList) {
                newList.add(ConfigManager.deepCopyObject(item));
            }
            return newList;
        }
        if (object instanceof Map) {
            Map originalMap = (Map)object;
            LinkedHashMap<Object, Object> newMap = new LinkedHashMap<Object, Object>();
            for (Map.Entry entry : originalMap.entrySet()) {
                newMap.put(ConfigManager.deepCopyObject(entry.getKey()), ConfigManager.deepCopyObject(entry.getValue()));
            }
            return newMap;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUpgradeValue(String upgradeId, String path, Object value) {
        Object object = CONFIG_LOCK;
        synchronized (object) {
            ConfigManager.sendDebugMessage(1, () -> "[Config] Setting upgrade value: upgrades." + upgradeId + "." + path + " = " + String.valueOf(value));
            String fullPath = path == null ? "upgrades." + upgradeId : "upgrades." + upgradeId + "." + path;
            UpgradesConfig.get().set(fullPath, value);
            UpgradesConfig.save();
            UpgradesConfig.reload();
            plugin.getUpgradeManager().loadRecipes(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createNewSet(String setId) {
        Object object = CONFIG_LOCK;
        synchronized (object) {
            ConfigManager.sendDebugMessage(1, () -> "[Config] Creating new set: " + setId);
            if (SetsConfig.get().contains("sets." + setId)) {
                return false;
            }
            String path = "sets." + setId;
            SetsConfig.get().set(path + ".display_name", (Object)("&6" + setId));
            SetsConfig.get().set(path + ".items", new ArrayList());
            SetsConfig.save();
            plugin.getSetManager().loadSets(true);
            return true;
        }
    }

    private static void invalidateAllPlayerCaches() {
        if (plugin.getEffectApplicatorTask() == null) {
            return;
        }
        int playerCount = Bukkit.getOnlinePlayers().size();
        ConfigManager.sendDebugMessage(2, () -> "[Config] Invalidating cache for all (" + playerCount + ") online players after config change...");
        for (Player player : Bukkit.getOnlinePlayers()) {
            plugin.getEffectApplicatorTask().markPlayerForUpdate(player.getUniqueId());
        }
        ConfigManager.sendDebugMessage(2, () -> "[Config] Cache invalidation complete. Changes will apply on next tick.");
    }

    public static Component getPrefixedMessageAsComponent(String path) {
        String prefix = plugin.getConfig().getString("messages.prefix", PLUGIN_PREFIX_CONFIG);
        String msg = plugin.getConfig().getString("messages." + path, "&cMissing message: messages." + path);
        return ConfigManager.fromLegacy(prefix + msg);
    }

    public static Component fromSectionWithPrefix(String text) {
        String prefixStr = plugin.getConfig().getString("messages.prefix", PLUGIN_PREFIX_CONFIG);
        Component prefixComp = ConfigManager.fromLegacy(prefixStr);
        Component textComp = ConfigManager.fromSection(text);
        return prefixComp.append(textComp);
    }

    public static Component fromLegacyWithPrefix(String text) {
        String prefixStr = plugin.getConfig().getString("messages.prefix", PLUGIN_PREFIX_CONFIG);
        Component prefixComp = ConfigManager.fromLegacy(prefixStr);
        Component textComp = ConfigManager.fromLegacy(text);
        return prefixComp.append(textComp);
    }

    public static void setDebugLevel(int level) {
        if (level < 0) {
            level = 0;
        }
        if (level > 4) {
            level = 0;
        }
        plugin.getConfig().set("debug-level", (Object)level);
        plugin.saveConfig();
        ConfigManager.loadGlobalSettings();
    }

    public static void setShowPotionIcons(boolean show) {
        plugin.getConfig().set("show-potion-icons", (Object)show);
        plugin.saveConfig();
        ConfigManager.loadGlobalSettings();
    }

    public static String getGlobalUsageLore() {
        if (plugin == null) {
            return "&7Remaining Uses: &e{remaining_uses}&7/&6{total_uses}";
        }
        return plugin.getConfig().getString("active-items.messages.usage-limit-lore", "&7Remaining Uses: &e%remaining_uses%&7/&6%total_uses%");
    }

    public static String getGlobalDepletedLore() {
        if (plugin == null) {
            return "&cITEM DEPLETED - NO USES LEFT";
        }
        return plugin.getConfig().getString("active-items.messages.usage-limit-depleted-lore", "&cITEM DEPLETED - NO USES LEFT");
    }

    public static String getGlobalDepletedMessage() {
        if (plugin == null) {
            return "&cThis item is depleted! You can't use its ability anymore.";
        }
        return plugin.getConfig().getString("active-items.messages.usage-limit-depleted-message", "&cThis item is depleted! You can't use its ability anymore.");
    }

    public static String getGlobalDepletionNotification() {
        if (plugin == null) {
            return "&cYour item has run out of charges!";
        }
        return plugin.getConfig().getString("active-items.messages.usage-limit-depletion-notification", "&cYour item has run out of charges!");
    }

    public static String getGlobalDepletionSound() {
        return plugin.getConfig().getString("active-items.sounds.depletion", "ENTITY_ITEM_BREAK;1.0;1.0");
    }

    public static String getGlobalDepletedTrySound() {
        if (plugin == null) {
            return "BLOCK_DISPENSER_FAIL;1.0;1.2";
        }
        return plugin.getConfig().getString("active-items.sounds.depleted-try", "BLOCK_DISPENSER_FAIL;1.0;1.2");
    }

    public static boolean isDebugLevelEnabled(int level) {
        return debugLevel >= level;
    }

    public static int getDebugLevel() {
        return debugLevel;
    }

    public static boolean shouldShowPotionIcons() {
        return showPotionIcons;
    }

    public static boolean isVisualChatEnabled() {
        return visualChat;
    }

    public static boolean isVisualTitleEnabled() {
        return visualTitle;
    }

    public static boolean isVisualActionBarEnabled() {
        return visualActionBar;
    }

    public static boolean isVisualBossBarEnabled() {
        return visualBossBar;
    }

    public static String getBossBarColor() {
        return bossBarColor;
    }

    public static String getBossBarStyle() {
        return bossBarStyle;
    }

    public static String getGlobalSuccessSound() {
        return globalSuccessSound;
    }

    public static String getGlobalCooldownSound() {
        return globalCooldownSound;
    }

    public static String getGlobalCostFailSound() {
        return globalCostFailSound;
    }

    public static String getDefaultCostMessage(String type) {
        String path = "active-items.costs.messages." + type.toLowerCase();
        if (plugin.getConfig().contains(path)) {
            return plugin.getConfig().getString(path);
        }
        return plugin.getConfig().getString("active-items.costs.messages.default", "&cCost not met.");
    }

    private static /* synthetic */ String lambda$setItemValue$10(String itemId, String normalizedPath, Object value) {
        return "[Config] Setting value: items." + itemId + "." + normalizedPath + " = " + String.valueOf(value);
    }

    static {
        CONFIG_LOCK = new Object();
        debugLevel = 0;
        showPotionIcons = true;
        plainTextSerializer = PlainTextComponentSerializer.plainText();
        ampersandSerializer = LegacyComponentSerializer.builder().character('&').hexColors().build();
        sectionSerializer = LegacyComponentSerializer.builder().character('\u00a7').hexColors().build();
    }
}

