/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.listener.handler;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.listener.handler.ChatInputHandler;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.config.RecipesConfig;
import io.github.altkat.BuffedItems.manager.crafting.MatchType;
import io.github.altkat.BuffedItems.menu.crafting.IngredientSettingsMenu;
import io.github.altkat.BuffedItems.menu.crafting.RecipeEditorMenu;
import io.github.altkat.BuffedItems.menu.crafting.RecipeListMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class RecipeInputHandler
implements ChatInputHandler {
    private final BuffedItems plugin;

    public RecipeInputHandler(BuffedItems plugin) {
        this.plugin = plugin;
    }

    @Override
    public void handle(Player player, PlayerMenuUtility pmu, String input, String path, String itemId) {
        if (path.equals("create_recipe")) {
            String newRecipeId = input.toLowerCase().replace(" ", "_");
            if (RecipesConfig.get().contains("recipes." + newRecipeId)) {
                player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: A recipe with that ID already exists."));
                new RecipeListMenu(pmu, this.plugin).open();
            } else {
                this.createDefaultRecipe(newRecipeId);
                pmu.setUnsavedChanges(true);
                player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aRecipe '" + newRecipeId + "' created successfully!"));
                pmu.setRecipeToEditId(newRecipeId);
                new RecipeEditorMenu(pmu, this.plugin).open();
            }
            this.closeChat(pmu);
        } else if (path.equals("recipe_result_amount")) {
            try {
                int amount = Integer.parseInt(input);
                if (amount < 1) {
                    throw new NumberFormatException();
                }
                String recipeId = pmu.getRecipeToEditId();
                RecipesConfig.get().set("recipes." + recipeId + ".result.amount", (Object)amount);
                pmu.setUnsavedChanges(true);
                player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aResult amount updated: " + amount));
                new RecipeEditorMenu(pmu, this.plugin).open();
            }
            catch (NumberFormatException e) {
                player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cInvalid number."));
                new RecipeEditorMenu(pmu, this.plugin).open();
            }
            this.closeChat(pmu);
        } else if (path.equals("recipe_permission")) {
            String perm = input.trim();
            if (perm.equalsIgnoreCase("none") || perm.equalsIgnoreCase("null")) {
                perm = null;
            }
            String recipeId = pmu.getRecipeToEditId();
            RecipesConfig.get().set("recipes." + recipeId + ".permission", (Object)perm);
            pmu.setUnsavedChanges(true);
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aRecipe permission updated: " + (perm == null ? "None" : perm)));
            new RecipeEditorMenu(pmu, this.plugin).open();
            this.closeChat(pmu);
        } else if (path.equals("recipe_ingredient_amount")) {
            try {
                int amount = Integer.parseInt(input);
                if (amount < 1) {
                    throw new NumberFormatException();
                }
                boolean success = this.updateIngredientAmountHelper(pmu, amount);
                if (success) {
                    player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aIngredient amount updated: " + amount));
                    pmu.setUnsavedChanges(true);
                } else {
                    player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cYou must select an ingredient first!"));
                }
                new IngredientSettingsMenu(pmu, this.plugin).open();
            }
            catch (NumberFormatException e) {
                player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cInvalid number. Please enter a positive integer."));
                new IngredientSettingsMenu(pmu, this.plugin).open();
            }
            this.closeChat(pmu);
        } else if (path.equals("recipe_result_manual")) {
            if (this.plugin.getItemManager().getBuffedItem(input) == null) {
                player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7eWarning: Item ID '" + input + "' not found."));
            }
            String recipeId = pmu.getRecipeToEditId();
            RecipesConfig.get().set("recipes." + recipeId + ".result.item", (Object)input);
            pmu.setUnsavedChanges(true);
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aRecipe result updated to: \u00a7e" + input));
            new RecipeEditorMenu(pmu, this.plugin).open();
            this.closeChat(pmu);
        } else if (path.equals("recipe_ingredient_buffed_manual")) {
            if (this.plugin.getItemManager().getBuffedItem(input) == null) {
                player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7eWarning: Item ID '" + input + "' not found."));
            }
            this.saveIngredientHelper(pmu, MatchType.BUFFED_ITEM, Material.STONE, input, 1);
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aIngredient set to Buffed Item: \u00a7e" + input));
            new IngredientSettingsMenu(pmu, this.plugin, false).open();
            this.closeChat(pmu);
        } else if (path.equals("recipe_ingredient_material_manual")) {
            String matName = input.toUpperCase().replace(" ", "_");
            Material mat = Material.matchMaterial((String)matName);
            if (mat == null) {
                player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cInvalid Material: " + input));
                player.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
                return;
            }
            this.saveIngredientHelper(pmu, MatchType.MATERIAL, mat, mat.name(), 1);
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aIngredient set to Material: \u00a7e" + mat.name()));
            new IngredientSettingsMenu(pmu, this.plugin, false).open();
            this.closeChat(pmu);
        }
    }

    private boolean updateIngredientAmountHelper(PlayerMenuUtility pmu, int newAmount) {
        String recipeId = pmu.getRecipeToEditId();
        int slotIndex = pmu.getSelectedRecipeSlot();
        char key = (char)(65 + slotIndex);
        String path = "recipes." + recipeId + ".ingredients." + key;
        FileConfiguration config = RecipesConfig.get();
        if (!config.contains(path + ".type")) {
            return false;
        }
        String typeStr = config.getString(path + ".type");
        String value = config.getString(path + ".value");
        MatchType type = MatchType.valueOf(typeStr);
        this.saveIngredientHelper(pmu, type, null, value, newAmount);
        return true;
    }

    private void saveIngredientHelper(PlayerMenuUtility pmu, MatchType type, Material mat, String value, int amount) {
        String recipeId = pmu.getRecipeToEditId();
        int slotIndex = pmu.getSelectedRecipeSlot();
        char key = (char)(65 + slotIndex);
        String path = "recipes." + recipeId + ".ingredients." + key;
        String shapePath = "recipes." + recipeId + ".shape";
        FileConfiguration config = RecipesConfig.get();
        if (type == null) {
            config.set(path, null);
        } else {
            config.set(path + ".type", (Object)type.name());
            config.set(path + ".value", (Object)value);
            config.set(path + ".amount", (Object)amount);
        }
        List rawShape = config.getStringList(shapePath);
        ArrayList<String> shape = new ArrayList<String>();
        for (int i = 0; i < 3; ++i) {
            String line;
            String string = line = i < rawShape.size() ? (String)rawShape.get(i) : "   ";
            if (line == null) {
                line = "   ";
            }
            StringBuilder sb = new StringBuilder(line);
            while (sb.length() < 3) {
                sb.append(" ");
            }
            if (sb.length() > 3) {
                sb.setLength(3);
            }
            shape.add(sb.toString());
        }
        int row = slotIndex / 3;
        int col = slotIndex % 3;
        StringBuilder targetLine = new StringBuilder((String)shape.get(row));
        targetLine.setCharAt(col, type == null ? (char)' ' : (char)key);
        shape.set(row, targetLine.toString());
        config.set(shapePath, shape);
    }

    private void createDefaultRecipe(String recipeId) {
        String path = "recipes." + recipeId;
        FileConfiguration config = RecipesConfig.get();
        config.set(path + ".result.item", (Object)"select_item_id");
        config.set(path + ".result.amount", (Object)1);
        ArrayList<String> shape = new ArrayList<String>();
        shape.add("   ");
        shape.add("   ");
        shape.add("   ");
        config.set(path + ".shape", shape);
    }

    private void closeChat(PlayerMenuUtility pmu) {
        pmu.setWaitingForChatInput(false);
        pmu.setChatInputPath(null);
    }
}

