/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.listener.handler;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.listener.handler.ChatInputHandler;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.menu.editor.LoreEditorMenu;
import io.github.altkat.BuffedItems.menu.utility.ItemListMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import java.util.ArrayList;
import org.bukkit.entity.Player;

public class LoreInputHandler
implements ChatInputHandler {
    private final BuffedItems plugin;

    public LoreInputHandler(BuffedItems plugin) {
        this.plugin = plugin;
    }

    @Override
    public void handle(Player player, PlayerMenuUtility pmu, String input, String path, String itemId) {
        BuffedItem item = this.plugin.getItemManager().getBuffedItem(itemId);
        if (item == null) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: Item '" + itemId + "' not found in memory."));
            this.closeChatInput(pmu);
            new ItemListMenu(pmu, this.plugin).open();
            return;
        }
        ArrayList<String> currentLore = new ArrayList<String>(item.getLore());
        if (path.equals("lore.add")) {
            currentLore.add(input);
            ConfigManager.sendDebugMessage(4, () -> "[Chat] Added new lore line to " + itemId);
        } else {
            try {
                int index = Integer.parseInt(path.substring(5));
                if (index < 0 || index >= currentLore.size()) {
                    player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: Invalid lore index."));
                    this.closeChatInput(pmu);
                    new LoreEditorMenu(pmu, this.plugin).open();
                    return;
                }
                currentLore.set(index, input);
                ConfigManager.sendDebugMessage(4, () -> "[Chat] Updated lore line " + index + " for " + itemId);
            }
            catch (NumberFormatException ex) {
                player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: Could not parse lore index from path: " + path));
                ConfigManager.sendDebugMessage(1, () -> "[Chat] Could not parse lore index from path: " + path);
                this.closeChatInput(pmu);
                new LoreEditorMenu(pmu, this.plugin).open();
                return;
            }
        }
        ConfigManager.setItemValue(itemId, "lore", currentLore);
        player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aLore has been updated!"));
        this.closeChatInput(pmu);
        new LoreEditorMenu(pmu, this.plugin).open();
    }

    private void closeChatInput(PlayerMenuUtility pmu) {
        pmu.setWaitingForChatInput(false);
        pmu.setChatInputPath(null);
    }
}

