/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.listener.handler;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.listener.EffectType;
import io.github.altkat.BuffedItems.listener.handler.ChatInputHandler;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.config.ItemsConfig;
import io.github.altkat.BuffedItems.manager.config.SetsConfig;
import io.github.altkat.BuffedItems.menu.editor.EnchantmentListMenu;
import io.github.altkat.BuffedItems.menu.passive.EffectListMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.bukkit.attribute.Attribute;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;

public class EffectInputHandler
implements ChatInputHandler {
    private final BuffedItems plugin;

    public EffectInputHandler(BuffedItems plugin) {
        this.plugin = plugin;
    }

    @Override
    public void handle(Player player, PlayerMenuUtility pmu, String input, String path, String itemId) {
        if (path.startsWith("active.potion_effects.add.")) {
            this.handleAddGenericEffect(player, pmu, input, path, itemId, "items." + itemId + ".active-mode.effects.potion_effects", EffectType.POTION_EFFECT, p -> p.substring(26), "ACTIVE", null);
        } else if (path.equals("active.potion_effects.edit")) {
            this.handleEditGenericEffect(player, pmu, input, itemId, EffectType.POTION_EFFECT, "items." + itemId + ".active-mode.effects.potion_effects", "ACTIVE", null);
        } else if (path.startsWith("active.attributes.add.")) {
            this.handleAddGenericEffect(player, pmu, input, path, itemId, "items." + itemId + ".active-mode.effects.attributes", EffectType.ATTRIBUTE, p -> p.substring(22), "ACTIVE", null);
        } else if (path.equals("active.attributes.edit")) {
            this.handleEditGenericEffect(player, pmu, input, itemId, EffectType.ATTRIBUTE, "items." + itemId + ".active-mode.effects.attributes", "ACTIVE", null);
        } else if (path.startsWith("potion_effects.add.")) {
            String slot = pmu.getTargetSlot();
            this.handleAddGenericEffect(player, pmu, input, path, itemId, "items." + itemId + ".effects." + slot + ".potion_effects", EffectType.POTION_EFFECT, p -> p.substring(19), slot, slot);
        } else if (path.equals("potion_effects.edit")) {
            String slot = pmu.getTargetSlot();
            this.handleEditGenericEffect(player, pmu, input, itemId, EffectType.POTION_EFFECT, "items." + itemId + ".effects." + slot + ".potion_effects", slot, slot);
        } else if (path.startsWith("attributes.add.")) {
            String slot = pmu.getTargetSlot();
            this.handleAddGenericEffect(player, pmu, input, path, itemId, "items." + itemId + ".effects." + slot + ".attributes", EffectType.ATTRIBUTE, p -> p.substring(15), slot, slot);
        } else if (path.equals("attributes.edit")) {
            String slot = pmu.getTargetSlot();
            this.handleEditGenericEffect(player, pmu, input, itemId, EffectType.ATTRIBUTE, "items." + itemId + ".effects." + slot + ".attributes", slot, slot);
        } else if (path.equals("enchantments.edit")) {
            this.handleEditEnchantment(player, pmu, input, itemId);
        } else if (path.startsWith("enchantments.add.")) {
            this.handleAddEnchantment(player, pmu, input, path, itemId);
        } else if (path.startsWith("set.potion.add.")) {
            this.handleAddSetEffect(player, pmu, input, path, EffectType.POTION_EFFECT);
        } else if (path.equals("set.potion.edit")) {
            this.handleEditSetEffect(player, pmu, input, EffectType.POTION_EFFECT);
        } else if (path.startsWith("set.attribute.add.")) {
            this.handleAddSetEffect(player, pmu, input, path, EffectType.ATTRIBUTE);
        } else if (path.equals("set.attribute.edit")) {
            this.handleEditSetEffect(player, pmu, input, EffectType.ATTRIBUTE);
        }
    }

    private void handleAddGenericEffect(Player player, PlayerMenuUtility pmu, String input, String path, String itemId, String configPath, EffectType effectType, Function<String, String> nameExtractor, String context, String slot) {
        String rawName = nameExtractor.apply(path);
        ArrayList<String> effects = new ArrayList<String>(ItemsConfig.get().getStringList(configPath));
        try {
            String finalConfigString;
            if (effectType == EffectType.ATTRIBUTE) {
                String[] parts = rawName.split("\\.");
                if (parts.length < 2) {
                    throw new IllegalArgumentException("Invalid attribute path format: " + rawName);
                }
                String attrName = parts[0];
                String opName = parts[1];
                this.validateEffectName(EffectType.ATTRIBUTE, attrName);
                double amount = Double.parseDouble(input);
                String checkStr = attrName + ";" + opName;
                if (effects.stream().anyMatch(s -> s.toUpperCase().startsWith(checkStr.toUpperCase()))) {
                    throw new IllegalStateException("Duplicate attribute");
                }
                finalConfigString = attrName + ";" + opName + ";" + amount;
            } else {
                String potionName = rawName;
                this.validateEffectName(effectType, potionName);
                int level = Integer.parseInt(input);
                if (level <= 0) {
                    throw new NumberFormatException();
                }
                if (this.effectExists(effects, potionName)) {
                    throw new IllegalStateException("Duplicate effect");
                }
                finalConfigString = potionName + ";" + level;
            }
            effects.add(finalConfigString);
            String configKey = configPath.substring(configPath.indexOf(".") + itemId.length() + 2);
            ConfigManager.setItemValue(itemId, configKey, effects);
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7a" + this.capitalizeFirstLetter(effectType.getDisplayName()) + " has been added!"));
            ConfigManager.sendDebugMessage(3, () -> "[EffectHandler] Added " + effectType.getDisplayName() + ": " + finalConfigString + " for " + itemId);
            this.closeChatInput(pmu);
            this.openAppropriateMenu(player, pmu, effectType, context, slot);
        }
        catch (NumberFormatException ex) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cInvalid number format. Please enter a valid number."));
        }
        catch (IllegalStateException ex) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: This " + effectType.getDisplayName() + " already exists on the item."));
            this.closeChatInput(pmu);
            this.openAppropriateMenu(player, pmu, effectType, context, slot);
        }
        catch (IllegalArgumentException ex) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: Invalid " + effectType.getDisplayName() + " format: " + rawName));
            ConfigManager.sendDebugMessage(1, () -> "[EffectHandler] Failed to add " + effectType.getDisplayName() + ": " + rawName + " - " + ex.getMessage());
            this.closeChatInput(pmu);
            this.openAppropriateMenu(player, pmu, effectType, context, slot);
        }
    }

    private void handleEditGenericEffect(Player player, PlayerMenuUtility pmu, String input, String itemId, EffectType effectType, String configPath, String context, String slot) {
        List effects = ItemsConfig.get().getStringList(configPath);
        int index = pmu.getEditIndex();
        if (index == -1 || index >= effects.size()) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: Invalid " + effectType.getDisplayName() + " index."));
            this.closeChatInput(pmu);
            this.openAppropriateMenu(player, pmu, effectType, context, slot);
            return;
        }
        try {
            String newEffectString;
            String currentString = (String)effects.get(index);
            String[] parts = currentString.split(";");
            if (effectType == EffectType.ATTRIBUTE) {
                if (parts.length < 3) {
                    throw new IllegalStateException("Corrupt attribute data");
                }
                double newAmount = Double.parseDouble(input);
                newEffectString = parts[0] + ";" + parts[1] + ";" + newAmount;
            } else {
                if (parts.length < 2) {
                    throw new IllegalStateException("Corrupt effect data");
                }
                int newLevel = Integer.parseInt(input);
                if (newLevel <= 0) {
                    throw new NumberFormatException();
                }
                newEffectString = parts[0] + ";" + newLevel;
            }
            effects.set(index, newEffectString);
            String configKey = configPath.substring(configPath.indexOf(".") + itemId.length() + 2);
            ConfigManager.setItemValue(itemId, configKey, effects);
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7a" + this.capitalizeFirstLetter(effectType.getDisplayName()) + " has been updated!"));
            pmu.setEditIndex(-1);
            this.closeChatInput(pmu);
            this.openAppropriateMenu(player, pmu, effectType, context, slot);
        }
        catch (NumberFormatException ex) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cInvalid number. Please enter a valid number."));
        }
        catch (Exception ex) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError updating " + effectType.getDisplayName() + ". Data might be corrupt."));
            this.closeChatInput(pmu);
            this.openAppropriateMenu(player, pmu, effectType, context, slot);
        }
    }

    private void handleEditEnchantment(Player player, PlayerMenuUtility pmu, String input, String itemId) {
        String configPath = "items." + itemId + ".enchantments";
        ArrayList<CallSite> enchantments = new ArrayList<CallSite>(ItemsConfig.get().getStringList(configPath));
        int index = pmu.getEditIndex();
        if (index == -1 || index >= enchantments.size()) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: Invalid enchantment index."));
            this.closeChatInput(pmu);
            new EnchantmentListMenu(pmu, this.plugin).open();
            return;
        }
        try {
            int newLevel = Integer.parseInt(input);
            if (newLevel <= 0) {
                player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cInvalid level. Please enter a positive whole number (e.g., 1, 5, 10)."));
                return;
            }
            String[] parts = ((String)enchantments.get(index)).split(";");
            if (parts.length == 2) {
                String enchantName = parts[0];
                if (Enchantment.getByName((String)enchantName.toUpperCase()) == null) {
                    player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: Corrupted enchantment name '" + enchantName + "' found in config."));
                    this.closeChatInput(pmu);
                    new EnchantmentListMenu(pmu, this.plugin).open();
                    return;
                }
                String newEnchantString = enchantName + ";" + newLevel;
                enchantments.set(index, (CallSite)((Object)newEnchantString));
                ConfigManager.setItemValue(itemId, "enchantments", enchantments);
                player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aEnchantment level has been updated!"));
            } else {
                player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: Corrupted enchantment data found at index " + index));
            }
        }
        catch (NumberFormatException ex) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cInvalid level. Please enter a whole number (e.g., 1, 5, 10)."));
            return;
        }
        pmu.setEditIndex(-1);
        this.closeChatInput(pmu);
        new EnchantmentListMenu(pmu, this.plugin).open();
    }

    private void handleAddEnchantment(Player player, PlayerMenuUtility pmu, String input, String path, String itemId) {
        String configPath = "items." + itemId + ".enchantments";
        ArrayList<String> enchantments = new ArrayList<String>(ItemsConfig.get().getStringList(configPath));
        String enchantName = path.substring(17);
        try {
            if (Enchantment.getByName((String)enchantName.toUpperCase()) == null) {
                throw new IllegalArgumentException("Invalid Enchantment name");
            }
            int level = Integer.parseInt(input);
            if (level <= 0) {
                player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cInvalid level. Please enter a positive whole number (e.g., 1, 5, 10)."));
                return;
            }
            if (this.enchantmentExists(enchantments, enchantName)) {
                player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: This enchantment already exists on the item."));
                this.closeChatInput(pmu);
                new EnchantmentListMenu(pmu, this.plugin).open();
                return;
            }
            String newEnchantString = enchantName + ";" + level;
            enchantments.add(newEnchantString);
            ConfigManager.setItemValue(itemId, "enchantments", enchantments);
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aEnchantment has been added!"));
        }
        catch (NumberFormatException ex) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cInvalid number format: " + input));
            return;
        }
        catch (IllegalArgumentException ex) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: Invalid enchantment name: " + enchantName));
            this.closeChatInput(pmu);
            new EnchantmentListMenu(pmu, this.plugin).open();
            return;
        }
        this.closeChatInput(pmu);
        new EnchantmentListMenu(pmu, this.plugin).open();
    }

    private void handleAddSetEffect(Player player, PlayerMenuUtility pmu, String input, String path, EffectType effectType) {
        String setId = pmu.getTempSetId();
        int count = pmu.getTempBonusCount();
        String basePath = "sets." + setId + ".bonuses." + count;
        String listKey = effectType == EffectType.POTION_EFFECT ? "potion_effects" : "attributes";
        String configPath = basePath + "." + listKey;
        String rawName = path.substring(effectType == EffectType.POTION_EFFECT ? 15 : 18);
        ArrayList<String> effects = new ArrayList<String>(SetsConfig.get().getStringList(configPath));
        try {
            String finalConfigString;
            if (effectType == EffectType.ATTRIBUTE) {
                String[] parts = rawName.split("\\.");
                if (parts.length < 2) {
                    throw new IllegalArgumentException("Invalid attribute path format");
                }
                String attrName = parts[0];
                String opName = parts[1];
                this.validateEffectName(EffectType.ATTRIBUTE, attrName);
                double amount = Double.parseDouble(input);
                String checkStr = attrName + ";" + opName;
                if (effects.stream().anyMatch(s -> s.toUpperCase().startsWith(checkStr.toUpperCase()))) {
                    throw new IllegalStateException("Duplicate attribute");
                }
                finalConfigString = attrName + ";" + opName + ";" + amount;
            } else {
                String potionName = rawName;
                this.validateEffectName(EffectType.POTION_EFFECT, potionName);
                int level = Integer.parseInt(input);
                if (level <= 0) {
                    throw new NumberFormatException();
                }
                if (this.effectExists(effects, potionName)) {
                    throw new IllegalStateException("Duplicate effect");
                }
                finalConfigString = potionName + ";" + level;
            }
            effects.add(finalConfigString);
            SetsConfig.get().set(configPath, effects);
            SetsConfig.save();
            this.plugin.getSetManager().loadSets(true);
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aSet bonus updated!"));
            this.closeChatInput(pmu);
            this.openSetEffectMenu(pmu, effectType);
        }
        catch (NumberFormatException ex) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cInvalid number. Please enter a valid number."));
        }
        catch (IllegalStateException ex) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: This effect already exists on the set bonus."));
            this.closeChatInput(pmu);
            this.openSetEffectMenu(pmu, effectType);
        }
        catch (Exception ex) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: " + ex.getMessage()));
            this.closeChatInput(pmu);
            this.openSetEffectMenu(pmu, effectType);
        }
    }

    private void handleEditSetEffect(Player player, PlayerMenuUtility pmu, String input, EffectType effectType) {
        String setId = pmu.getTempSetId();
        int count = pmu.getTempBonusCount();
        String basePath = "sets." + setId + ".bonuses." + count;
        String listKey = effectType == EffectType.POTION_EFFECT ? "potion_effects" : "attributes";
        String configPath = basePath + "." + listKey;
        List effects = SetsConfig.get().getStringList(configPath);
        int index = pmu.getEditIndex();
        if (index == -1 || index >= effects.size()) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: Invalid index."));
            this.closeChatInput(pmu);
            this.openSetEffectMenu(pmu, effectType);
            return;
        }
        try {
            String newEffectString;
            String currentString = (String)effects.get(index);
            String[] parts = currentString.split(";");
            if (effectType == EffectType.ATTRIBUTE) {
                if (parts.length < 3) {
                    throw new IllegalStateException("Corrupt attribute data");
                }
                double newAmount = Double.parseDouble(input);
                newEffectString = parts[0] + ";" + parts[1] + ";" + newAmount;
            } else {
                if (parts.length < 2) {
                    throw new IllegalStateException("Corrupt potion data");
                }
                int newLevel = Integer.parseInt(input);
                if (newLevel <= 0) {
                    throw new NumberFormatException();
                }
                newEffectString = parts[0] + ";" + newLevel;
            }
            effects.set(index, newEffectString);
            SetsConfig.get().set(configPath, (Object)effects);
            SetsConfig.save();
            this.plugin.getSetManager().loadSets(true);
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aSet bonus updated!"));
            pmu.setEditIndex(-1);
            this.closeChatInput(pmu);
            this.openSetEffectMenu(pmu, effectType);
        }
        catch (NumberFormatException ex) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cInvalid number."));
        }
        catch (Exception ex) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError updating effect: " + ex.getMessage()));
            this.closeChatInput(pmu);
            this.openSetEffectMenu(pmu, effectType);
        }
    }

    private void openSetEffectMenu(PlayerMenuUtility pmu, EffectType effectType) {
        new EffectListMenu(pmu, this.plugin, effectType == EffectType.POTION_EFFECT ? EffectListMenu.EffectType.POTION_EFFECT : EffectListMenu.EffectType.ATTRIBUTE, "SET_BONUS").open();
    }

    private void closeChatInput(PlayerMenuUtility pmu) {
        pmu.setWaitingForChatInput(false);
        pmu.setChatInputPath(null);
    }

    private void validateEffectName(EffectType effectType, String name) throws IllegalArgumentException {
        switch (effectType) {
            case POTION_EFFECT: {
                if (PotionEffectType.getByName((String)name.toUpperCase()) != null) break;
                throw new IllegalArgumentException("Invalid potion effect");
            }
            case ATTRIBUTE: {
                Attribute.valueOf((String)name.toUpperCase());
                break;
            }
            case ENCHANTMENT: {
                if (Enchantment.getByName((String)name.toUpperCase()) != null) break;
                throw new IllegalArgumentException("Invalid enchantment");
            }
        }
    }

    private void openAppropriateMenu(Player player, PlayerMenuUtility pmu, EffectType effectType, String context, String slot) {
        EffectListMenu.EffectType menuEffectType = effectType == EffectType.POTION_EFFECT ? EffectListMenu.EffectType.POTION_EFFECT : EffectListMenu.EffectType.ATTRIBUTE;
        new EffectListMenu(pmu, this.plugin, menuEffectType, context).open();
    }

    private boolean effectExists(List<String> effects, String effectName) {
        return effects.stream().anyMatch(s -> s.toUpperCase().startsWith(effectName.toUpperCase() + ";"));
    }

    private boolean enchantmentExists(List<String> enchantments, String enchantName) {
        return enchantments.stream().anyMatch(s -> s.toUpperCase().startsWith(enchantName.toUpperCase() + ";"));
    }

    private String capitalizeFirstLetter(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }
}

