/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.listener.handler;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.listener.handler.ChatInputHandler;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.config.ItemsConfig;
import io.github.altkat.BuffedItems.menu.active.CostListMenu;
import io.github.altkat.BuffedItems.menu.selector.TypeSelectorMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import su.nightexpress.coinsengine.api.CoinsEngineAPI;

public class CostInputHandler
implements ChatInputHandler {
    private final BuffedItems plugin;

    public CostInputHandler(BuffedItems plugin) {
        this.plugin = plugin;
    }

    @Override
    public void handle(Player player, PlayerMenuUtility pmu, String input, String path, String itemId) {
        if (path.equals("active.costs.add.ITEM_QUANTITY")) {
            this.handleItemQuantityInput(player, pmu, input, itemId);
            return;
        }
        if (path.equals("active.costs.add.BUFFED_ITEM_QUANTITY")) {
            this.handleBuffedItemQuantityInput(player, pmu, input, itemId);
            return;
        }
        if (path.startsWith("active.costs.add.")) {
            String type = path.substring(17);
            if (type.equals("BUFFED_ITEM_QUANTITY")) {
                type = "BUFFED_ITEM";
            }
            this.handleAddCost(player, pmu, input, type, itemId);
        } else if (path.equals("active.costs.edit.amount")) {
            this.handleEditCostAmount(player, pmu, input, itemId);
        } else if (path.equals("active.costs.edit.message")) {
            this.handleEditCostMessage(player, pmu, input, itemId);
        }
    }

    private void handleAddCost(Player player, PlayerMenuUtility pmu, String input, String type, String itemId) {
        LinkedHashMap<String, Object> newCost = new LinkedHashMap<String, Object>();
        newCost.put("type", type);
        try {
            if (type.equals("COINSENGINE")) {
                double amount;
                String currencyId = "coins";
                if (input.contains(";")) {
                    String[] parts = input.split(";");
                    if (parts.length != 2) {
                        throw new IllegalArgumentException("Invalid format");
                    }
                    amount = Double.parseDouble(parts[0]);
                    currencyId = parts[1];
                } else {
                    amount = Double.parseDouble(input);
                }
                if (amount <= 0.0) {
                    throw new NumberFormatException();
                }
                if (this.plugin.getServer().getPluginManager().getPlugin("CoinsEngine") != null && CoinsEngineAPI.getCurrency((String)currencyId) == null) {
                    player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7eWarning: Currency ID '" + currencyId + "' not found in CoinsEngine."));
                }
                newCost.put("currency_id", currencyId);
                newCost.put("amount", amount);
            } else if (type.equals("BUFFED_ITEM")) {
                String[] parts = input.split(";");
                if (parts.length != 2) {
                    throw new IllegalArgumentException("Invalid format");
                }
                int amount = Integer.parseInt(parts[0]);
                String buffedItemId = parts[1];
                if (this.plugin.getItemManager().getBuffedItem(buffedItemId) == null) {
                    player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7eWarning: Item ID '" + buffedItemId + "' is not loaded yet."));
                }
                newCost.put("item_id", buffedItemId);
                newCost.put("amount", amount);
            } else if (type.equals("ITEM")) {
                String[] parts = input.split(";");
                if (parts.length != 2) {
                    throw new IllegalArgumentException("Invalid format");
                }
                int amount = Integer.parseInt(parts[0]);
                String material = parts[1].toUpperCase();
                if (Material.matchMaterial((String)material) == null) {
                    player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cInvalid material: " + material));
                    this.closeChatInput(pmu);
                    new TypeSelectorMenu(pmu, this.plugin, PlayerMenuUtility.MaterialSelectionContext.COST).open();
                    return;
                }
                newCost.put("material", material);
                newCost.put("amount", amount);
            } else {
                double amount = Double.parseDouble(input);
                if (amount <= 0.0) {
                    throw new NumberFormatException();
                }
                if (amount == (double)((int)amount)) {
                    newCost.put("amount", (int)amount);
                } else {
                    newCost.put("amount", amount);
                }
            }
            List costs = ItemsConfig.get().getMapList("items." + itemId + ".active-mode.costs");
            costs.add(newCost);
            ConfigManager.setItemValue(itemId, "costs", costs);
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aCost added successfully!"));
            this.closeChatInput(pmu);
            new CostListMenu(pmu, this.plugin).open();
        }
        catch (Exception e) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cInvalid input."));
            if (type.equals("ITEM")) {
                player.sendMessage(ConfigManager.fromSection("\u00a77Use format: AMOUNT;MATERIAL"));
            } else if (type.equals("BUFFED_ITEM")) {
                player.sendMessage(ConfigManager.fromSection("\u00a77Use format: AMOUNT;ITEM_ID"));
            } else if (type.equals("COINSENGINE")) {
                player.sendMessage(ConfigManager.fromSection("\u00a77Use format: AMOUNT;CURRENCY_ID"));
            } else {
                player.sendMessage(ConfigManager.fromSection("\u00a77Please enter a valid positive number."));
            }
            pmu.setWaitingForChatInput(true);
            pmu.setChatInputPath("active.costs.add." + type);
        }
    }

    private void handleEditCostAmount(Player player, PlayerMenuUtility pmu, String input, String itemId) {
        int index = pmu.getEditIndex();
        List costList = ItemsConfig.get().getMapList("items." + itemId + ".active-mode.costs");
        if (index < 0 || index >= costList.size()) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: Cost index out of bounds."));
            this.closeChatInput(pmu);
            new CostListMenu(pmu, this.plugin).open();
            return;
        }
        ArrayList<Map> editableList = new ArrayList<Map>();
        for (Map map : costList) {
            editableList.add(map);
        }
        Map targetCost = (Map)editableList.get(index);
        String type = (String)targetCost.get("type");
        try {
            if ("ITEM".equals(type) || "LEVEL".equals(type) || "HUNGER".equals(type) || "BUFFED_ITEM".equals(type)) {
                int val = Integer.parseInt(input);
                if (val <= 0) {
                    throw new NumberFormatException();
                }
                targetCost.put("amount", val);
            } else {
                double val = Double.parseDouble(input);
                if (val <= 0.0) {
                    throw new NumberFormatException();
                }
                if (val == (double)((int)val)) {
                    targetCost.put("amount", (int)val);
                } else {
                    targetCost.put("amount", val);
                }
            }
            ConfigManager.setItemValue(itemId, "costs", editableList);
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aCost amount updated!"));
            this.closeChatInput(pmu);
            new CostListMenu(pmu, this.plugin).open();
        }
        catch (NumberFormatException e) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cInvalid amount. Please enter a positive number."));
            pmu.setWaitingForChatInput(true);
            pmu.setChatInputPath("active.costs.edit.amount");
        }
    }

    private void handleEditCostMessage(Player player, PlayerMenuUtility pmu, String input, String itemId) {
        int index = pmu.getEditIndex();
        List costList = ItemsConfig.get().getMapList("items." + itemId + ".active-mode.costs");
        if (index < 0 || index >= costList.size()) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: Cost index out of bounds."));
            this.closeChatInput(pmu);
            new CostListMenu(pmu, this.plugin).open();
            return;
        }
        ArrayList<Map> editableList = new ArrayList<Map>();
        for (Map map : costList) {
            editableList.add(map);
        }
        Map targetCost = (Map)editableList.get(index);
        if ("default".equalsIgnoreCase(input) || "reset".equalsIgnoreCase(input)) {
            targetCost.remove("message");
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aMessage reset to default config value."));
        } else {
            targetCost.put("message", input);
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aFailure message updated!"));
        }
        ConfigManager.setItemValue(itemId, "costs", editableList);
        this.closeChatInput(pmu);
        new CostListMenu(pmu, this.plugin).open();
    }

    private void handleBuffedItemQuantityInput(Player player, PlayerMenuUtility pmu, String input, String itemId) {
        try {
            int amount = Integer.parseInt(input);
            if (amount <= 0) {
                throw new NumberFormatException();
            }
            String selectedId = pmu.getTempId();
            String simulatedInput = amount + ";" + selectedId;
            this.handleAddCost(player, pmu, simulatedInput, "BUFFED_ITEM", itemId);
        }
        catch (NumberFormatException e) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cInvalid amount. Please enter a valid number."));
            pmu.setWaitingForChatInput(true);
            pmu.setChatInputPath("active.costs.add.BUFFED_ITEM_QUANTITY");
        }
    }

    private void handleItemQuantityInput(Player player, PlayerMenuUtility pmu, String input, String itemId) {
        try {
            int amount = Integer.parseInt(input);
            if (amount <= 0) {
                throw new NumberFormatException();
            }
            Material selectedMat = pmu.getTempMaterial();
            if (selectedMat == null) {
                player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: Session lost. Please select material again."));
                this.closeChatInput(pmu);
                return;
            }
            String simulatedInput = amount + ";" + selectedMat.name();
            this.handleAddCost(player, pmu, simulatedInput, "ITEM", itemId);
        }
        catch (NumberFormatException e) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cInvalid amount. Please enter a valid number."));
            pmu.setWaitingForChatInput(true);
            pmu.setChatInputPath("active.costs.add.ITEM_QUANTITY");
        }
    }

    private void closeChatInput(PlayerMenuUtility pmu) {
        pmu.setWaitingForChatInput(false);
        pmu.setChatInputPath(null);
    }
}

