/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.listener;

import com.destroystokyo.paper.event.player.PlayerArmorChangeEvent;
import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.config.RecipesConfig;
import io.github.altkat.BuffedItems.menu.base.Menu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class InventoryListener
implements Listener {
    private final BuffedItems plugin;
    private final NamespacedKey nbtKey;
    private final Map<UUID, Long> lastCheck = new ConcurrentHashMap<UUID, Long>();
    private static final long DEBOUNCE_MS = 100L;

    public InventoryListener(BuffedItems plugin) {
        this.plugin = plugin;
        this.nbtKey = new NamespacedKey((Plugin)plugin, "buffeditem_id");
    }

    private boolean isBuffedItem(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        return item.getItemMeta().getPersistentDataContainer().has(this.nbtKey, PersistentDataType.STRING);
    }

    private void scheduleInventoryCheckWithDebounce(Player player) {
        UUID uuid = player.getUniqueId();
        long now = System.currentTimeMillis();
        Long last = this.lastCheck.get(uuid);
        if (last == null || now - last >= 100L) {
            this.lastCheck.put(uuid, now);
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                this.plugin.getEffectApplicatorTask().markPlayerForUpdate(player.getUniqueId());
                ConfigManager.sendDebugMessage(4, () -> "[InventoryChange] (Debounced) Marked " + player.getName() + " for update.");
            }, 1L);
        } else {
            ConfigManager.sendDebugMessage(4, () -> "[InventoryChange] (Debounced) Skipped marking " + player.getName() + " (rate limited).");
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent e) {
        if (e.getWhoClicked() instanceof Player) {
            ItemStack updated;
            ItemStack clicked = e.getCurrentItem();
            if (this.isBuffedItem(clicked) && (updated = this.plugin.getItemUpdater().updateItem(clicked, (Player)e.getWhoClicked())) != null && !updated.isSimilar(clicked)) {
                e.setCurrentItem(updated);
                ConfigManager.sendDebugMessage(3, () -> "[LiveUpdate] Item updated in inventory click.");
            }
            if (this.isBuffedItem(e.getCurrentItem()) || this.isBuffedItem(e.getCursor())) {
                this.scheduleInventoryCheckWithDebounce((Player)e.getWhoClicked());
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onInventoryDrag(InventoryDragEvent e) {
        if (e.getWhoClicked() instanceof Player) {
            if (this.isBuffedItem(e.getOldCursor())) {
                this.scheduleInventoryCheckWithDebounce((Player)e.getWhoClicked());
                return;
            }
            for (ItemStack item : e.getNewItems().values()) {
                if (!this.isBuffedItem(item)) continue;
                this.scheduleInventoryCheckWithDebounce((Player)e.getWhoClicked());
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onItemPickup(EntityPickupItemEvent e) {
        LivingEntity livingEntity = e.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemStack item = e.getItem().getItemStack();
            if (this.isBuffedItem(item)) {
                ItemStack updated = this.plugin.getItemUpdater().updateItem(item, player);
                if (updated != null && !updated.isSimilar(item)) {
                    e.getItem().setItemStack(updated);
                }
                this.scheduleInventoryCheckWithDebounce(player);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onItemDrop(PlayerDropItemEvent e) {
        if (this.isBuffedItem(e.getItemDrop().getItemStack())) {
            this.scheduleInventoryCheckWithDebounce(e.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onItemHeld(PlayerItemHeldEvent e) {
        Player player = e.getPlayer();
        ItemStack item = player.getInventory().getItem(e.getNewSlot());
        if (this.isBuffedItem(item)) {
            ItemStack updated = this.plugin.getItemUpdater().updateItem(item, player);
            if (updated != null && !updated.isSimilar(item)) {
                player.getInventory().setItem(e.getNewSlot(), updated);
            }
            this.scheduleInventoryCheckWithDebounce(player);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onSwapHands(PlayerSwapHandItemsEvent e) {
        ItemStack updated;
        ItemStack offItem;
        ItemStack updated2;
        Player player = e.getPlayer();
        ItemStack mainItem = e.getMainHandItem();
        if (this.isBuffedItem(mainItem) && (updated2 = this.plugin.getItemUpdater().updateItem(mainItem, player)) != null && !updated2.isSimilar(mainItem)) {
            e.setMainHandItem(updated2);
        }
        if (this.isBuffedItem(offItem = e.getOffHandItem()) && (updated = this.plugin.getItemUpdater().updateItem(offItem, player)) != null && !updated.isSimilar(offItem)) {
            e.setOffHandItem(updated);
        }
        this.scheduleInventoryCheckWithDebounce(player);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onItemBreak(PlayerItemBreakEvent e) {
        if (this.isBuffedItem(e.getBrokenItem())) {
            this.scheduleInventoryCheckWithDebounce(e.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onArmorChange(PlayerArmorChangeEvent e) {
        Player player = e.getPlayer();
        ItemStack oldItem = e.getOldItem();
        ItemStack newItem = e.getNewItem();
        if ((oldItem == null || oldItem.getType().isAir()) && (newItem == null || newItem.getType().isAir())) {
            return;
        }
        UUID playerUUID = player.getUniqueId();
        ConfigManager.sendDebugMessage(4, () -> "[ArmorChange] Armor change detected for " + player.getName() + " in slot " + e.getSlotType().name() + ". Marking IMMEDIATE update.");
        this.plugin.getEffectApplicatorTask().markPlayerForUpdate(playerUUID);
    }

    public void clearPlayerData(UUID uuid) {
        this.lastCheck.remove(uuid);
        ConfigManager.sendDebugMessage(4, () -> "[InventoryChange] Cleared cached data for player: " + String.valueOf(uuid));
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent e) {
        if (!(e.getPlayer() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getPlayer();
        if (e.getInventory().getHolder() instanceof Menu) {
            PlayerMenuUtility pmu = BuffedItems.getPlayerMenuUtility(p);
            if (pmu.isWaitingForChatInput()) {
                return;
            }
            if (pmu.hasUnsavedChanges()) {
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    if (!p.isOnline()) {
                        return;
                    }
                    if (p.getOpenInventory().getTopInventory().getHolder() instanceof Menu) {
                        return;
                    }
                    RecipesConfig.save();
                    this.plugin.getCraftingManager().loadRecipes(true);
                    pmu.setUnsavedChanges(false);
                    p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7eUnsaved crafting changes have been auto-saved."));
                }, 1L);
            }
        }
    }
}

