/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.utility.item;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.utility.ItemUtils;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ItemUpdater {
    private final BuffedItems plugin;
    private final NamespacedKey idKey;
    private final NamespacedKey usesKey;
    private final NamespacedKey versionKey;
    private final NamespacedKey updateFlagKey;
    private final Map<UUID, Map<String, Long>> updateCooldowns = new ConcurrentHashMap<UUID, Map<String, Long>>();

    public ItemUpdater(BuffedItems plugin) {
        this.plugin = plugin;
        this.idKey = new NamespacedKey((Plugin)plugin, "buffeditem_id");
        this.usesKey = new NamespacedKey((Plugin)plugin, "remaining_active_uses");
        this.versionKey = new NamespacedKey((Plugin)plugin, "buffeditem_version");
        this.updateFlagKey = new NamespacedKey((Plugin)plugin, "needs_lore_update");
    }

    public ItemStack updateItem(ItemStack oldItem, Player player) {
        Map playerCooldowns;
        long lastUpdate;
        long now;
        boolean needsUpdate;
        if (oldItem == null || !oldItem.hasItemMeta()) {
            return null;
        }
        ItemMeta oldMeta = oldItem.getItemMeta();
        String itemId = (String)oldMeta.getPersistentDataContainer().get(this.idKey, PersistentDataType.STRING);
        if (itemId == null) {
            return null;
        }
        BuffedItem template = this.plugin.getItemManager().getBuffedItem(itemId);
        if (template == null) {
            return null;
        }
        boolean hasUsageLimit = template.isActiveMode() && template.getMaxUses() > 0;
        Integer currentHash = (Integer)oldMeta.getPersistentDataContainer().get(this.versionKey, PersistentDataType.INTEGER);
        boolean hasUpdateFlag = oldMeta.getPersistentDataContainer().has(this.updateFlagKey, PersistentDataType.BYTE);
        boolean bl = needsUpdate = currentHash == null || currentHash.intValue() != template.getUpdateHash();
        if (template.hasPlaceholders() && (now = System.currentTimeMillis()) - (lastUpdate = (playerCooldowns = this.updateCooldowns.computeIfAbsent(player.getUniqueId(), k -> new ConcurrentHashMap())).getOrDefault(itemId, 0L).longValue()) >= 3000L) {
            needsUpdate = true;
            playerCooldowns.put(itemId, now);
        }
        if (hasUsageLimit && hasUpdateFlag) {
            needsUpdate = true;
        }
        if (hasUsageLimit && !hasUpdateFlag && currentHash != null && currentHash.intValue() == template.getUpdateHash()) {
            needsUpdate = false;
        }
        if (!needsUpdate) {
            return null;
        }
        ItemStack newItem = oldItem.clone();
        if (newItem.getType() != template.getMaterial()) {
            newItem.setType(template.getMaterial());
        }
        ItemMeta meta = newItem.getItemMeta();
        String rawName = template.getDisplayName();
        String parsedName = template.hasPlaceholders() ? this.plugin.getHookManager().processPlaceholders((OfflinePlayer)player, rawName) : rawName;
        meta.displayName(ConfigManager.fromLegacy(parsedName));
        ArrayList<Component> baseLore = new ArrayList<Component>();
        for (String line : template.getLore()) {
            String string = template.hasPlaceholders() ? this.plugin.getHookManager().processPlaceholders((OfflinePlayer)player, line) : line;
            baseLore.add(ConfigManager.fromLegacy(string));
        }
        int currentUses = template.getMaxUses();
        if (template.isActiveMode() && template.getMaxUses() > 0) {
            if (meta.getPersistentDataContainer().has(this.usesKey, PersistentDataType.INTEGER)) {
                currentUses = (Integer)meta.getPersistentDataContainer().get(this.usesKey, PersistentDataType.INTEGER);
            } else {
                meta.getPersistentDataContainer().set(this.usesKey, PersistentDataType.INTEGER, (Object)currentUses);
            }
            String usageLineRaw = currentUses > 0 ? template.getUsageLore(currentUses) : template.getDepletedLore();
            Object object = template.hasPlaceholders() ? this.plugin.getHookManager().processPlaceholders((OfflinePlayer)player, usageLineRaw) : usageLineRaw;
            baseLore.add(ConfigManager.fromLegacy((String)object));
        } else {
            meta.getPersistentDataContainer().remove(this.usesKey);
        }
        meta.lore(baseLore);
        if (template.getCustomModelData().isPresent()) {
            meta.setCustomModelData(template.getCustomModelData().get());
        } else {
            meta.setCustomModelData(null);
        }
        for (Map.Entry entry : template.getEnchantments().entrySet()) {
            meta.addEnchant((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue(), true);
        }
        meta.setUnbreakable(template.getFlag("UNBREAKABLE"));
        meta.removeItemFlags(ItemFlag.values());
        ItemUtils.applyAttributes(template, meta);
        if (template.getFlag("HIDE_ENCHANTS")) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        if (template.getFlag("HIDE_ATTRIBUTES")) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        }
        if (template.getFlag("HIDE_UNBREAKABLE")) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
        }
        if (template.getFlag("HIDE_DESTROYS")) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
        }
        if (template.getFlag("HIDE_PLACED_ON")) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_PLACED_ON});
        }
        if (template.getFlag("HIDE_ADDITIONAL_TOOLTIP")) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
        }
        if (template.getFlag("HIDE_ARMOR_TRIM")) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ARMOR_TRIM});
        }
        if (template.hasGlow() && !meta.hasEnchants()) {
            meta.addEnchant(Enchantment.LUCK_OF_THE_SEA, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        meta.getPersistentDataContainer().set(this.versionKey, PersistentDataType.INTEGER, (Object)template.getUpdateHash());
        meta.getPersistentDataContainer().remove(this.updateFlagKey);
        newItem.setItemMeta(meta);
        boolean flagStillExists = meta.getPersistentDataContainer().has(this.updateFlagKey, PersistentDataType.BYTE);
        ConfigManager.sendDebugMessage(3, () -> "[ItemUpdater] Flag cleanup: " + (flagStillExists ? "FAILED \u274c" : "SUCCESS \u2705"));
        ConfigManager.sendDebugMessage(3, () -> "[ItemUpdater] Lore updated for item: " + itemId + " | Current uses in NBT: " + String.valueOf(newItem.getItemMeta().getPersistentDataContainer().has(this.usesKey, PersistentDataType.INTEGER) ? (Serializable)newItem.getItemMeta().getPersistentDataContainer().get(this.usesKey, PersistentDataType.INTEGER) : "NOT_SET"));
        return newItem;
    }
}

