/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.utility.item;

import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.utility.ItemUtils;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ItemBuilder {
    private final BuffedItem buffedItem;
    private final ItemStack itemStack;
    private final Plugin plugin;
    protected static final EquipmentSlot[] VALID_SLOTS = new EquipmentSlot[]{EquipmentSlot.HAND, EquipmentSlot.OFF_HAND, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};

    public ItemBuilder(BuffedItem buffedItem, Plugin plugin) {
        this.buffedItem = buffedItem;
        this.plugin = plugin;
        this.itemStack = new ItemStack(buffedItem.getMaterial());
    }

    public ItemStack build() {
        boolean hasRealEnchants;
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta == null) {
            return this.itemStack;
        }
        meta.displayName(ConfigManager.fromLegacy(this.buffedItem.getDisplayName()));
        List<Component> coloredLore = ConfigManager.loreFromLegacy(this.buffedItem.getLore());
        meta.lore(coloredLore);
        if (this.buffedItem.getCustomModelData().isPresent()) {
            int cmdValue = this.buffedItem.getCustomModelData().get();
            meta.setCustomModelData(Integer.valueOf(cmdValue));
            ConfigManager.sendDebugMessage(4, () -> "[ItemBuilder] Applied CMD (Integer): " + cmdValue + " to " + this.buffedItem.getId());
        }
        if (this.buffedItem.getFlag("UNBREAKABLE")) {
            meta.setUnbreakable(true);
        }
        boolean bl = hasRealEnchants = !this.buffedItem.getEnchantments().isEmpty();
        if (hasRealEnchants) {
            for (Map.Entry<Enchantment, Integer> entry : this.buffedItem.getEnchantments().entrySet()) {
                Enchantment enchantment = entry.getKey();
                int level = entry.getValue();
                try {
                    meta.addEnchant(enchantment, level, true);
                    ConfigManager.sendDebugMessage(3, () -> "[ItemBuilder] Applied enchantment: " + enchantment.getKey().getKey() + " Level: " + level + " to item " + this.buffedItem.getId());
                }
                catch (IllegalArgumentException e) {
                    ConfigManager.sendDebugMessage(1, () -> "[ItemBuilder] Failed to apply enchantment " + enchantment.getKey().getKey() + " with level " + level + " to item " + this.buffedItem.getId() + ": " + e.getMessage());
                }
            }
        }
        if (this.buffedItem.hasGlow() && (!hasRealEnchants || this.buffedItem.getFlag("HIDE_ENCHANTS"))) {
            meta.addEnchant(Enchantment.LUCK_OF_THE_SEA, 1, false);
        }
        ItemUtils.applyAttributes(this.buffedItem, meta);
        if (this.buffedItem.getFlag("HIDE_ENCHANTS")) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        if (this.buffedItem.getFlag("HIDE_ATTRIBUTES")) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        }
        if (this.buffedItem.getFlag("HIDE_UNBREAKABLE")) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
        }
        if (this.buffedItem.getFlag("HIDE_DESTROYS")) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
        }
        if (this.buffedItem.getFlag("HIDE_PLACED_ON")) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_PLACED_ON});
        }
        if (this.buffedItem.getFlag("HIDE_ADDITIONAL_TOOLTIP")) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
        }
        if (this.buffedItem.getFlag("HIDE_ARMOR_TRIM")) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ARMOR_TRIM});
        }
        NamespacedKey key = new NamespacedKey(this.plugin, "buffeditem_id");
        meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)this.buffedItem.getId());
        NamespacedKey versionKey = new NamespacedKey(this.plugin, "buffeditem_version");
        meta.getPersistentDataContainer().set(versionKey, PersistentDataType.INTEGER, (Object)this.buffedItem.getUpdateHash());
        if (this.buffedItem.isActiveMode() && this.buffedItem.getMaxUses() > 0) {
            NamespacedKey maxKey = new NamespacedKey(this.plugin, "remaining_active_uses");
            meta.getPersistentDataContainer().set(maxKey, PersistentDataType.INTEGER, (Object)this.buffedItem.getMaxUses());
            ArrayList<Component> lore = meta.lore();
            if (lore == null) {
                lore = new ArrayList<Component>();
            }
            String dynamicLore = this.buffedItem.getUsageLore(this.buffedItem.getMaxUses());
            lore.add(ConfigManager.fromLegacy(dynamicLore));
            meta.lore(lore);
        }
        this.itemStack.setItemMeta(meta);
        return this.itemStack;
    }
}

