/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.utility.item;

import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.cost.ICost;
import io.github.altkat.BuffedItems.utility.item.BuffedItemEffect;
import io.github.altkat.BuffedItems.utility.item.DepletionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class BuffedItem {
    private final String id;
    private final String displayName;
    private final List<String> lore;
    private Material material;
    private final boolean glow;
    private final Map<String, BuffedItemEffect> effects;
    private final String permission;
    private final String activePermission;
    private final String passivePermission;
    private final Map<Enchantment, Integer> enchantments;
    private final Integer customModelData;
    private final String customModelDataRaw;
    private ItemStack cachedItem;
    private final boolean activeMode;
    private final int cooldown;
    private final int maxUses;
    private final String customUsageLore;
    private final String customDepletedLore;
    private final String customDepletedMessage;
    private final String customDepletionNotification;
    private final int activeDuration;
    private final List<String> activeCommands;
    private final boolean visualChat;
    private final boolean visualTitle;
    private final boolean visualActionBar;
    private final boolean visualBossBar;
    private final String bossBarColor;
    private final String bossBarStyle;
    private final BuffedItemEffect activeEffects;
    private final String customChatMsg;
    private final String customTitleMsg;
    private final String customSubtitleMsg;
    private final String customActionBarMsg;
    private final String customBossBarMsg;
    private final String customSuccessSound;
    private final String customCooldownSound;
    private final String customCostFailSound;
    private final String customDepletionSound;
    private final String customDepletedTrySound;
    private final DepletionAction depletionAction;
    private final String depletionTransformId;
    private final List<String> depletionCommands;
    private final List<ICost> costs;
    private final AttributeMode attributeMode;
    private final int updateHash;
    private final boolean hasPlaceholders;
    private boolean isValid = true;
    private final List<String> errorMessages = new ArrayList<String>();
    private final Map<String, Boolean> flags;
    private static final Set<String> DEFAULT_TRUE_FLAGS = new HashSet<String>(Arrays.asList("HIDE_ATTRIBUTES", "HIDE_ENCHANTS", "HIDE_UNBREAKABLE", "HIDE_ADDITIONAL_TOOLTIP", "HIDE_DESTROYS", "HIDE_PLACED_ON", "HIDE_ARMOR_TRIM", "PREVENT_PLACEMENT"));

    public BuffedItem(String id, String displayName, List<String> lore, Material material, boolean glow, Map<String, BuffedItemEffect> effects, String permission, String activePermission, String passivePermission, Map<String, Boolean> flags, Map<Enchantment, Integer> enchantments, Integer customModelData, String customModelDataRaw, boolean activeMode, int cooldown, int maxUses, String customUsageLore, String customDepletedLore, String customDepletedMessage, String customDepletionNotification, int activeDuration, List<String> activeCommands, boolean visualChat, boolean visualTitle, boolean visualActionBar, boolean visualBossBar, String bossBarColor, String bossBarStyle, BuffedItemEffect activeEffects, String customChatMsg, String customTitleMsg, String customSubtitleMsg, String customActionBarMsg, String customBossBarMsg, String customSuccessSound, String customCooldownSound, String customCostFailSound, String customDepletionSound, String customDepletedTrySound, DepletionAction depletionAction, String depletionTransformId, List<String> depletionCommands, AttributeMode attributeMode, List<ICost> costs, int updateHash, boolean hasPlaceholders) {
        this.id = id;
        this.displayName = displayName;
        this.lore = lore;
        this.material = material;
        this.glow = glow;
        this.effects = effects;
        this.permission = permission;
        this.activePermission = activePermission;
        this.passivePermission = passivePermission;
        this.flags = flags != null ? flags : new HashMap();
        this.enchantments = enchantments != null ? enchantments : new HashMap();
        this.customModelData = customModelData;
        this.customModelDataRaw = customModelDataRaw;
        this.activeMode = activeMode;
        this.cooldown = cooldown;
        this.maxUses = maxUses;
        this.activeDuration = activeDuration;
        this.customUsageLore = customUsageLore;
        this.customDepletedLore = customDepletedLore;
        this.customDepletedMessage = customDepletedMessage;
        this.customDepletionNotification = customDepletionNotification;
        this.activeCommands = activeCommands != null ? activeCommands : new ArrayList();
        this.visualChat = visualChat;
        this.visualTitle = visualTitle;
        this.visualActionBar = visualActionBar;
        this.visualBossBar = visualBossBar;
        this.bossBarColor = bossBarColor;
        this.bossBarStyle = bossBarStyle;
        this.activeEffects = activeEffects;
        this.customChatMsg = customChatMsg;
        this.customTitleMsg = customTitleMsg;
        this.customSubtitleMsg = customSubtitleMsg;
        this.customActionBarMsg = customActionBarMsg;
        this.customBossBarMsg = customBossBarMsg;
        this.customSuccessSound = customSuccessSound;
        this.customCooldownSound = customCooldownSound;
        this.customCostFailSound = customCostFailSound;
        this.customDepletionSound = customDepletionSound;
        this.customDepletedTrySound = customDepletedTrySound;
        this.depletionAction = depletionAction;
        this.depletionTransformId = depletionTransformId;
        this.depletionCommands = depletionCommands != null ? depletionCommands : new ArrayList();
        this.attributeMode = attributeMode;
        this.costs = costs != null ? costs : new ArrayList();
        this.updateHash = updateHash;
        this.hasPlaceholders = hasPlaceholders;
    }

    public boolean getFlag(String flagName) {
        String id = flagName.toUpperCase();
        if (this.flags.containsKey(id)) {
            return this.flags.getOrDefault(id, false);
        }
        return DEFAULT_TRUE_FLAGS.contains(id);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public Material getMaterial() {
        return this.material;
    }

    public boolean hasGlow() {
        return this.glow;
    }

    public Map<String, BuffedItemEffect> getEffects() {
        return this.effects;
    }

    public String getPermission() {
        return this.permission;
    }

    public String getActivePermissionRaw() {
        return this.activePermission;
    }

    public String getPassivePermissionRaw() {
        return this.passivePermission;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public void addErrorMessage(String message) {
        this.isValid = false;
        this.errorMessages.add(message);
    }

    public Map<String, Boolean> getFlags() {
        return this.flags;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public Map<Enchantment, Integer> getEnchantments() {
        return this.enchantments;
    }

    public Optional<Integer> getCustomModelData() {
        return Optional.ofNullable(this.customModelData);
    }

    public Optional<String> getCustomModelDataRaw() {
        return Optional.ofNullable(this.customModelDataRaw);
    }

    public boolean isActiveMode() {
        return this.activeMode;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public int getMaxUses() {
        return this.maxUses;
    }

    public String getUsageLore(int currentUses) {
        String format = this.customUsageLore != null && !this.customUsageLore.isEmpty() ? this.customUsageLore : ConfigManager.getGlobalUsageLore();
        return format.replace("{remaining_uses}", String.valueOf(currentUses)).replace("{total_uses}", String.valueOf(this.maxUses));
    }

    public String getDepletedLore() {
        return this.customDepletedLore != null && !this.customDepletedLore.isEmpty() ? this.customDepletedLore : ConfigManager.getGlobalDepletedLore();
    }

    public String getDepletedMessage() {
        return this.customDepletedMessage != null && !this.customDepletedMessage.isEmpty() ? this.customDepletedMessage : ConfigManager.getGlobalDepletedMessage();
    }

    public String getDepletionNotification() {
        return this.customDepletionNotification != null && !this.customDepletionNotification.isEmpty() ? this.customDepletionNotification : ConfigManager.getGlobalDepletionNotification();
    }

    public int getActiveDuration() {
        return this.activeDuration;
    }

    public List<String> getActiveCommands() {
        return this.activeCommands;
    }

    public boolean isVisualChat() {
        return this.visualChat;
    }

    public boolean isVisualTitle() {
        return this.visualTitle;
    }

    public boolean isVisualActionBar() {
        return this.visualActionBar;
    }

    public boolean isVisualBossBar() {
        return this.visualBossBar;
    }

    public String getBossBarColor() {
        return this.bossBarColor;
    }

    public String getBossBarStyle() {
        return this.bossBarStyle;
    }

    public BuffedItemEffect getActiveEffects() {
        return this.activeEffects;
    }

    public String getCustomChatMsg() {
        return this.customChatMsg;
    }

    public String getCustomTitleMsg() {
        return this.customTitleMsg;
    }

    public String getCustomSubtitleMsg() {
        return this.customSubtitleMsg;
    }

    public String getCustomActionBarMsg() {
        return this.customActionBarMsg;
    }

    public String getCustomBossBarMsg() {
        return this.customBossBarMsg;
    }

    public String getCustomSuccessSound() {
        return this.customSuccessSound;
    }

    public String getCustomCooldownSound() {
        return this.customCooldownSound;
    }

    public String getCustomCostFailSound() {
        return this.customCostFailSound;
    }

    public String getCustomDepletionSound() {
        return this.customDepletionSound;
    }

    public String getCustomDepletedTrySound() {
        return this.customDepletedTrySound;
    }

    public DepletionAction getDepletionAction() {
        return this.depletionAction;
    }

    public String getDepletionTransformId() {
        return this.depletionTransformId;
    }

    public List<String> getDepletionCommands() {
        return this.depletionCommands;
    }

    public AttributeMode getAttributeMode() {
        return this.attributeMode;
    }

    public List<ICost> getCosts() {
        return this.costs;
    }

    public int getUpdateHash() {
        return this.updateHash;
    }

    public boolean hasPlaceholders() {
        return this.hasPlaceholders;
    }

    public void setCachedItem(ItemStack cachedItem) {
        this.cachedItem = cachedItem;
    }

    public ItemStack getCachedItem() {
        return this.cachedItem;
    }

    public boolean hasActivePermission(Player player) {
        if (this.activePermission != null && !this.activePermission.equalsIgnoreCase("NONE")) {
            return player.hasPermission(this.activePermission);
        }
        if (this.permission != null) {
            return player.hasPermission(this.permission);
        }
        return true;
    }

    public boolean hasPassivePermission(Player player) {
        if (this.passivePermission != null && !this.passivePermission.equalsIgnoreCase("NONE")) {
            return player.hasPermission(this.passivePermission);
        }
        if (this.permission != null) {
            return player.hasPermission(this.permission);
        }
        return true;
    }

    public static enum AttributeMode {
        STATIC,
        DYNAMIC;

    }
}

