/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.utility;

import io.github.altkat.BuffedItems.utility.attribute.ParsedAttribute;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import io.github.altkat.BuffedItems.utility.item.BuffedItemEffect;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemUtils {
    public static final EquipmentSlot[] VALID_SLOTS = new EquipmentSlot[]{EquipmentSlot.HAND, EquipmentSlot.OFF_HAND, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};

    public static void applyAttributes(BuffedItem item, ItemMeta meta) {
        meta.setAttributeModifiers(null);
        boolean forceHideAttributes = false;
        if (item.getAttributeMode() == BuffedItem.AttributeMode.STATIC) {
            boolean hasAnyAttribute = false;
            for (Map.Entry<String, BuffedItemEffect> effectEntry : item.getEffects().entrySet()) {
                String slotKey = effectEntry.getKey().toUpperCase();
                BuffedItemEffect itemEffect = effectEntry.getValue();
                EquipmentSlot equipmentSlot = ItemUtils.getEquipmentSlot(slotKey);
                if (equipmentSlot == null) continue;
                for (ParsedAttribute parsedAttr : itemEffect.getParsedAttributes()) {
                    AttributeModifier modifier = new AttributeModifier(parsedAttr.getUuid(), "buffeditems." + item.getId() + "." + slotKey, parsedAttr.getAmount(), parsedAttr.getOperation(), equipmentSlot);
                    meta.addAttributeModifier(parsedAttr.getAttribute(), modifier);
                    hasAnyAttribute = true;
                }
            }
            if (!hasAnyAttribute) {
                ItemUtils.applyDummyAttributes(item, meta);
                forceHideAttributes = true;
            }
        } else {
            ItemUtils.applyDummyAttributes(item, meta);
            forceHideAttributes = true;
        }
        if (item.getFlag("HIDE_ATTRIBUTES") || forceHideAttributes) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        }
    }

    private static void applyDummyAttributes(BuffedItem item, ItemMeta meta) {
        Attribute dummyAttr = Attribute.GENERIC_LUCK;
        for (EquipmentSlot slot : VALID_SLOTS) {
            UUID dummyUUID = UUID.nameUUIDFromBytes(("buffeditems.dummy.static." + item.getId() + "." + slot.name()).getBytes(StandardCharsets.UTF_8));
            AttributeModifier dummyMod = new AttributeModifier(dummyUUID, "buffeditems.dummy." + slot.name(), 0.0, AttributeModifier.Operation.ADD_NUMBER, slot);
            meta.addAttributeModifier(dummyAttr, dummyMod);
        }
    }

    public static EquipmentSlot getEquipmentSlot(String slot) {
        switch (slot.toUpperCase()) {
            case "MAIN_HAND": {
                return EquipmentSlot.HAND;
            }
            case "OFF_HAND": {
                return EquipmentSlot.OFF_HAND;
            }
            case "HELMET": {
                return EquipmentSlot.HEAD;
            }
            case "CHESTPLATE": {
                return EquipmentSlot.CHEST;
            }
            case "LEGGINGS": {
                return EquipmentSlot.LEGS;
            }
            case "BOOTS": {
                return EquipmentSlot.FEET;
            }
        }
        return null;
    }
}

