/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.utility;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.config.RecipesConfig;
import io.github.altkat.BuffedItems.manager.config.SetsConfig;
import io.github.altkat.BuffedItems.manager.config.UpgradesConfig;
import io.github.altkat.BuffedItems.menu.base.Menu;
import io.github.altkat.BuffedItems.menu.crafting.RecipeListMenu;
import io.github.altkat.BuffedItems.menu.set.SetListMenu;
import io.github.altkat.BuffedItems.menu.upgrade.UpgradeRecipeListMenu;
import io.github.altkat.BuffedItems.menu.utility.GeneralSettingsMenu;
import io.github.altkat.BuffedItems.menu.utility.ItemListMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import java.util.ArrayList;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class MainMenu
extends Menu {
    private final BuffedItems plugin;

    public MainMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
        playerMenuUtility.flushData();
    }

    @Override
    public String getMenuName() {
        return "BuffedItems > Dashboard";
    }

    @Override
    public int getSlots() {
        return 45;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        if (e.getCurrentItem() == null) {
            return;
        }
        Material type = e.getCurrentItem().getType();
        if (type == Material.GRAY_DYE) {
            p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.5f);
            p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cThis feature is currently disabled in config."));
            return;
        }
        switch (e.getSlot()) {
            case 11: {
                new ItemListMenu(this.playerMenuUtility, this.plugin).open();
                break;
            }
            case 13: {
                new SetListMenu(this.playerMenuUtility, this.plugin).open();
                break;
            }
            case 15: {
                new UpgradeRecipeListMenu(this.playerMenuUtility, this.plugin).open();
                break;
            }
            case 21: {
                new RecipeListMenu(this.playerMenuUtility, this.plugin).open();
                break;
            }
            case 23: {
                new GeneralSettingsMenu(this.playerMenuUtility, this.plugin).open();
                break;
            }
            case 31: {
                this.handlePluginInfo(p);
                break;
            }
            case 44: {
                p.closeInventory();
            }
        }
    }

    @Override
    public void setMenuItems() {
        this.setFillerGlass();
        this.inventory.setItem(11, this.makeItem(Material.DIAMOND_SWORD, "\u00a7bItem Editor", "\u00a77Create, edit and manage", "\u00a77your custom items.", "", "\u00a7eClick to Open"));
        if (SetsConfig.get().getBoolean("settings.enabled", true)) {
            this.inventory.setItem(13, this.makeItem(Material.GOLDEN_CHESTPLATE, "\u00a76Item Sets", "\u00a77Create armor sets with", "\u00a77tiered bonuses.", "", "\u00a7eClick to Manage"));
        } else {
            this.inventory.setItem(13, this.makeDisabledItem("Item Sets"));
        }
        if (UpgradesConfig.get().getBoolean("settings.enabled", true)) {
            this.inventory.setItem(15, this.makeItem(Material.SMITHING_TABLE, "\u00a7eUpgrades", "\u00a77Create upgrade recipes and", "\u00a77evolution paths.", "", "\u00a7eClick to Manage"));
        } else {
            this.inventory.setItem(15, this.makeDisabledItem("Upgrades"));
        }
        if (RecipesConfig.get().getBoolean("settings.enabled", true)) {
            this.inventory.setItem(21, this.makeItem(Material.CRAFTING_TABLE, "\u00a7aCustom Crafting", "\u00a77Create shaped recipes for", "\u00a77your custom items.", "", "\u00a7eClick to Manage"));
        } else {
            this.inventory.setItem(21, this.makeDisabledItem("Custom Crafting"));
        }
        this.inventory.setItem(23, this.makeItem(Material.COMPARATOR, "\u00a77General Settings", "\u00a77Configure global settings", "\u00a77(Debug, Visuals, etc.)", "", "\u00a7eClick to Open"));
        ArrayList<Object> infoLore = new ArrayList<Object>();
        infoLore.add("\u00a77Version: \u00a7f" + this.plugin.getDescription().getVersion());
        infoLore.add("");
        infoLore.add("\u00a7bLinks:");
        infoLore.add("\u00a7f\u2022 Wiki / Docs");
        infoLore.add("\u00a7f\u2022 Discord Support");
        infoLore.add("");
        infoLore.add("\u00a7eClick to print links in chat.");
        this.inventory.setItem(31, this.makeItem(Material.BOOK, "\u00a7dPlugin Information", infoLore.toArray(new String[0])));
        this.inventory.setItem(44, this.makeItem(Material.BARRIER, "\u00a7cClose Menu", new String[0]));
    }

    private ItemStack makeDisabledItem(String name) {
        ItemStack item = this.makeItem(Material.GRAY_DYE, "\u00a77" + name, "", "\u00a7c[DISABLED]", "\u00a77Enable in config to use.");
        return item;
    }

    private void handlePluginInfo(Player p) {
        p.closeInventory();
        p.sendMessage(ConfigManager.fromSection("\u00a78\u00a7m-------------------------------------------"));
        p.sendMessage(ConfigManager.fromSection("\u00a76\u00a7lBuffedItems Information"));
        p.sendMessage((Component)Component.empty());
        Component wikiLink = ((TextComponent)((TextComponent)Component.text((String)"Click Here", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.UNDERLINED, true)).clickEvent(ClickEvent.openUrl((String)"https://github.com/AltKat/BuffedItems/wiki"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)ConfigManager.fromSection("\u00a77Click to open the Wiki page.")));
        p.sendMessage(ConfigManager.fromSection("\u00a7bWiki & Docs: ").append(wikiLink));
        p.sendMessage((Component)Component.empty());
        Component discordLink = ((TextComponent)((TextComponent)Component.text((String)"Click Here", (TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.UNDERLINED, true)).clickEvent(ClickEvent.openUrl((String)"https://discord.gg/nxY3fc7xz9"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)ConfigManager.fromSection("\u00a77Click to join our Discord server.")));
        p.sendMessage(ConfigManager.fromSection("\u00a79Discord Support: ").append(discordLink));
        p.sendMessage(ConfigManager.fromSection("\u00a78\u00a7m-------------------------------------------"));
        p.playSound(p.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
    }
}

