/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.upgrade;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.config.UpgradesConfig;
import io.github.altkat.BuffedItems.manager.cost.ICost;
import io.github.altkat.BuffedItems.manager.cost.types.BuffedItemCost;
import io.github.altkat.BuffedItems.manager.upgrade.UpgradeRecipe;
import io.github.altkat.BuffedItems.menu.base.PaginatedMenu;
import io.github.altkat.BuffedItems.menu.upgrade.UpgradeRecipeEditorMenu;
import io.github.altkat.BuffedItems.menu.utility.MainMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import io.github.altkat.BuffedItems.utility.item.ItemBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class UpgradeRecipeListMenu
extends PaginatedMenu {
    private final BuffedItems plugin;

    public UpgradeRecipeListMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.maxItemsPerPage = 36;
    }

    @Override
    public String getMenuName() {
        return "Upgrade Recipes";
    }

    @Override
    public int getSlots() {
        return 54;
    }

    private List<UpgradeRecipe> getSortedRecipes() {
        ArrayList<UpgradeRecipe> recipes = new ArrayList<UpgradeRecipe>(this.plugin.getUpgradeManager().getRecipes().values());
        recipes.sort(Comparator.comparing(UpgradeRecipe::getId));
        return recipes;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        List<UpgradeRecipe> recipes = this.getSortedRecipes();
        if (e.getCurrentItem() == null) {
            return;
        }
        if (this.handlePageChange(e, recipes.size())) {
            return;
        }
        if (e.getSlot() == 49) {
            this.playerMenuUtility.setWaitingForChatInput(true);
            this.playerMenuUtility.setChatInputPath("create_upgrade");
            p.closeInventory();
            p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aEnter a unique ID for the new upgrade recipe (e.g. 'sword_upgrade')."));
            return;
        }
        if (e.getSlot() == 51) {
            boolean current = UpgradesConfig.get().getBoolean("settings.browser-button", true);
            UpgradesConfig.get().set("settings.browser-button", (Object)(!current ? 1 : 0));
            UpgradesConfig.save();
            UpgradesConfig.reload();
            p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            this.open();
            return;
        }
        if (e.getSlot() == 53) {
            new MainMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
        if (e.getSlot() >= 9 && e.getSlot() < 45) {
            int index = this.maxItemsPerPage * this.page + (e.getSlot() - 9);
            if (index >= recipes.size()) {
                return;
            }
            UpgradeRecipe recipe = recipes.get(index);
            if (e.getClick() == ClickType.LEFT) {
                this.playerMenuUtility.setItemToEditId(recipe.getId());
                new UpgradeRecipeEditorMenu(this.playerMenuUtility, this.plugin).open();
            } else if (e.getClick() == ClickType.RIGHT) {
                ConfigManager.setUpgradeValue(recipe.getId(), null, null);
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cUpgrade recipe '" + recipe.getId() + "' deleted."));
                this.open();
            }
        }
    }

    @Override
    public void setMenuItems() {
        int index;
        int i;
        ItemStack filler = this.makeItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        for (i = 0; i < 9; ++i) {
            this.inventory.setItem(i, filler);
        }
        for (i = 45; i < 54; ++i) {
            this.inventory.setItem(i, filler);
        }
        this.addMenuControls();
        this.inventory.setItem(49, this.makeItem(Material.ANVIL, "\u00a7aCreate New Recipe", "\u00a77Click to create a new upgrade recipe."));
        this.inventory.setItem(53, this.makeItem(Material.BARRIER, "\u00a7cBack to Main Menu", new String[0]));
        boolean browserEnabled = UpgradesConfig.get().getBoolean("settings.browser-button", true);
        String status = browserEnabled ? "\u00a7aEnabled" : "\u00a7cDisabled";
        this.inventory.setItem(51, this.makeItem(Material.BOOKSHELF, "\u00a76Station Browser Button", "\u00a77Toggle the visibility of the", "\u00a77'Browse All Recipes' button", "\u00a77in the Upgrade Station (/bi upgrade).", "", "\u00a77Current: " + status, "", "\u00a7eClick to Toggle"));
        List<UpgradeRecipe> recipes = this.getSortedRecipes();
        for (int i2 = 0; i2 < this.maxItemsPerPage && (index = this.maxItemsPerPage * this.page + i2) < recipes.size(); ++i2) {
            ItemStack iconStack;
            UpgradeRecipe recipe = recipes.get(index);
            String title = ConfigManager.toSection(ConfigManager.fromLegacy(recipe.getDisplayName()));
            Object resultName = "\u00a7f" + recipe.getResultItemId();
            BuffedItem resultItem = this.plugin.getItemManager().getBuffedItem(recipe.getResultItemId());
            if (resultItem != null) {
                resultName = ConfigManager.toSection(ConfigManager.fromLegacy(resultItem.getDisplayName()));
            }
            if (recipe.getResultAmount() > 1) {
                resultName = (String)resultName + " \u00a7e(x" + recipe.getResultAmount() + ")";
            }
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add("\u00a78ID: " + recipe.getId());
            lore.add("");
            Object baseName = "\u00a7cUnknown";
            if (recipe.getBaseCost() != null) {
                baseName = "\u00a7f" + recipe.getBaseCost().getDisplayString();
                if (recipe.getBaseCost() instanceof BuffedItemCost) {
                    String bId = ((BuffedItemCost)recipe.getBaseCost()).getRequiredItemId();
                    BuffedItem bItem = this.plugin.getItemManager().getBuffedItem(bId);
                    if (bItem != null) {
                        baseName = ConfigManager.toSection(ConfigManager.fromLegacy(bItem.getDisplayName()));
                    }
                }
            }
            lore.add("\u00a77From: " + (String)baseName);
            lore.add("\u00a77To: " + (String)resultName);
            lore.add("");
            String chanceColor = recipe.getSuccessRate() >= 100.0 ? "\u00a7a" : (recipe.getSuccessRate() >= 50.0 ? "\u00a7e" : "\u00a7c");
            lore.add("\u00a77Chance: " + chanceColor + recipe.getSuccessRate() + "%");
            lore.add("\u00a77Ingredients: \u00a7f" + recipe.getIngredients().size());
            if (!recipe.isValid()) {
                lore.add("");
                lore.add("\u00a7c\u00a7l\u26a0 CONFIGURATION ERRORS:");
                for (String err : recipe.getErrorMessages()) {
                    lore.add("\u00a7c- " + err);
                }
            }
            lore.add("");
            lore.add("\u00a78\u00a7m------------------");
            lore.add("\u00a7eLeft-Click to Edit");
            lore.add("\u00a7cRight-Click to Delete");
            ICost baseCost = recipe.getBaseCost();
            if (!recipe.isValid()) {
                iconStack = new ItemStack(Material.BARRIER);
            } else {
                BuffedItemCost bCost = (BuffedItemCost)baseCost;
                String bId = bCost.getRequiredItemId();
                BuffedItem bItem = this.plugin.getItemManager().getBuffedItem(bId);
                iconStack = bItem != null ? new ItemBuilder(bItem, (Plugin)this.plugin).build() : new ItemStack(Material.BEDROCK);
            }
            ItemMeta meta = iconStack.getItemMeta();
            if (meta != null) {
                meta.displayName(ConfigManager.fromSection(title));
                ArrayList<Component> loreComps = new ArrayList<Component>();
                for (String string : lore) {
                    loreComps.add(ConfigManager.fromSection(string));
                }
                meta.lore(loreComps);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_ADDITIONAL_TOOLTIP, ItemFlag.HIDE_UNBREAKABLE});
                iconStack.setItemMeta(meta);
            }
            this.inventory.setItem(9 + i2, iconStack);
        }
    }
}

