/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.upgrade;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.config.UpgradesConfig;
import io.github.altkat.BuffedItems.manager.cost.ICost;
import io.github.altkat.BuffedItems.manager.cost.types.BuffedItemCost;
import io.github.altkat.BuffedItems.manager.cost.types.ItemCost;
import io.github.altkat.BuffedItems.manager.upgrade.FailureAction;
import io.github.altkat.BuffedItems.manager.upgrade.UpgradeRecipe;
import io.github.altkat.BuffedItems.menu.base.Menu;
import io.github.altkat.BuffedItems.menu.upgrade.UpgradeRecipeBrowserMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import io.github.altkat.BuffedItems.utility.item.ItemBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class UpgradeMenu
extends Menu {
    private final BuffedItems plugin;
    private final int INPUT_SLOT = 10;
    private final int OUTPUT_SLOT = 16;
    private final int INFO_SLOT = 13;
    private final int NEXT_RECIPE_SLOT = 14;
    private List<UpgradeRecipe> matchingRecipes = new ArrayList<UpgradeRecipe>();
    private int currentRecipeIndex = 0;

    public UpgradeMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
    }

    @Override
    public String getMenuName() {
        return "Item Upgrade Station";
    }

    @Override
    public int getSlots() {
        return 27;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        if (e.getClickedInventory() == e.getView().getBottomInventory()) {
            if (e.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
                e.setCancelled(true);
                ItemStack currentInput = this.inventory.getItem(10);
                if ((currentInput == null || currentInput.getType() == Material.AIR) && e.getCurrentItem() != null) {
                    this.inventory.setItem(10, e.getCurrentItem().clone());
                    e.setCurrentItem(null);
                    this.updateMenuState();
                }
            } else {
                e.setCancelled(false);
            }
            return;
        }
        if (e.getClickedInventory() == this.inventory) {
            if (e.getSlot() == 10) {
                e.setCancelled(false);
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    this.currentRecipeIndex = 0;
                    this.updateMenuState();
                });
                return;
            }
            e.setCancelled(true);
            if (e.getCurrentItem() == null) {
                return;
            }
            if (e.getSlot() == 16) {
                this.handleUpgrade((Player)e.getWhoClicked());
            } else if (e.getSlot() == 14 && e.getCurrentItem().getType() == Material.LIME_STAINED_GLASS_PANE) {
                ++this.currentRecipeIndex;
                if (this.currentRecipeIndex >= this.matchingRecipes.size()) {
                    this.currentRecipeIndex = 0;
                }
                this.updateVisualsForCurrentRecipe();
                Player p = (Player)e.getWhoClicked();
                p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            } else if (e.getSlot() == 22 && e.getCurrentItem().getType() == Material.BOOK) {
                new UpgradeRecipeBrowserMenu(this.playerMenuUtility, this.plugin).open();
                return;
            }
        }
    }

    @Override
    public void handleClose(InventoryCloseEvent e) {
        ItemStack inputItem = this.inventory.getItem(10);
        if (inputItem != null && inputItem.getType() != Material.AIR) {
            Player player = (Player)e.getPlayer();
            for (ItemStack drop : player.getInventory().addItem(new ItemStack[]{inputItem}).values()) {
                player.getWorld().dropItemNaturally(player.getLocation(), drop);
            }
        }
    }

    @Override
    public void setMenuItems() {
        this.setFillerGlass();
        this.inventory.setItem(10, null);
        this.inventory.setItem(16, this.makeItem(Material.BARRIER, "\u00a7cNo Recipe Found", "\u00a77Place a valid item to see upgrades."));
        this.inventory.setItem(11, this.makeItem(Material.GRAY_STAINED_GLASS_PANE, " ", new String[0]));
        this.inventory.setItem(12, this.makeItem(Material.GRAY_STAINED_GLASS_PANE, " ", new String[0]));
        this.inventory.setItem(13, this.makeItem(Material.ANVIL, "\u00a7eUpgrade Info", "\u00a77Waiting for item..."));
        this.inventory.setItem(14, this.makeItem(Material.GRAY_STAINED_GLASS_PANE, " ", new String[0]));
        this.inventory.setItem(15, this.makeItem(Material.ARROW, "\u00a7e->", new String[0]));
        boolean showBrowser = UpgradesConfig.get().getBoolean("settings.browser-button", true);
        if (showBrowser) {
            this.inventory.setItem(22, this.makeItem(Material.BOOK, "\u00a7aBrowse All Recipes", "\u00a77Click to view a list of", "\u00a77all available upgrades on the server."));
        }
    }

    private void updateMenuState() {
        ItemStack inputItem = this.inventory.getItem(10);
        this.matchingRecipes.clear();
        if (inputItem == null || inputItem.getType() == Material.AIR) {
            this.inventory.setItem(16, this.makeItem(Material.BARRIER, "\u00a7cNo Item", "\u00a77Place an item in the left slot."));
            this.inventory.setItem(13, this.makeItem(Material.ANVIL, "\u00a7eUpgrade Info", "\u00a77Waiting for item..."));
            this.inventory.setItem(14, this.makeItem(Material.GRAY_STAINED_GLASS_PANE, " ", new String[0]));
            return;
        }
        this.matchingRecipes = this.findAllRecipes(inputItem);
        if (this.matchingRecipes.isEmpty()) {
            this.inventory.setItem(16, this.makeItem(Material.RED_STAINED_GLASS_PANE, "\u00a7cInvalid Item", "\u00a77No upgrade recipe found for this item."));
            this.inventory.setItem(13, this.makeItem(Material.ANVIL, "\u00a7eUpgrade Info", "\u00a7cThis item cannot be upgraded."));
            this.inventory.setItem(14, this.makeItem(Material.GRAY_STAINED_GLASS_PANE, " ", new String[0]));
        } else {
            if (this.currentRecipeIndex >= this.matchingRecipes.size()) {
                this.currentRecipeIndex = 0;
            }
            this.updateVisualsForCurrentRecipe();
        }
    }

    private void updateVisualsForCurrentRecipe() {
        Component originalName;
        ItemMeta meta;
        UpgradeRecipe recipe = this.matchingRecipes.get(this.currentRecipeIndex);
        ItemStack inputItem = this.inventory.getItem(10);
        BuffedItem resultBuffedItem = this.plugin.getItemManager().getBuffedItem(recipe.getResultItemId());
        ItemStack resultStack = resultBuffedItem != null ? new ItemBuilder(resultBuffedItem, (Plugin)this.plugin).build() : new ItemStack(Material.BARRIER);
        resultStack.setAmount(recipe.getResultAmount());
        if (recipe.getResultAmount() > 1 && (meta = resultStack.getItemMeta()) != null && meta.hasDisplayName() && (originalName = meta.displayName()) != null) {
            Component amountSuffix = ConfigManager.fromLegacy(" &e(x" + recipe.getResultAmount() + ")");
            meta.displayName(originalName.append(amountSuffix));
            resultStack.setItemMeta(meta);
        }
        this.inventory.setItem(16, resultStack);
        if (this.matchingRecipes.size() > 1) {
            this.inventory.setItem(14, this.makeItem(Material.LIME_STAINED_GLASS_PANE, "\u00a7aNext Recipe", "\u00a77Click to view the next available upgrade.", "\u00a77(" + (this.currentRecipeIndex + 1) + "/" + this.matchingRecipes.size() + ")"));
        } else {
            this.inventory.setItem(14, this.makeItem(Material.GRAY_STAINED_GLASS_PANE, " ", new String[0]));
        }
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add("\u00a77Recipe: \u00a7r" + ConfigManager.toSection(ConfigManager.fromLegacy(recipe.getDisplayName())));
        lore.add("");
        lore.add("\u00a77Requirements:");
        Player p = this.playerMenuUtility.getOwner();
        boolean canAfford = true;
        ICost baseCost = recipe.getBaseCost();
        lore.add("\u00a7a\u2714 " + baseCost.getDisplayString() + " \u00a78(Input Item)");
        for (ICost cost : recipe.getIngredients()) {
            boolean has = cost.hasEnough(p);
            if (!has) {
                canAfford = false;
            }
            lore.add((has ? "\u00a7a\u2714 " : "\u00a7c\u2716 ") + cost.getDisplayString());
        }
        lore.add("");
        lore.add("\u00a77Success Rate: \u00a7b" + recipe.getSuccessRate() + "%");
        lore.add("");
        if (canAfford) {
            lore.add("\u00a7aClick the Output Item to Upgrade!");
        } else {
            lore.add("\u00a7cYou do not meet the requirements.");
        }
        this.inventory.setItem(13, this.makeItem(Material.BOOK, "\u00a7aRecipe Found!", lore.toArray(new String[0])));
    }

    private void handleUpgrade(Player p) {
        boolean success;
        ItemStack inputItem = this.inventory.getItem(10);
        if (inputItem == null || this.matchingRecipes.isEmpty()) {
            return;
        }
        if (this.currentRecipeIndex >= this.matchingRecipes.size()) {
            this.currentRecipeIndex = 0;
        }
        UpgradeRecipe recipe = this.matchingRecipes.get(this.currentRecipeIndex);
        int requiredBase = 1;
        if (inputItem.getAmount() < requiredBase) {
            p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cInput item amount error!"));
            return;
        }
        ArrayList<String> missingRequirements = new ArrayList<String>();
        for (ICost iCost : recipe.getIngredients()) {
            if (iCost.hasEnough(p)) continue;
            String failureMsg = iCost.getFailureMessage();
            missingRequirements.add(this.plugin.getHookManager().processPlaceholders((OfflinePlayer)p, failureMsg));
        }
        if (!missingRequirements.isEmpty()) {
            this.sendMessageWithPapi(p, "upgrade-requirements-not-met");
            for (String string : missingRequirements) {
                p.sendMessage(ConfigManager.fromLegacy(" &7- " + string));
            }
            p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.5f);
            return;
        }
        boolean bl = success = Math.random() * 100.0 <= recipe.getSuccessRate();
        if (success) {
            ItemStack resultStack;
            inputItem.setAmount(inputItem.getAmount() - requiredBase);
            this.inventory.setItem(10, inputItem);
            for (ICost cost : recipe.getIngredients()) {
                cost.deduct(p);
            }
            BuffedItem buffedItem = this.plugin.getItemManager().getBuffedItem(recipe.getResultItemId());
            if (buffedItem != null) {
                resultStack = new ItemBuilder(buffedItem, (Plugin)this.plugin).build();
                resultStack.setAmount(recipe.getResultAmount());
                ItemMeta meta = resultStack.getItemMeta();
                if (meta != null) {
                    List originalLore;
                    Component originalName;
                    if (meta.hasDisplayName() && (originalName = meta.displayName()) != null) {
                        String legacyName = ConfigManager.toSection(originalName);
                        String parsedName = this.plugin.getHookManager().processPlaceholders((OfflinePlayer)p, legacyName);
                        meta.displayName(ConfigManager.fromSection(parsedName));
                    }
                    if (meta.hasLore() && (originalLore = meta.lore()) != null) {
                        List parsedLore = originalLore.stream().map(ConfigManager::toSection).map(line -> this.plugin.getHookManager().processPlaceholders((OfflinePlayer)p, (String)line)).map(ConfigManager::fromSection).collect(Collectors.toList());
                        meta.lore(parsedLore);
                    }
                    resultStack.setItemMeta(meta);
                }
            } else {
                resultStack = new ItemStack(Material.BARRIER);
            }
            HashMap leftovers = p.getInventory().addItem(new ItemStack[]{resultStack});
            if (!leftovers.isEmpty()) {
                for (ItemStack item : leftovers.values()) {
                    p.getWorld().dropItemNaturally(p.getLocation(), item);
                }
                this.sendMessageWithPapi(p, "upgrade-inventory-full");
            }
            p.playSound(p.getLocation(), Sound.BLOCK_ANVIL_USE, 1.0f, 1.0f);
            this.sendMessageWithPapi(p, "upgrade-success");
            this.plugin.getEffectApplicatorTask().markPlayerForUpdate(p.getUniqueId());
        } else {
            FailureAction failureAction = recipe.getFailureAction();
            if (failureAction == FailureAction.LOSE_EVERYTHING) {
                inputItem.setAmount(inputItem.getAmount() - requiredBase);
                this.inventory.setItem(10, inputItem);
                for (ICost cost : recipe.getIngredients()) {
                    cost.deduct(p);
                }
                this.sendMessageWithPapi(p, "upgrade-failure-lose-everything");
            } else if (failureAction == FailureAction.KEEP_BASE_ONLY) {
                for (ICost cost : recipe.getIngredients()) {
                    cost.deduct(p);
                }
                this.sendMessageWithPapi(p, "upgrade-failure-keep-base");
            } else if (failureAction == FailureAction.KEEP_EVERYTHING) {
                this.sendMessageWithPapi(p, "upgrade-failure-keep-everything");
            }
            p.playSound(p.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
        }
        this.updateMenuState();
    }

    private List<UpgradeRecipe> findAllRecipes(ItemStack item) {
        ArrayList<UpgradeRecipe> found = new ArrayList<UpgradeRecipe>();
        if (item == null || this.plugin.getUpgradeManager() == null) {
            return found;
        }
        for (UpgradeRecipe recipe : this.plugin.getUpgradeManager().getRecipes().values()) {
            if (!recipe.isValid() || !this.isCostSatisfiedByInput(recipe.getBaseCost(), item)) continue;
            found.add(recipe);
        }
        return found;
    }

    private boolean isCostSatisfiedByInput(ICost cost, ItemStack input) {
        if (input == null) {
            return false;
        }
        if (cost instanceof BuffedItemCost) {
            String reqId = ((BuffedItemCost)cost).getRequiredItemId();
            if (reqId == null) {
                return false;
            }
            if (!input.hasItemMeta()) {
                return false;
            }
            String inputId = (String)input.getItemMeta().getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "buffeditem_id"), PersistentDataType.STRING);
            return reqId.equals(inputId);
        }
        if (cost instanceof ItemCost) {
            Material reqMat = ((ItemCost)cost).getMaterial();
            return input.getType() == reqMat;
        }
        return false;
    }

    private void sendMessageWithPapi(Player p, String configKey) {
        String rawMsg = this.plugin.getConfig().getString("messages." + configKey);
        if (rawMsg == null) {
            return;
        }
        String parsedMsg = this.plugin.getHookManager().processPlaceholders((OfflinePlayer)p, rawMsg);
        p.sendMessage(ConfigManager.fromLegacyWithPrefix(parsedMsg));
    }

    @Override
    public boolean allowBottomInventoryClick() {
        return true;
    }
}

