/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.upgrade;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.config.UpgradesConfig;
import io.github.altkat.BuffedItems.menu.base.Menu;
import io.github.altkat.BuffedItems.menu.selector.TypeSelectorMenu;
import io.github.altkat.BuffedItems.menu.upgrade.UpgradeRecipeEditorMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import io.github.altkat.BuffedItems.utility.item.ItemBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import su.nightexpress.coinsengine.api.CoinsEngineAPI;
import su.nightexpress.coinsengine.api.currency.Currency;

public class IngredientListMenu
extends Menu {
    private final BuffedItems plugin;
    private final String recipeId;

    public IngredientListMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.recipeId = playerMenuUtility.getItemToEditId();
    }

    @Override
    public String getMenuName() {
        return "Ingredients: " + this.recipeId;
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        if (e.getCurrentItem() == null) {
            return;
        }
        if (e.getSlot() == 53) {
            new UpgradeRecipeEditorMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
        if (e.getSlot() == 49) {
            new TypeSelectorMenu(this.playerMenuUtility, this.plugin, PlayerMenuUtility.MaterialSelectionContext.INGREDIENT).open();
            return;
        }
        if (e.getSlot() < 45 && e.getCurrentItem().getType() != Material.BLACK_STAINED_GLASS_PANE) {
            List list = UpgradesConfig.get().getMapList("upgrades." + this.recipeId + ".ingredients");
            if (e.getSlot() >= list.size()) {
                return;
            }
            if (e.getClick() == ClickType.RIGHT) {
                list.remove(e.getSlot());
                ConfigManager.setUpgradeValue(this.recipeId, "ingredients", list);
                this.open();
            } else if (e.getClick() == ClickType.LEFT) {
                this.playerMenuUtility.setWaitingForChatInput(true);
                this.playerMenuUtility.setEditIndex(e.getSlot());
                this.playerMenuUtility.setChatInputPath("upgrade.ingredients.edit.amount");
                e.getWhoClicked().closeInventory();
                e.getWhoClicked().sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aEnter new amount in chat."));
                e.getWhoClicked().sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
            }
        }
    }

    @Override
    public void setMenuItems() {
        this.setFillerGlass();
        this.inventory.setItem(53, this.makeItem(Material.BARRIER, "\u00a7cBack", new String[0]));
        this.inventory.setItem(49, this.makeItem(Material.ANVIL, "\u00a7aAdd Ingredient", "\u00a77Add a cost requirement."));
        List list = UpgradesConfig.get().getMapList("upgrades." + this.recipeId + ".ingredients");
        int index = 0;
        for (Map map : list) {
            if (index >= 45) break;
            this.inventory.setItem(index, this.createVisualItem(map, index));
            ++index;
        }
    }

    private ItemStack createVisualItem(Map<?, ?> map, int index) {
        Component title;
        ItemStack displayItem;
        String type = (String)map.get("type");
        Object amountObj = map.get("amount");
        String amountStr = String.valueOf(amountObj);
        ArrayList<Object> lore = new ArrayList<Object>();
        if ("ITEM".equals(type)) {
            Object matObj = map.get("material");
            String matName = matObj != null ? matObj.toString() : "STONE";
            Material mat = Material.matchMaterial((String)matName);
            if (mat == null) {
                mat = Material.STONE;
            }
            displayItem = new ItemStack(mat);
            title = ConfigManager.fromSection("\u00a7f" + amountStr + "x " + this.formatMaterialName(mat));
            lore.add(ConfigManager.fromSection("\u00a78Type: \u00a77Vanilla Item"));
            lore.add(ConfigManager.fromSection("\u00a78Material: \u00a7b" + mat.name()));
        } else if ("BUFFED_ITEM".equals(type)) {
            String itemId = (String)map.get("item_id");
            BuffedItem bItem = this.plugin.getItemManager().getBuffedItem(itemId);
            if (bItem != null) {
                displayItem = new ItemBuilder(bItem, (Plugin)this.plugin).build();
                title = ConfigManager.fromSection("\u00a7f" + amountStr + "x ").append(ConfigManager.fromLegacy(bItem.getDisplayName()));
            } else {
                displayItem = new ItemStack(Material.BEDROCK);
                title = ConfigManager.fromSection("\u00a7cUnknown Buffed Item: " + itemId);
            }
            lore.add(ConfigManager.fromSection("\u00a78Type: \u00a7#FF6347Buffed Item\u00a7#FFD700"));
            lore.add(ConfigManager.fromSection("\u00a78ID: \u00a77" + itemId));
        } else if ("COINSENGINE".equals(type)) {
            String currencyId;
            Object currObj = map.get("currency_id");
            String string = currencyId = currObj != null ? currObj.toString() : "coins";
            if (this.plugin.getServer().getPluginManager().getPlugin("CoinsEngine") == null) {
                displayItem = new ItemStack(Material.BEDROCK);
                title = ConfigManager.fromSection("\u00a7cCoinsEngine Not Found");
                lore.add(ConfigManager.fromSection("\u00a7cPlugin is missing!"));
            } else {
                Currency currency = CoinsEngineAPI.getCurrency((String)currencyId);
                if (currency == null) {
                    displayItem = new ItemStack(Material.BEDROCK);
                    title = ConfigManager.fromSection("\u00a7cUnknown Currency: " + currencyId);
                } else {
                    displayItem = new ItemStack(Material.SUNFLOWER);
                    title = ConfigManager.fromSection("\u00a7a" + currency.getName());
                }
            }
            lore.add(ConfigManager.fromSection("\u00a78Type: \u00a77CoinsEngine"));
            lore.add(ConfigManager.fromSection("\u00a78Currency ID: \u00a7e" + currencyId));
            lore.add(ConfigManager.fromSection("\u00a78Amount: \u00a7e" + amountStr));
        } else if ("MONEY".equals(type)) {
            if (this.plugin.getHookManager().getVaultHook() == null) {
                displayItem = new ItemStack(Material.BEDROCK);
                title = ConfigManager.fromSection("\u00a7cVault/Economy Not Found");
                lore.add(ConfigManager.fromSection("\u00a7cVault is missing or not hooked!"));
            } else {
                displayItem = new ItemStack(Material.GOLD_INGOT);
                title = ConfigManager.fromSection("\u00a7aVault Currency");
            }
            lore.add(ConfigManager.fromSection("\u00a78Type: \u00a77MONEY"));
            lore.add(ConfigManager.fromSection("\u00a78Amount: \u00a7e" + amountStr));
        } else {
            Material iconMat;
            String name = switch (type) {
                case "EXPERIENCE" -> {
                    iconMat = Material.EXPERIENCE_BOTTLE;
                    yield "XP Points";
                }
                case "LEVEL" -> {
                    iconMat = Material.ENCHANTING_TABLE;
                    yield "XP Levels";
                }
                case "HUNGER" -> {
                    iconMat = Material.COOKED_BEEF;
                    yield "Food Level";
                }
                case "HEALTH" -> {
                    iconMat = Material.RED_DYE;
                    yield "Health (Hearts)";
                }
                default -> {
                    iconMat = Material.PAPER;
                    yield type;
                }
            };
            displayItem = new ItemStack(iconMat);
            title = ConfigManager.fromSection("\u00a7a" + name);
            lore.add(ConfigManager.fromSection("\u00a78Type: \u00a77" + type));
            lore.add(ConfigManager.fromSection("\u00a78Amount: \u00a7e" + amountStr));
        }
        lore.add(Component.empty());
        lore.add(ConfigManager.fromSection("\u00a7eLeft-Click to Edit Amount"));
        lore.add(ConfigManager.fromSection("\u00a7cRight-Click to Remove"));
        lore.add(ConfigManager.fromSection("\u00a78(#" + (index + 1) + ")"));
        ItemMeta meta = displayItem.getItemMeta();
        if (meta != null) {
            meta.displayName(title);
            meta.lore(lore);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
            displayItem.setItemMeta(meta);
        }
        return displayItem;
    }

    private String formatMaterialName(Material material) {
        String name = material.name().toLowerCase().replace("_", " ");
        StringBuilder sb = new StringBuilder();
        for (String word : name.split(" ")) {
            sb.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return sb.toString().trim();
    }
}

