/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.set;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.config.SetsConfig;
import io.github.altkat.BuffedItems.menu.base.PaginatedMenu;
import io.github.altkat.BuffedItems.menu.set.SetBonusEffectSelectorMenu;
import io.github.altkat.BuffedItems.menu.set.SetEditorMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class SetBonusesMenu
extends PaginatedMenu {
    private final BuffedItems plugin;
    private final String setId;

    public SetBonusesMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.setId = playerMenuUtility.getItemToEditId();
        this.maxItemsPerPage = 36;
    }

    @Override
    public String getMenuName() {
        return "Set Bonuses: " + this.setId;
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        if (e.getCurrentItem() == null) {
            return;
        }
        List<String> bonusKeys = this.getBonusKeys();
        if (this.handlePageChange(e, bonusKeys.size())) {
            return;
        }
        if (e.getSlot() == 53) {
            new SetEditorMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
        if (e.getSlot() == 49) {
            this.playerMenuUtility.setWaitingForChatInput(true);
            this.playerMenuUtility.setChatInputPath("create_bonus_tier");
            p.closeInventory();
            p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aEnter piece count for new bonus (e.g. 3)."));
            p.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
            return;
        }
        if (e.getSlot() >= 9 && e.getSlot() < 45) {
            int index = this.maxItemsPerPage * this.page + (e.getSlot() - 9);
            if (index >= bonusKeys.size()) {
                return;
            }
            String countKey = bonusKeys.get(index);
            if (e.getClick() == ClickType.RIGHT) {
                SetsConfig.get().set("sets." + this.setId + ".bonuses." + countKey, null);
                SetsConfig.save();
                this.plugin.getSetManager().loadSets(true);
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cBonus tier " + countKey + " removed."));
                this.open();
            } else if (e.getClick() == ClickType.LEFT) {
                this.playerMenuUtility.setTempSetId(this.setId);
                this.playerMenuUtility.setTempBonusCount(Integer.parseInt(countKey));
                new SetBonusEffectSelectorMenu(this.playerMenuUtility, this.plugin).open();
            }
        }
    }

    @Override
    public void setMenuItems() {
        int index;
        int i;
        ItemStack filler = this.makeItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        for (i = 0; i < 9; ++i) {
            this.inventory.setItem(i, filler);
        }
        for (i = 45; i < 54; ++i) {
            this.inventory.setItem(i, filler);
        }
        this.addMenuControls();
        this.inventory.setItem(53, this.makeItem(Material.BARRIER, "\u00a7cBack", new String[0]));
        this.inventory.setItem(49, this.makeItem(Material.ANVIL, "\u00a7aAdd Bonus Tier", "\u00a77Create a new bonus level (e.g. 3 pieces)."));
        List<String> bonusKeys = this.getBonusKeys();
        for (int i2 = 0; i2 < this.maxItemsPerPage && (index = this.maxItemsPerPage * this.page + i2) < bonusKeys.size(); ++i2) {
            String count = bonusKeys.get(index);
            this.inventory.setItem(9 + i2, this.makeItem(Material.EXPERIENCE_BOTTLE, "\u00a7b" + count + " Pieces Bonus", "", "\u00a77Click to Edit Effects", "\u00a7cRight-Click to Remove"));
        }
    }

    private List<String> getBonusKeys() {
        ConfigurationSection sec = SetsConfig.get().getConfigurationSection("sets." + this.setId + ".bonuses");
        if (sec == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> keys = new ArrayList<String>(sec.getKeys(false));
        keys.sort((a, b) -> {
            try {
                return Integer.compare(Integer.parseInt(a), Integer.parseInt(b));
            }
            catch (Exception e) {
                return a.compareTo((String)b);
            }
        });
        return keys;
    }
}

