/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.selector;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.menu.active.CostListMenu;
import io.github.altkat.BuffedItems.menu.base.Menu;
import io.github.altkat.BuffedItems.menu.selector.BuffedItemSelectorMenu;
import io.github.altkat.BuffedItems.menu.selector.MaterialSelectorMenu;
import io.github.altkat.BuffedItems.menu.upgrade.IngredientListMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class TypeSelectorMenu
extends Menu {
    private final BuffedItems plugin;
    private final PlayerMenuUtility.MaterialSelectionContext context;

    public TypeSelectorMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin, PlayerMenuUtility.MaterialSelectionContext context) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.context = context;
    }

    @Override
    public String getMenuName() {
        return "Select " + (this.context == PlayerMenuUtility.MaterialSelectionContext.COST ? "Cost" : "Ingredient") + " Type";
    }

    @Override
    public int getSlots() {
        return 36;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        if (e.getCurrentItem() == null) {
            return;
        }
        if (e.getCurrentItem().getType() == Material.BLACK_STAINED_GLASS_PANE) {
            return;
        }
        if (e.getCurrentItem().getType() == Material.BARRIER) {
            if (this.context == PlayerMenuUtility.MaterialSelectionContext.COST) {
                new CostListMenu(this.playerMenuUtility, this.plugin).open();
            } else {
                new IngredientListMenu(this.playerMenuUtility, this.plugin).open();
            }
            return;
        }
        String type = e.getCurrentItem().getItemMeta().getDisplayName().substring(2);
        Player p = (Player)e.getWhoClicked();
        if (type.equals("BUFFED_ITEM")) {
            BuffedItemSelectorMenu.SelectionContext buffedContext = this.context == PlayerMenuUtility.MaterialSelectionContext.COST ? BuffedItemSelectorMenu.SelectionContext.COST : BuffedItemSelectorMenu.SelectionContext.INGREDIENT;
            new BuffedItemSelectorMenu(this.playerMenuUtility, this.plugin, buffedContext).open();
            return;
        }
        if (type.equals("ITEM")) {
            this.playerMenuUtility.setMaterialContext(this.context);
            new MaterialSelectorMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
        String prefix = this.context == PlayerMenuUtility.MaterialSelectionContext.COST ? "active.costs.add." : "upgrade.ingredients.add.";
        this.playerMenuUtility.setWaitingForChatInput(true);
        this.playerMenuUtility.setChatInputPath(prefix + type);
        p.closeInventory();
        p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aSelected Type: " + type));
        if (type.equals("COINSENGINE")) {
            p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7eFormat: AMOUNT;CURRENCY_ID"));
            p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a77Example: 100;coins"));
            p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a77(If you use default currency 'coins', you can just type the amount)"));
        } else {
            p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aPlease enter the Amount in chat."));
        }
        p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a77(Type 'cancel' to exit)"));
    }

    @Override
    public void setMenuItems() {
        this.setFillerGlass();
        this.inventory.setItem(10, this.makeItem(Material.GOLD_INGOT, "\u00a7aMONEY", "\u00a77Vault Currency"));
        this.inventory.setItem(11, this.makeItem(Material.EXPERIENCE_BOTTLE, "\u00a7aEXPERIENCE", "\u00a77XP Points"));
        this.inventory.setItem(12, this.makeItem(Material.ENCHANTING_TABLE, "\u00a7aLEVEL", "\u00a77XP Levels"));
        this.inventory.setItem(13, this.makeItem(Material.COOKED_BEEF, "\u00a7aHUNGER", "\u00a77Food Level"));
        this.inventory.setItem(14, this.makeItem(Material.RED_DYE, "\u00a7aHEALTH", "\u00a77Health Points (Hearts)"));
        this.inventory.setItem(15, this.makeItem(Material.CHEST, "\u00a7aITEM", "\u00a77Physical Items"));
        this.inventory.setItem(16, this.makeItem(Material.NETHER_STAR, "\u00a7aBUFFED_ITEM", "\u00a77Custom Buffed Items"));
        if (this.plugin.getServer().getPluginManager().getPlugin("CoinsEngine") != null) {
            this.inventory.setItem(19, this.makeItem(Material.SUNFLOWER, "\u00a7aCOINSENGINE", "\u00a77CoinsEngine Currency"));
        }
        this.inventory.setItem(31, this.makeItem(Material.BARRIER, "\u00a7cCancel", new String[0]));
    }
}

