/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.selector;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.menu.active.ActiveItemVisualsMenu;
import io.github.altkat.BuffedItems.menu.base.Menu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import org.bukkit.Material;
import org.bukkit.boss.BarColor;
import org.bukkit.event.inventory.InventoryClickEvent;

public class BossBarColorMenu
extends Menu {
    private final BuffedItems plugin;
    private final String itemId;

    public BossBarColorMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.itemId = playerMenuUtility.getItemToEditId();
    }

    @Override
    public String getMenuName() {
        return "Select BossBar Color";
    }

    @Override
    public int getSlots() {
        return 27;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        if (e.getCurrentItem() == null) {
            return;
        }
        if (e.getCurrentItem().getType() == Material.BLACK_STAINED_GLASS_PANE) {
            return;
        }
        if (e.getCurrentItem().getType() == Material.BARRIER) {
            new ActiveItemVisualsMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
        if (e.getSlot() < 9) {
            String colorName = e.getCurrentItem().getItemMeta().getDisplayName().substring(2);
            try {
                BarColor color = BarColor.valueOf((String)colorName);
                ConfigManager.setItemValue(this.itemId, "visuals.boss-bar-color", color.name());
                new ActiveItemVisualsMenu(this.playerMenuUtility, this.plugin).open();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setMenuItems() {
        this.setFillerGlass();
        this.inventory.setItem(0, this.makeItem(Material.PINK_DYE, "\u00a7dPINK", new String[0]));
        this.inventory.setItem(1, this.makeItem(Material.BLUE_DYE, "\u00a79BLUE", new String[0]));
        this.inventory.setItem(2, this.makeItem(Material.RED_DYE, "\u00a7cRED", new String[0]));
        this.inventory.setItem(3, this.makeItem(Material.GREEN_DYE, "\u00a7aGREEN", new String[0]));
        this.inventory.setItem(4, this.makeItem(Material.YELLOW_DYE, "\u00a7eYELLOW", new String[0]));
        this.inventory.setItem(5, this.makeItem(Material.PURPLE_DYE, "\u00a75PURPLE", new String[0]));
        this.inventory.setItem(6, this.makeItem(Material.WHITE_DYE, "\u00a7fWHITE", new String[0]));
        this.inventory.setItem(22, this.makeItem(Material.BARRIER, "\u00a7cCancel", new String[0]));
    }
}

