/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.passive;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.menu.base.Menu;
import io.github.altkat.BuffedItems.menu.passive.EffectListMenu;
import io.github.altkat.BuffedItems.menu.passive.PassiveItemSettingsMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class SlotSelectionMenu
extends Menu {
    private final BuffedItems plugin;
    private final MenuType menuType;

    public SlotSelectionMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin, MenuType menuType) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.menuType = menuType;
    }

    @Override
    public String getMenuName() {
        return "Select a Slot";
    }

    @Override
    public int getSlots() {
        return 27;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        if (e.getCurrentItem() == null || e.getCurrentItem().getType() == Material.BLACK_STAINED_GLASS_PANE) {
            return;
        }
        if (e.getCurrentItem().getType() == Material.BARRIER) {
            new PassiveItemSettingsMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
        String slotName = e.getCurrentItem().getItemMeta().getDisplayName().substring(2).replace(" ", "_").toUpperCase();
        this.playerMenuUtility.setTargetSlot(slotName);
        if (this.menuType == MenuType.POTION_EFFECT) {
            new EffectListMenu(this.playerMenuUtility, this.plugin, EffectListMenu.EffectType.POTION_EFFECT, slotName).open();
        } else if (this.menuType == MenuType.ATTRIBUTE) {
            new EffectListMenu(this.playerMenuUtility, this.plugin, EffectListMenu.EffectType.ATTRIBUTE, slotName).open();
        }
    }

    @Override
    public void setMenuItems() {
        this.inventory.setItem(10, this.makeItem(Material.DIAMOND_SWORD, "\u00a7aMain Hand", "\u00a77Effects active when held in the main hand."));
        this.inventory.setItem(11, this.makeItem(Material.SHIELD, "\u00a7aOff Hand", "\u00a77Effects active when held in the off hand."));
        this.inventory.setItem(12, this.makeItem(Material.DIAMOND_HELMET, "\u00a7aHelmet", "\u00a77Effects active when worn as a helmet."));
        this.inventory.setItem(13, this.makeItem(Material.DIAMOND_CHESTPLATE, "\u00a7aChestplate", "\u00a77Effects active when worn as a chestplate."));
        this.inventory.setItem(14, this.makeItem(Material.DIAMOND_LEGGINGS, "\u00a7aLeggings", "\u00a77Effects active when worn as leggings."));
        this.inventory.setItem(15, this.makeItem(Material.DIAMOND_BOOTS, "\u00a7aBoots", "\u00a77Effects active when worn as boots."));
        this.inventory.setItem(16, this.makeItem(Material.CHEST, "\u00a7aInventory", "\u00a77Effects active anywhere in the inventory."));
        this.addBackButton(new PassiveItemSettingsMenu(this.playerMenuUtility, this.plugin));
        this.setFillerGlass();
    }

    public static enum MenuType {
        POTION_EFFECT,
        ATTRIBUTE;

    }
}

