/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.passive;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.config.ItemsConfig;
import io.github.altkat.BuffedItems.manager.config.SetsConfig;
import io.github.altkat.BuffedItems.menu.active.ActiveItemSettingsMenu;
import io.github.altkat.BuffedItems.menu.base.Menu;
import io.github.altkat.BuffedItems.menu.passive.SlotSelectionMenu;
import io.github.altkat.BuffedItems.menu.selector.AttributeSelectorMenu;
import io.github.altkat.BuffedItems.menu.selector.PotionEffectSelectorMenu;
import io.github.altkat.BuffedItems.menu.set.SetBonusEffectSelectorMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.potion.PotionEffectType;

public class EffectListMenu
extends Menu {
    private final BuffedItems plugin;
    private final EffectType effectType;
    private final String context;
    private final boolean isActive;
    private final boolean isSetBonus;

    public EffectListMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin, EffectType effectType, String context) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.effectType = effectType;
        this.context = context;
        this.isActive = "ACTIVE".equals(context);
        this.isSetBonus = "SET_BONUS".equals(context);
        playerMenuUtility.setTargetSlot(context);
    }

    @Override
    public String getMenuName() {
        if (this.isSetBonus) {
            String setName = this.playerMenuUtility.getTempSetId();
            int count = this.playerMenuUtility.getTempBonusCount();
            return (this.effectType == EffectType.POTION_EFFECT ? "Potions: " : "Attrs: ") + setName + " (" + count + ")";
        }
        if (this.isActive) {
            return this.effectType == EffectType.POTION_EFFECT ? "Active Potion Effects" : "Active Attributes";
        }
        return "Effects for Slot: " + this.context;
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        String itemId = this.playerMenuUtility.getItemToEditId();
        if (e.getCurrentItem() == null) {
            return;
        }
        Material clickedType = e.getCurrentItem().getType();
        int clickedSlot = e.getSlot();
        if (clickedType == Material.BARRIER && clickedSlot == 53) {
            this.openBackMenu();
            return;
        }
        if (clickedType == Material.ANVIL && clickedSlot == 49) {
            this.openSelectorMenu();
            return;
        }
        if (clickedSlot < 45) {
            String configPath = this.buildConfigPath(itemId);
            List effects = this.isSetBonus ? SetsConfig.get().getStringList(configPath) : ItemsConfig.get().getStringList(configPath);
            if (clickedSlot >= effects.size()) {
                return;
            }
            if (e.isRightClick()) {
                String removedInfo = (String)effects.get(clickedSlot);
                effects.remove(clickedSlot);
                if (this.isSetBonus) {
                    SetsConfig.get().set(configPath, (Object)effects);
                    SetsConfig.save();
                    this.plugin.getSetManager().loadSets(true);
                } else {
                    ConfigManager.setItemValue(itemId, this.extractConfigKey(configPath), effects);
                }
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aRemoved: \u00a7e" + removedInfo));
                this.open();
            } else if (e.isLeftClick()) {
                String effectName = ((String)effects.get(clickedSlot)).split(";")[0];
                this.playerMenuUtility.setWaitingForChatInput(true);
                this.playerMenuUtility.setEditIndex(clickedSlot);
                this.playerMenuUtility.setChatInputPath(this.buildChatPath("edit"));
                p.closeInventory();
                if (this.effectType == EffectType.POTION_EFFECT) {
                    p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aType new level for '" + effectName + "' in chat."));
                } else {
                    p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aType new amount for the attribute in chat."));
                }
                p.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
            }
        }
    }

    @Override
    public void setMenuItems() {
        String desc = this.isSetBonus ? "to the " + this.playerMenuUtility.getTempBonusCount() + "-piece bonus of " + this.playerMenuUtility.getTempSetId() : "to the " + (this.isActive ? "active" : this.context.toLowerCase()) + " slot.";
        this.inventory.setItem(49, this.makeItem(Material.ANVIL, "\u00a7aAdd New " + this.capitalizeEffectType(), "\u00a77Adds a " + this.effectType.name().toLowerCase().replace("_", " ") + " " + desc));
        this.addBackButton(this);
        String itemId = this.playerMenuUtility.getItemToEditId();
        String configPath = this.buildConfigPath(itemId);
        List effectsConfig = this.isSetBonus ? SetsConfig.get().getStringList(configPath) : ItemsConfig.get().getStringList(configPath);
        if (!effectsConfig.isEmpty()) {
            for (int i = 0; i < effectsConfig.size() && i < this.getSlots() - 9; ++i) {
                String effectString = (String)effectsConfig.get(i);
                String[] parts = effectString.split(";");
                boolean isValid = this.validateEffect(this.effectType, parts);
                if (isValid) {
                    String displayName = parts[0];
                    String level = parts.length > 1 ? parts[1] : "?";
                    String amount = parts.length > 2 ? parts[2] : "?";
                    String displayValue = this.effectType == EffectType.POTION_EFFECT ? "\u00a77Level: \u00a7e" + level : "\u00a77Amount: \u00a7e" + amount;
                    this.inventory.setItem(i, this.makeItem(this.effectType.getIcon(), "\u00a7b" + displayName, displayValue, "", "\u00a7aLeft-Click to Edit", "\u00a7cRight-Click to Delete"));
                    continue;
                }
                this.inventory.setItem(i, this.makeItem(Material.BARRIER, "\u00a7c\u00a7lCORRUPT ENTRY", "\u00a77Malformed: " + effectString, "\u00a7cRight-Click to Delete"));
            }
        }
        this.setFillerGlass();
    }

    private void openBackMenu() {
        if (this.isSetBonus) {
            new SetBonusEffectSelectorMenu(this.playerMenuUtility, this.plugin).open();
        } else if (this.isActive) {
            new ActiveItemSettingsMenu(this.playerMenuUtility, this.plugin).open();
        } else {
            SlotSelectionMenu.MenuType menuType = this.effectType == EffectType.POTION_EFFECT ? SlotSelectionMenu.MenuType.POTION_EFFECT : SlotSelectionMenu.MenuType.ATTRIBUTE;
            new SlotSelectionMenu(this.playerMenuUtility, this.plugin, menuType).open();
        }
    }

    private void openSelectorMenu() {
        this.playerMenuUtility.setTargetSlot(this.context);
        if (this.effectType == EffectType.POTION_EFFECT) {
            new PotionEffectSelectorMenu(this.playerMenuUtility, this.plugin).open();
        } else {
            new AttributeSelectorMenu(this.playerMenuUtility, this.plugin).open();
        }
    }

    private String buildConfigPath(String itemId) {
        if (this.isSetBonus) {
            String setId = this.playerMenuUtility.getTempSetId();
            int count = this.playerMenuUtility.getTempBonusCount();
            if (this.effectType == EffectType.POTION_EFFECT) {
                return "sets." + setId + ".bonuses." + count + ".potion_effects";
            }
            return "sets." + setId + ".bonuses." + count + ".attributes";
        }
        if (this.isActive) {
            if (this.effectType == EffectType.POTION_EFFECT) {
                return "items." + itemId + ".active-mode.effects.potion_effects";
            }
            return "items." + itemId + ".active-mode.effects.attributes";
        }
        if (this.effectType == EffectType.POTION_EFFECT) {
            return "items." + itemId + ".effects." + this.context + ".potion_effects";
        }
        return "items." + itemId + ".effects." + this.context + ".attributes";
    }

    private String extractConfigKey(String fullPath) {
        if (this.isSetBonus) {
            return fullPath;
        }
        String itemId = this.playerMenuUtility.getItemToEditId();
        String prefix = "items." + itemId + ".";
        if (fullPath.startsWith(prefix)) {
            return fullPath.substring(prefix.length());
        }
        return fullPath;
    }

    private String buildChatPath(String operation) {
        if (this.isSetBonus) {
            if (this.effectType == EffectType.POTION_EFFECT) {
                return "set.potion." + operation;
            }
            return "set.attribute." + operation;
        }
        if (this.isActive) {
            if (this.effectType == EffectType.POTION_EFFECT) {
                return "active.potion_effects." + operation;
            }
            return "active.attributes." + operation;
        }
        if (this.effectType == EffectType.POTION_EFFECT) {
            return "potion_effects." + operation;
        }
        return "attributes." + operation;
    }

    private boolean validateEffect(EffectType type, String[] parts) {
        if (parts.length < 2) {
            return false;
        }
        try {
            if (type == EffectType.POTION_EFFECT) {
                PotionEffectType.getByName((String)parts[0].toUpperCase());
                Integer.parseInt(parts[1]);
                return true;
            }
            Attribute.valueOf((String)parts[0].toUpperCase());
            if (parts.length < 3) {
                return false;
            }
            AttributeModifier.Operation.valueOf((String)parts[1].toUpperCase());
            Double.parseDouble(parts[2]);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private String capitalizeEffectType() {
        return this.effectType == EffectType.POTION_EFFECT ? "Potion Effect" : "Attribute";
    }

    public static enum EffectType {
        POTION_EFFECT(Material.POTION),
        ATTRIBUTE(Material.IRON_SWORD);

        private final Material icon;

        private EffectType(Material icon) {
            this.icon = icon;
        }

        public Material getIcon() {
            return this.icon;
        }
    }
}

