/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.editor;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.config.ItemsConfig;
import io.github.altkat.BuffedItems.menu.base.Menu;
import io.github.altkat.BuffedItems.menu.editor.ItemEditorMenu;
import io.github.altkat.BuffedItems.menu.selector.EnchantmentFinder;
import io.github.altkat.BuffedItems.menu.selector.EnchantmentSelectorMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class EnchantmentListMenu
extends Menu {
    private final BuffedItems plugin;
    private final String itemId;

    public EnchantmentListMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.itemId = playerMenuUtility.getItemToEditId();
    }

    @Override
    public String getMenuName() {
        return "Enchantments for: " + this.itemId;
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        if (e.getCurrentItem() == null) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        Material clickedType = e.getCurrentItem().getType();
        int clickedSlot = e.getSlot();
        if (clickedType == Material.BARRIER && clickedSlot == this.getSlots() - 1) {
            new ItemEditorMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
        if (clickedType == Material.ANVIL && clickedSlot == 49) {
            new EnchantmentSelectorMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
        if (clickedSlot < 45 && clickedType == Material.ENCHANTED_BOOK || clickedType == Material.BARRIER) {
            String configPath = "items." + this.itemId + ".enchantments";
            List enchantmentsConfig = ItemsConfig.get().getStringList(configPath);
            if (clickedSlot >= enchantmentsConfig.size()) {
                return;
            }
            String clickedEnchantString = (String)enchantmentsConfig.get(clickedSlot);
            if (e.isRightClick()) {
                ArrayList updatedList = new ArrayList(enchantmentsConfig);
                updatedList.remove(clickedSlot);
                ConfigManager.setItemValue(this.itemId, "enchantments", updatedList);
                String enchantName = clickedEnchantString.contains(";") ? clickedEnchantString.split(";")[0] : clickedEnchantString;
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aEnchantment entry '" + enchantName + "' removed."));
                ConfigManager.sendDebugMessage(1, () -> "[EnchantmentList] Removed enchantment entry: " + clickedEnchantString + " for item: " + this.itemId);
                this.open();
            } else if (e.isLeftClick() && clickedType == Material.ENCHANTED_BOOK) {
                this.playerMenuUtility.setWaitingForChatInput(true);
                this.playerMenuUtility.setEditIndex(clickedSlot);
                this.playerMenuUtility.setChatInputPath("enchantments.edit");
                String enchantName = clickedEnchantString.split(";")[0];
                p.closeInventory();
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aPlease type the new Level for '" + enchantName + "' in chat (e.g., 1, 5, 10)."));
            }
        }
    }

    @Override
    public void setMenuItems() {
        this.inventory.setItem(49, this.makeItem(Material.ANVIL, "\u00a7aAdd New Enchantment", "\u00a77Adds an enchantment to this item."));
        this.addBackButton(new ItemEditorMenu(this.playerMenuUtility, this.plugin));
        String configPath = "items." + this.playerMenuUtility.getItemToEditId() + ".enchantments";
        List enchantmentsConfig = ItemsConfig.get().getStringList(configPath);
        if (!enchantmentsConfig.isEmpty()) {
            for (int i = 0; i < enchantmentsConfig.size() && i < this.getSlots() - 9; ++i) {
                String enchString = (String)enchantmentsConfig.get(i);
                String[] parts = enchString.split(";");
                boolean isValid = false;
                Enchantment enchantment = null;
                int level = 0;
                if (parts.length == 2) {
                    try {
                        enchantment = EnchantmentFinder.findEnchantment(parts[0], this.plugin);
                        level = Integer.parseInt(parts[1]);
                        if (enchantment != null && level > 0) {
                            isValid = true;
                        }
                    }
                    catch (IllegalArgumentException | NullPointerException runtimeException) {
                        // empty catch block
                    }
                }
                if (isValid) {
                    ItemStack book = this.makeItem(Material.ENCHANTED_BOOK, "\u00a7b" + parts[0], "\u00a77Level: \u00a7e" + level, "", "\u00a7aLeft-Click to Edit Level", "\u00a7cRight-Click to Delete");
                    ItemMeta meta = book.getItemMeta();
                    meta.addEnchant(enchantment, level, true);
                    meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                    book.setItemMeta(meta);
                    this.inventory.setItem(i, book);
                    continue;
                }
                this.inventory.setItem(i, this.makeItem(Material.BARRIER, "\u00a7c\u00a7lCORRUPT ENTRY", "\u00a77This line is malformed in config.yml:", "\u00a7e" + enchString, "", "\u00a7cPossible Errors:", "\u00a77- Using ':' instead of the correct ';'.", "\u00a77- Missing the level (e.g., 'DAMAGE_ALL;').", "\u00a77- A typo in the Enchantment name (e.g., 'SHARPNES').", "\u00a77- Level is not a whole number or is zero/negative.", "\u00a77- Accidental spaces.", "", "\u00a7aCorrect Format: \u00a7eDAMAGE_ALL;5", "", "\u00a7cRight-Click to Delete this entry."));
            }
        }
        this.setFillerGlass();
    }
}

