/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.base;

import io.github.altkat.BuffedItems.menu.base.Menu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;

public abstract class PaginatedMenu
extends Menu {
    protected int page = 0;
    protected int maxItemsPerPage = 28;
    protected int index = 0;

    public PaginatedMenu(PlayerMenuUtility playerMenuUtility) {
        super(playerMenuUtility);
    }

    public void addMenuControls() {
        this.inventory.setItem(48, this.makeItem(Material.ARROW, "\u00a7aPrevious Page", new String[0]));
        this.inventory.setItem(50, this.makeItem(Material.ARROW, "\u00a7aNext Page", new String[0]));
    }

    public boolean handlePageChange(InventoryClickEvent e, int listSize) {
        if (e.getCurrentItem() == null) {
            return false;
        }
        if (e.getCurrentItem().getType() == Material.ARROW) {
            if (e.getSlot() < this.maxItemsPerPage) {
                return false;
            }
            if (e.getCurrentItem().getItemMeta().getDisplayName().contains("Next")) {
                if ((this.page + 1) * this.maxItemsPerPage < listSize) {
                    ++this.page;
                    this.open();
                }
            } else if (e.getCurrentItem().getItemMeta().getDisplayName().contains("Previous") && this.page > 0) {
                --this.page;
                this.open();
            }
            return true;
        }
        return false;
    }
}

