/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.active;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.config.ItemsConfig;
import io.github.altkat.BuffedItems.menu.active.ActiveItemSettingsMenu;
import io.github.altkat.BuffedItems.menu.base.Menu;
import io.github.altkat.BuffedItems.menu.selector.TypeSelectorMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import io.github.altkat.BuffedItems.utility.item.ItemBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import su.nightexpress.coinsengine.api.currency.Currency;

public class CostListMenu
extends Menu {
    private final BuffedItems plugin;
    private final String itemId;

    public CostListMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.itemId = playerMenuUtility.getItemToEditId();
    }

    @Override
    public String getMenuName() {
        return "Usage Costs: " + this.itemId;
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        if (e.getCurrentItem() == null) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        if (e.getCurrentItem().getType() == Material.BARRIER && e.getSlot() == 53) {
            new ActiveItemSettingsMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
        if (e.getCurrentItem().getType() == Material.ANVIL && e.getSlot() == 49) {
            new TypeSelectorMenu(this.playerMenuUtility, this.plugin, PlayerMenuUtility.MaterialSelectionContext.COST).open();
            return;
        }
        if (e.getSlot() < 45 && e.getCurrentItem().getType() != Material.BLACK_STAINED_GLASS_PANE) {
            List costList = ItemsConfig.get().getMapList("items." + this.itemId + ".active-mode.costs");
            if (e.getSlot() >= costList.size()) {
                return;
            }
            if (e.getClick() == ClickType.RIGHT) {
                costList.remove(e.getSlot());
                ConfigManager.setItemValue(this.itemId, "costs", costList);
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cCost removed."));
                this.open();
            } else if (e.getClick() == ClickType.LEFT) {
                this.playerMenuUtility.setWaitingForChatInput(true);
                this.playerMenuUtility.setEditIndex(e.getSlot());
                this.playerMenuUtility.setChatInputPath("active.costs.edit.amount");
                p.closeInventory();
                Map costData = (Map)costList.get(e.getSlot());
                String type = (String)costData.get("type");
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aEditing Amount for: \u00a7e" + type));
                p.sendMessage(ConfigManager.fromSection("\u00a7eCurrent: " + String.valueOf(costData.get("amount"))));
                p.sendMessage(ConfigManager.fromSection("\u00a7aEnter new amount in chat."));
                p.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
            } else if (e.getClick() == ClickType.SHIFT_LEFT) {
                this.playerMenuUtility.setWaitingForChatInput(true);
                this.playerMenuUtility.setEditIndex(e.getSlot());
                this.playerMenuUtility.setChatInputPath("active.costs.edit.message");
                p.closeInventory();
                Map costData = (Map)costList.get(e.getSlot());
                String type = (String)costData.get("type");
                String placeholders = "{amount}";
                if ("ITEM".equals(type)) {
                    placeholders = "{amount}, {material}";
                } else if ("BUFFED_ITEM".equals(type)) {
                    placeholders = "{amount}, {item_name}";
                } else if ("COINSENGINE".equals(type)) {
                    placeholders = "{amount}, {currency_name}";
                }
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aEditing Failure Message."));
                p.sendMessage(ConfigManager.fromSection("\u00a77Placeholders: " + placeholders));
                p.sendMessage(ConfigManager.fromSection("\u00a77Type 'default' to reset to config default."));
                p.sendMessage(ConfigManager.fromSection("\u00a7aEnter new message in chat."));
            }
        }
    }

    @Override
    public void setMenuItems() {
        this.setFillerGlass();
        this.inventory.setItem(53, this.makeItem(Material.BARRIER, "\u00a7cBack", new String[0]));
        this.inventory.setItem(49, this.makeItem(Material.ANVIL, "\u00a7aAdd New Cost", "\u00a77Add a requirement to use this item."));
        List costList = ItemsConfig.get().getMapList("items." + this.itemId + ".active-mode.costs");
        int index = 0;
        for (Map costData : costList) {
            if (index >= 45) break;
            this.inventory.setItem(index, this.createVisualItem(costData, index));
            ++index;
        }
    }

    private ItemStack createVisualItem(Map<?, ?> map, int index) {
        ItemStack displayItem;
        String type = (String)map.get("type");
        Object amountObj = map.get("amount");
        String amountStr = String.valueOf(amountObj);
        String message = (String)map.get("message");
        boolean isError = false;
        Object errorDetail = "";
        Component title = null;
        ArrayList<Object> lore = new ArrayList<Object>();
        if ("ITEM".equals(type)) {
            Object matObj = map.get("material");
            String matName = matObj != null ? matObj.toString() : "NULL";
            Material mat = Material.matchMaterial((String)matName);
            if (mat == null) {
                isError = true;
                displayItem = new ItemStack(Material.BARRIER);
                title = ConfigManager.fromSection("\u00a7cInvalid Item Cost");
                errorDetail = "Unknown Material: " + matName;
            } else {
                displayItem = new ItemStack(mat);
                title = ConfigManager.fromSection("\u00a7f" + amountStr + "x " + this.formatMaterialName(mat));
                lore.add(ConfigManager.fromSection("\u00a78Type: \u00a77Vanilla Item"));
                lore.add(ConfigManager.fromSection("\u00a78Material: \u00a7b" + mat.name()));
            }
        } else if ("BUFFED_ITEM".equals(type)) {
            String bItemId = (String)map.get("item_id");
            BuffedItem bItem = this.plugin.getItemManager().getBuffedItem(bItemId);
            if (bItem != null) {
                displayItem = new ItemBuilder(bItem, (Plugin)this.plugin).build();
                title = ConfigManager.fromSection("\u00a7f" + amountStr + "x ").append(ConfigManager.fromLegacy(bItem.getDisplayName()));
                lore.add(ConfigManager.fromSection("\u00a78Type: \u00a7#FF6347Buffed Item\u00a7#FFD700"));
                lore.add(ConfigManager.fromSection("\u00a78ID: \u00a77" + bItemId));
            } else {
                isError = true;
                displayItem = new ItemStack(Material.BARRIER);
                title = ConfigManager.fromSection("\u00a7cUnknown Buffed Item");
                errorDetail = "ID not found: " + bItemId;
            }
        } else if ("COINSENGINE".equals(type)) {
            String currencyId;
            Object currObj = map.get("currency_id");
            String string = currencyId = currObj != null ? currObj.toString() : "coins";
            if (!this.plugin.getHookManager().isCoinsEngineLoaded()) {
                isError = true;
                displayItem = new ItemStack(Material.BARRIER);
                title = ConfigManager.fromSection("\u00a7cCoinsEngine Missing");
                errorDetail = "Plugin not hooked!";
            } else {
                Currency currency = this.plugin.getHookManager().getCoinsEngineHook().getCurrency(currencyId);
                if (currency == null) {
                    isError = true;
                    displayItem = new ItemStack(Material.BARRIER);
                    title = ConfigManager.fromSection("\u00a7cInvalid Currency");
                    errorDetail = "Currency ID: " + currencyId;
                } else {
                    displayItem = new ItemStack(Material.SUNFLOWER);
                    title = ConfigManager.fromSection("\u00a7a" + currency.getName());
                    lore.add(ConfigManager.fromSection("\u00a78Type: \u00a77CoinsEngine"));
                    lore.add(ConfigManager.fromSection("\u00a78Currency ID: \u00a7e" + currencyId));
                    lore.add(ConfigManager.fromSection("\u00a78Amount: \u00a7e" + amountStr));
                }
            }
        } else if ("MONEY".equals(type)) {
            if (this.plugin.getHookManager().getVaultHook() == null) {
                isError = true;
                displayItem = new ItemStack(Material.BARRIER);
                title = ConfigManager.fromSection("\u00a7cVault Error");
                errorDetail = "Vault/Economy missing!";
            } else {
                displayItem = new ItemStack(Material.GOLD_INGOT);
                title = ConfigManager.fromSection("\u00a7aVault Currency");
                lore.add(ConfigManager.fromSection("\u00a78Type: \u00a77MONEY"));
                lore.add(ConfigManager.fromSection("\u00a78Amount: \u00a7e" + amountStr));
            }
        } else {
            Material iconMat = Material.PAPER;
            String name = type;
            boolean knownType = true;
            if ("EXPERIENCE".equals(type)) {
                iconMat = Material.EXPERIENCE_BOTTLE;
                name = "XP Points";
            } else if ("LEVEL".equals(type)) {
                iconMat = Material.ENCHANTING_TABLE;
                name = "XP Levels";
            } else if ("HUNGER".equals(type)) {
                iconMat = Material.COOKED_BEEF;
                name = "Food Level";
            } else if ("HEALTH".equals(type)) {
                iconMat = Material.RED_DYE;
                name = "Health (Hearts)";
            } else {
                knownType = false;
                isError = true;
                iconMat = Material.BARRIER;
                title = ConfigManager.fromSection("\u00a7cInvalid Cost Type");
                errorDetail = "Unknown Type: " + type;
            }
            displayItem = new ItemStack(iconMat);
            if (!isError) {
                title = ConfigManager.fromSection("\u00a7a" + name);
                lore.add(ConfigManager.fromSection("\u00a78Type: \u00a77" + type));
                lore.add(ConfigManager.fromSection("\u00a78Amount: \u00a7e" + amountStr));
            }
        }
        if (isError) {
            lore.add(ConfigManager.fromSection("\u00a7c\u26a0 CONFIGURATION ERROR"));
            lore.add(ConfigManager.fromSection("\u00a77" + (String)errorDetail));
            lore.add(ConfigManager.fromSection(""));
            lore.add(ConfigManager.fromSection("\u00a7eRight-Click to Remove"));
        } else {
            lore.add(Component.empty());
            lore.add(ConfigManager.fromSection("\u00a77Failure Message:"));
            if (message == null) {
                String defaultMsg = ConfigManager.getDefaultCostMessage(type);
                lore.add(ConfigManager.fromSection("\u00a7r").append(ConfigManager.fromLegacy(defaultMsg)));
                lore.add(ConfigManager.fromSection("\u00a78(Default Config)"));
            } else {
                lore.add(ConfigManager.fromSection("\u00a7r").append(ConfigManager.fromLegacy(message)));
            }
            lore.add(Component.empty());
            lore.add(ConfigManager.fromSection("\u00a7eLeft-Click to Edit Amount"));
            lore.add(ConfigManager.fromSection("\u00a7bShift+Left-Click to Edit Message"));
            lore.add(ConfigManager.fromSection("\u00a7cRight-Click to Remove"));
        }
        lore.add(ConfigManager.fromSection("\u00a78(#" + (index + 1) + ")"));
        ItemMeta meta = displayItem.getItemMeta();
        if (meta != null) {
            meta.displayName(title);
            meta.lore(lore);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
            displayItem.setItemMeta(meta);
        }
        return displayItem;
    }

    private String formatMaterialName(Material material) {
        String name = material.name().toLowerCase().replace("_", " ");
        StringBuilder sb = new StringBuilder();
        for (String word : name.split(" ")) {
            sb.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return sb.toString().trim();
    }
}

