/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.manager.upgrade;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.config.UpgradesConfig;
import io.github.altkat.BuffedItems.manager.cost.ICost;
import io.github.altkat.BuffedItems.manager.cost.types.BuffedItemCost;
import io.github.altkat.BuffedItems.manager.upgrade.FailureAction;
import io.github.altkat.BuffedItems.manager.upgrade.UpgradeRecipe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;

public class UpgradeManager {
    private final BuffedItems plugin;
    private final Map<String, UpgradeRecipe> recipes = new HashMap<String, UpgradeRecipe>();

    public UpgradeManager(BuffedItems plugin) {
        this.plugin = plugin;
    }

    public void loadRecipes(boolean silent) {
        long startTime = System.currentTimeMillis();
        this.recipes.clear();
        if (!UpgradesConfig.get().getBoolean("settings.enabled", true)) {
            ConfigManager.sendDebugMessage(1, () -> "Upgrade system is disabled in upgrades.yml");
            return;
        }
        ConfigurationSection section = UpgradesConfig.get().getConfigurationSection("upgrades");
        if (section == null) {
            if (!silent) {
                ConfigManager.logInfo("&eNo upgrade recipes found in upgrades.yml.");
            }
            return;
        }
        ConfigManager.sendDebugMessage(1, () -> "[UpgradeManager] Loading recipes from config...");
        int validCount = 0;
        int invalidCount = 0;
        ArrayList<String> recipesWithErrors = new ArrayList<String>();
        for (String key : section.getKeys(false)) {
            FailureAction failureAction;
            ConfigurationSection recipeSection = section.getConfigurationSection(key);
            if (recipeSection == null) continue;
            ArrayList<String> errors = new ArrayList<String>();
            boolean isValid = true;
            String displayName = recipeSection.getString("display_name", key);
            String resultItem = recipeSection.getString("result.item");
            int resultAmount = recipeSection.getInt("result.amount", 1);
            double chance = recipeSection.getDouble("success_rate", 100.0);
            String actionStr = recipeSection.getString("failure_action", "LOSE_EVERYTHING");
            try {
                failureAction = FailureAction.valueOf(actionStr.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                failureAction = FailureAction.LOSE_EVERYTHING;
                errors.add("Invalid failure_action '" + actionStr + "'. Defaulted to LOSE_EVERYTHING.");
            }
            if (resultItem == null || this.plugin.getItemManager().getBuffedItem(resultItem) == null) {
                isValid = false;
                errors.add("Invalid Result Item: " + (resultItem == null ? "NULL" : resultItem));
            }
            if (resultAmount <= 0) {
                isValid = false;
                errors.add("Result amount must be positive.");
            }
            ICost baseCost = null;
            if (recipeSection.contains("base") && recipeSection.isString("base")) {
                String itemId = recipeSection.getString("base");
                HashMap<String, Object> syntheticMap = new HashMap<String, Object>();
                syntheticMap.put("type", "BUFFED_ITEM");
                syntheticMap.put("amount", 1);
                syntheticMap.put("item_id", itemId);
                try {
                    baseCost = this.plugin.getCostManager().parseCost(syntheticMap);
                }
                catch (Exception e) {
                    errors.add("Base Item Error: " + e.getMessage());
                }
            }
            if (baseCost == null) {
                isValid = false;
                errors.add("Missing or Invalid Base Item ID.");
            } else if (!(baseCost instanceof BuffedItemCost)) {
                isValid = false;
                errors.add("Base item MUST be a BUFFED_ITEM (Vanilla items not allowed as base).");
            } else {
                BuffedItemCost bCost = (BuffedItemCost)baseCost;
                if (bCost.getAmount() != 1) {
                    isValid = false;
                    errors.add("Base item amount MUST be exactly 1.");
                } else if (this.plugin.getItemManager().getBuffedItem(bCost.getRequiredItemId()) == null) {
                    isValid = false;
                    errors.add("Invalid Base Item ID: " + bCost.getRequiredItemId());
                }
            }
            ArrayList<ICost> ingredients = new ArrayList<ICost>();
            if (recipeSection.contains("ingredients")) {
                List ingredientsMap = recipeSection.getMapList("ingredients");
                for (int i = 0; i < ingredientsMap.size(); ++i) {
                    String type;
                    Map rawMap = (Map)ingredientsMap.get(i);
                    try {
                        ICost cost = this.plugin.getCostManager().parseCost(rawMap);
                        if (cost != null) {
                            ingredients.add(cost);
                            continue;
                        }
                        isValid = false;
                        type = String.valueOf(rawMap.get("type"));
                        errors.add("Invalid Ingredient at index " + (i + 1) + " (Unknown Type: " + type + ")");
                        continue;
                    }
                    catch (Exception e) {
                        isValid = false;
                        type = String.valueOf(rawMap.get("type"));
                        errors.add("Invalid Ingredient at index " + (i + 1) + " (" + type + "): " + e.getMessage());
                    }
                }
            }
            if (isValid) {
                ++validCount;
            } else {
                ++invalidCount;
                recipesWithErrors.add(key);
            }
            UpgradeRecipe recipe = new UpgradeRecipe(key, displayName, baseCost, ingredients, resultItem, resultAmount, chance, failureAction, isValid, errors);
            this.recipes.put(key, recipe);
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        if (!silent) {
            ConfigManager.logInfo("&aLoaded &e" + this.recipes.size() + "&a upgrade recipes (&e" + validCount + "&a valid, &e" + invalidCount + "&c with errors&a) in &e" + elapsedTime + "&ams");
            if (invalidCount > 0) {
                String separator = "============================================================";
                this.plugin.getLogger().warning(separator);
                this.plugin.getLogger().warning("\u26a0 " + invalidCount + " upgrade recipe(s) have configuration errors:");
                for (String recipeId : recipesWithErrors) {
                    UpgradeRecipe recipe = this.recipes.get(recipeId);
                    this.plugin.getLogger().warning("  \u2022 " + recipeId + " (" + recipe.getErrorMessages().size() + " error(s))");
                    if (!ConfigManager.isDebugLevelEnabled(1)) continue;
                    for (String error : recipe.getErrorMessages()) {
                        this.plugin.getLogger().warning("    - " + ConfigManager.stripLegacy(error));
                    }
                }
                this.plugin.getLogger().warning("Use /bi menu -> Configure Upgrades to fix these errors.");
                this.plugin.getLogger().warning(separator);
            }
        }
    }

    public UpgradeRecipe getRecipe(String id) {
        return this.recipes.get(id);
    }

    public Map<String, UpgradeRecipe> getRecipes() {
        return this.recipes;
    }
}

