/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.manager.crafting;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.config.RecipesConfig;
import io.github.altkat.BuffedItems.manager.crafting.CustomRecipe;
import io.github.altkat.BuffedItems.manager.crafting.ItemMatcher;
import io.github.altkat.BuffedItems.manager.crafting.MatchType;
import io.github.altkat.BuffedItems.manager.crafting.RecipeIngredient;
import io.github.altkat.BuffedItems.utility.Serializer;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import io.github.altkat.BuffedItems.utility.item.ItemBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CraftingManager {
    private final BuffedItems plugin;
    private final Map<String, CustomRecipe> recipes;
    private final ItemMatcher itemMatcher;
    private final Set<NamespacedKey> trackedKeys = new HashSet<NamespacedKey>();
    private BukkitRunnable registrationTask;
    private BukkitRunnable removalTask;

    public CraftingManager(BuffedItems plugin) {
        this.plugin = plugin;
        this.recipes = new LinkedHashMap<String, CustomRecipe>();
        this.itemMatcher = new ItemMatcher(plugin);
    }

    public void loadRecipes(boolean silent) {
        long startTime = System.currentTimeMillis();
        if (this.registrationTask != null && !this.registrationTask.isCancelled()) {
            this.registrationTask.cancel();
            this.registrationTask = null;
        }
        if (this.removalTask != null && !this.removalTask.isCancelled()) {
            this.removalTask.cancel();
            this.removalTask = null;
        }
        this.unloadRecipes();
        this.recipes.clear();
        if (!RecipesConfig.get().getBoolean("settings.enabled", true)) {
            ConfigManager.sendDebugMessage(1, () -> "Custom Crafting system is disabled in recipes.yml");
            return;
        }
        ConfigurationSection section = RecipesConfig.get().getConfigurationSection("recipes");
        if (section == null) {
            if (!silent) {
                ConfigManager.logInfo("&eNo custom recipes found in recipes.yml.");
            }
            return;
        }
        if (!silent) {
            ConfigManager.sendDebugMessage(1, () -> "[CraftingManager] Loading recipes...");
        }
        int validCount = 0;
        int invalidCount = 0;
        ArrayList<String> recipesWithErrors = new ArrayList<String>();
        ConcurrentLinkedQueue<CustomRecipe> registrationQueue = new ConcurrentLinkedQueue<CustomRecipe>();
        boolean shouldRegisterToBook = RecipesConfig.get().getBoolean("settings.register-to-book", true);
        for (String recipeId : section.getKeys(false)) {
            ConfigurationSection rSection = section.getConfigurationSection(recipeId);
            if (rSection == null) continue;
            CustomRecipe recipe = this.parseRecipeFromConfig(recipeId, rSection);
            this.recipes.put(recipeId, recipe);
            if (recipe.isValid()) {
                ++validCount;
                if (!shouldRegisterToBook || !recipe.isEnabled()) continue;
                registrationQueue.add(recipe);
                continue;
            }
            ++invalidCount;
            recipesWithErrors.add(recipeId);
        }
        this.printLoadLog(silent, validCount, invalidCount, recipesWithErrors, startTime);
        if (!registrationQueue.isEmpty()) {
            this.startBatchRegistration(registrationQueue, silent);
        }
    }

    private void startBatchRegistration(final Queue<CustomRecipe> queue, final boolean silent) {
        int BATCH_SIZE = 2;
        final int totalToRegister = queue.size();
        this.registrationTask = new BukkitRunnable(){

            public void run() {
                if (queue.isEmpty()) {
                    this.cancel();
                    if (!silent) {
                        ConfigManager.sendDebugMessage(1, () -> "[CraftingManager] Background task finished: Registered " + totalToRegister + " recipes to Bukkit.");
                    }
                    return;
                }
                long batchStart = System.nanoTime();
                for (int count = 0; !queue.isEmpty() && count < 2; ++count) {
                    CustomRecipe recipe = (CustomRecipe)queue.poll();
                    if (recipe == null) continue;
                    CraftingManager.this.registerBukkitRecipe(recipe);
                    if (System.nanoTime() - batchStart <= 1500000L) continue;
                    break;
                }
            }
        };
        this.registrationTask.runTaskTimer((Plugin)this.plugin, 1L, 2L);
    }

    private void printLoadLog(boolean silent, int valid, int invalid, List<String> errorIds, long startTime) {
        if (silent) {
            return;
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        ConfigManager.logInfo("&aLoaded &e" + valid + "&a custom recipes into memory (&e" + valid + "&a valid, &c" + invalid + "&a with errors) in &e" + elapsedTime + "&ams.");
        if (invalid > 0) {
            String separator = "============================================================";
            this.plugin.getLogger().warning(separator);
            this.plugin.getLogger().warning("\u26a0 " + invalid + " custom recipe(s) have configuration errors:");
            for (String rId : errorIds) {
                this.plugin.getLogger().warning("  \u2022 " + rId);
                CustomRecipe r = this.recipes.get(rId);
                if (r == null) continue;
                for (String err : r.getErrorMessages()) {
                    this.plugin.getLogger().warning("    - " + err);
                }
            }
            this.plugin.getLogger().warning(separator);
        }
    }

    public void unloadRecipes() {
        if (this.registrationTask != null && !this.registrationTask.isCancelled()) {
            this.registrationTask.cancel();
            this.registrationTask = null;
        }
        if (this.removalTask != null && !this.removalTask.isCancelled()) {
            this.removalTask.cancel();
            this.removalTask = null;
        }
        if (this.trackedKeys.isEmpty()) {
            return;
        }
        ConcurrentLinkedQueue<NamespacedKey> removalQueue = new ConcurrentLinkedQueue<NamespacedKey>(this.trackedKeys);
        this.trackedKeys.clear();
        this.startBatchRemoval(removalQueue);
    }

    private void startBatchRemoval(final Queue<NamespacedKey> queue) {
        int BATCH_SIZE = 5;
        this.removalTask = new BukkitRunnable(){

            public void run() {
                if (queue.isEmpty()) {
                    this.cancel();
                    return;
                }
                long batchStart = System.nanoTime();
                for (int count = 0; !queue.isEmpty() && count < 5; ++count) {
                    NamespacedKey key = (NamespacedKey)queue.poll();
                    if (key == null) continue;
                    try {
                        Bukkit.removeRecipe((NamespacedKey)key);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (System.nanoTime() - batchStart <= 2000000L) continue;
                    break;
                }
            }
        };
        this.removalTask.runTaskTimer((Plugin)this.plugin, 0L, 2L);
    }

    private CustomRecipe parseRecipeFromConfig(String recipeId, ConfigurationSection rSection) {
        String resultItemId = rSection.getString("result.item");
        int resultAmount = rSection.getInt("result.amount", 1);
        List shape = rSection.getStringList("shape");
        String permission = rSection.getString("permission");
        boolean enabled = rSection.getBoolean("enabled", true);
        CustomRecipe recipe = new CustomRecipe(recipeId, resultItemId, resultAmount, shape, permission);
        recipe.setEnabled(enabled);
        if (resultItemId == null || this.plugin.getItemManager().getBuffedItem(resultItemId) == null) {
            recipe.addErrorMessage("Invalid Result Item: " + resultItemId);
        }
        if (resultAmount <= 0) {
            recipe.addErrorMessage("Result amount must be positive.");
        }
        if (shape.isEmpty() || shape.size() > 3) {
            recipe.addErrorMessage("Invalid Shape Size.");
        } else {
            boolean empty = true;
            for (String s : shape) {
                if (s.trim().isEmpty()) continue;
                empty = false;
            }
            if (empty) {
                recipe.addErrorMessage("Shape cannot be empty.");
            }
        }
        ConfigurationSection ingSection = rSection.getConfigurationSection("ingredients");
        if (ingSection != null) {
            for (String key : ingSection.getKeys(false)) {
                MatchType type;
                if (key.length() != 1) continue;
                char c = key.charAt(0);
                String typeStr = ingSection.getString(key + ".type", "MATERIAL");
                String value = ingSection.getString(key + ".value", "AIR");
                int amount = ingSection.getInt(key + ".amount", 1);
                try {
                    type = MatchType.valueOf(typeStr.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    recipe.addErrorMessage("Invalid type: " + typeStr);
                    continue;
                }
                Material mat = Material.STONE;
                ItemStack exactStack = null;
                if (type == MatchType.MATERIAL) {
                    mat = Material.matchMaterial((String)value);
                    if (mat == null) {
                        recipe.addErrorMessage("Invalid Material: " + value);
                    }
                } else if (type == MatchType.BUFFED_ITEM) {
                    BuffedItem bi = this.plugin.getItemManager().getBuffedItem(value);
                    if (bi != null) {
                        mat = bi.getMaterial();
                    } else {
                        recipe.addErrorMessage("Unknown BuffedItem: " + value);
                    }
                } else if (type == MatchType.EXACT) {
                    exactStack = Serializer.fromBase64(value);
                    if (exactStack != null) {
                        mat = exactStack.getType();
                    } else {
                        recipe.addErrorMessage("Invalid Base64");
                    }
                }
                RecipeIngredient ingredient = new RecipeIngredient(type, mat, value, amount);
                if (exactStack != null) {
                    ingredient.setExactReferenceItem(exactStack);
                }
                recipe.addIngredient(c, ingredient);
            }
        }
        if (recipe.isValid()) {
            HashSet<Character> shapeChars = new HashSet<Character>();
            for (String line : shape) {
                for (char c : line.toCharArray()) {
                    if (c == ' ') continue;
                    shapeChars.add(Character.valueOf(c));
                }
            }
            Iterator<Object> iterator = shapeChars.iterator();
            while (iterator.hasNext()) {
                char c = ((Character)iterator.next()).charValue();
                if (recipe.getIngredients().containsKey(Character.valueOf(c))) continue;
                recipe.addErrorMessage("Shape contains character '" + c + "' but it is not defined in ingredients.");
            }
            iterator = recipe.getIngredients().keySet().iterator();
            while (iterator.hasNext()) {
                char c = ((Character)iterator.next()).charValue();
                if (shapeChars.contains(Character.valueOf(c))) continue;
                recipe.addErrorMessage("Ingredient '" + c + "' is defined but not used in the shape.");
            }
        }
        return recipe;
    }

    private void registerBukkitRecipe(CustomRecipe recipe) {
        try {
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, recipe.getId());
            try {
                Bukkit.removeRecipe((NamespacedKey)key);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.trackedKeys.add(key);
            BuffedItem item = this.plugin.getItemManager().getBuffedItem(recipe.getResultItemId());
            if (item == null) {
                return;
            }
            ItemStack resultStack = new ItemBuilder(item, (Plugin)this.plugin).build();
            resultStack.setAmount(recipe.getAmount());
            ShapedRecipe bukkitRecipe = new ShapedRecipe(key, resultStack);
            List<String> shape = recipe.getShape();
            bukkitRecipe.shape(shape.toArray(new String[0]));
            for (Map.Entry<Character, RecipeIngredient> entry : recipe.getIngredients().entrySet()) {
                char charKey = entry.getKey().charValue();
                RecipeIngredient ingredient = entry.getValue();
                if (ingredient.getMatchType() == MatchType.BUFFED_ITEM) {
                    BuffedItem bi = this.plugin.getItemManager().getBuffedItem(ingredient.getData());
                    if (bi == null) continue;
                    ItemStack exactItem = new ItemBuilder(bi, (Plugin)this.plugin).build();
                    exactItem.setAmount(1);
                    bukkitRecipe.setIngredient(charKey, (RecipeChoice)new RecipeChoice.ExactChoice(exactItem));
                    continue;
                }
                if (ingredient.getMatchType() == MatchType.EXACT && ingredient.getExactReferenceItem() != null) {
                    ItemStack exactItem = ingredient.getExactReferenceItem().clone();
                    exactItem.setAmount(1);
                    bukkitRecipe.setIngredient(charKey, (RecipeChoice)new RecipeChoice.ExactChoice(exactItem));
                    continue;
                }
                if (ingredient.getMaterial() == null) continue;
                bukkitRecipe.setIngredient(charKey, ingredient.getMaterial());
            }
            Bukkit.addRecipe((Recipe)bukkitRecipe);
        }
        catch (Exception e) {
            ConfigManager.logInfo("Failed to register Bukkit recipe: " + recipe.getId());
        }
    }

    public CustomRecipe findRecipe(ItemStack[] matrix) {
        if (this.isMatrixEmpty(matrix)) {
            return null;
        }
        for (CustomRecipe recipe : this.recipes.values()) {
            if (!recipe.isValid() || !this.matchesShaped(matrix, recipe)) continue;
            return recipe;
        }
        return null;
    }

    private boolean isMatrixEmpty(ItemStack[] matrix) {
        for (ItemStack item : matrix) {
            if (item == null || item.getType().isAir()) continue;
            return false;
        }
        return true;
    }

    private boolean matchesShaped(ItemStack[] inputMatrix, CustomRecipe recipe) {
        List<String> shape = recipe.getShape();
        if (shape == null || shape.isEmpty()) {
            return false;
        }
        char[][] recipeGrid = this.parseShape(shape);
        if (recipeGrid.length == 0) {
            return false;
        }
        int recipeHeight = recipeGrid.length;
        int recipeWidth = recipeGrid[0].length;
        for (int i = 0; i <= 3 - recipeHeight; ++i) {
            for (int j = 0; j <= 3 - recipeWidth; ++j) {
                if (!this.checkMatchAt(inputMatrix, recipe, recipeGrid, i, j)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatchAt(ItemStack[] inputMatrix, CustomRecipe recipe, char[][] recipeGrid, int startRow, int startCol) {
        int recipeHeight = recipeGrid.length;
        int recipeWidth = recipeGrid[0].length;
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 3; ++c) {
                char key;
                RecipeIngredient ingredient;
                boolean inRecipeArea;
                int slotIndex = r * 3 + c;
                ItemStack inputItem = slotIndex < inputMatrix.length ? inputMatrix[slotIndex] : null;
                boolean bl = inRecipeArea = r >= startRow && r < startRow + recipeHeight && c >= startCol && c < startCol + recipeWidth;
                if (!(inRecipeArea ? ((ingredient = recipe.getIngredient(key = recipeGrid[r - startRow][c - startCol])) == null ? inputItem != null && !inputItem.getType().isAir() : !this.plugin.getCraftingManager().getItemMatcher().matches(inputItem, ingredient)) : inputItem != null && !inputItem.getType().isAir())) continue;
                return false;
            }
        }
        return true;
    }

    private char[][] parseShape(List<String> rawShape) {
        int minRow = 3;
        int maxRow = -1;
        int minCol = 3;
        int maxCol = -1;
        for (int r = 0; r < rawShape.size() && r < 3; ++r) {
            String rowStr = rawShape.get(r);
            for (int c = 0; c < rowStr.length() && c < 3; ++c) {
                char ch = rowStr.charAt(c);
                if (ch == ' ') continue;
                if (r < minRow) {
                    minRow = r;
                }
                if (r > maxRow) {
                    maxRow = r;
                }
                if (c < minCol) {
                    minCol = c;
                }
                if (c <= maxCol) continue;
                maxCol = c;
            }
        }
        if (maxRow == -1) {
            return new char[0][0];
        }
        int height = maxRow - minRow + 1;
        int width = maxCol - minCol + 1;
        char[][] grid = new char[height][width];
        for (int r = 0; r < height; ++r) {
            String rowStr = rawShape.get(minRow + r);
            for (int c = 0; c < width; ++c) {
                int targetCol = minCol + c;
                grid[r][c] = targetCol < rowStr.length() ? rowStr.charAt(targetCol) : (char)32;
            }
        }
        return grid;
    }

    public Map<String, CustomRecipe> getRecipes() {
        return this.recipes;
    }

    public ItemMatcher getItemMatcher() {
        return this.itemMatcher;
    }
}

