/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.manager.cost.types;

import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.cost.ICost;
import java.util.Map;
import org.bukkit.entity.Player;

public class ExperienceCost
implements ICost {
    private final int amount;
    private final String failureMessage;

    public ExperienceCost(Map<String, Object> data) {
        this.amount = ((Number)data.getOrDefault("amount", 0)).intValue();
        if (this.amount <= 0) {
            throw new IllegalArgumentException("Amount must be positive.");
        }
        String defaultMsg = ConfigManager.getDefaultCostMessage("EXPERIENCE");
        this.failureMessage = (String)data.getOrDefault("message", defaultMsg);
    }

    @Override
    public String getDisplayString() {
        return this.amount + " XP Points";
    }

    @Override
    public boolean hasEnough(Player player) {
        return this.getTotalExperience(player) >= this.amount;
    }

    @Override
    public void deduct(Player player) {
        int current = this.getTotalExperience(player);
        this.setTotalExperience(player, Math.max(0, current - this.amount));
    }

    @Override
    public String getFailureMessage() {
        return ConfigManager.stripLegacy(this.failureMessage).replace("{amount}", String.valueOf(this.amount));
    }

    private int getTotalExperience(Player player) {
        int experience = 0;
        int level = player.getLevel();
        if (level >= 0 && level <= 15) {
            experience = (int)Math.ceil(Math.pow(level, 2.0) + (double)(6 * level));
            int requiredExperience = 2 * level + 7;
            double currentExp = Double.parseDouble(Float.toString(player.getExp()));
            experience = (int)((double)experience + Math.ceil(currentExp * (double)requiredExperience));
        } else if (level > 15 && level <= 30) {
            experience = (int)Math.ceil(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
            int requiredExperience = 5 * level - 38;
            double currentExp = Double.parseDouble(Float.toString(player.getExp()));
            experience = (int)((double)experience + Math.ceil(currentExp * (double)requiredExperience));
        } else {
            experience = (int)Math.ceil(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
            int requiredExperience = 9 * level - 158;
            double currentExp = Double.parseDouble(Float.toString(player.getExp()));
            experience = (int)((double)experience + Math.ceil(currentExp * (double)requiredExperience));
        }
        return experience;
    }

    private void setTotalExperience(Player player, int amount) {
        player.setExp(0.0f);
        player.setLevel(0);
        player.setTotalExperience(0);
        player.giveExp(amount);
    }
}

