/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.manager.cost.types;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.cost.ICost;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import java.util.Map;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class BuffedItemCost
implements ICost {
    private final BuffedItems plugin;
    private final String requiredItemId;
    private final int amount;
    private final String failureMessage;
    private final NamespacedKey nbtKey;

    public BuffedItemCost(Map<String, Object> data, BuffedItems plugin) {
        this.plugin = plugin;
        this.requiredItemId = (String)data.get("item_id");
        if (this.requiredItemId == null || this.requiredItemId.trim().isEmpty()) {
            throw new IllegalArgumentException("Missing 'item_id' for BUFFED_ITEM cost.");
        }
        this.amount = ((Number)data.getOrDefault("amount", 1)).intValue();
        if (this.amount <= 0) {
            throw new IllegalArgumentException("Amount must be positive.");
        }
        String defaultMsg = "&cMissing Item: &e{amount}x {item_name}";
        if (plugin.getConfig().contains("active-items.costs.messages.buffed_item")) {
            defaultMsg = plugin.getConfig().getString("active-items.costs.messages.buffed_item");
        }
        this.failureMessage = (String)data.getOrDefault("message", defaultMsg);
        this.nbtKey = new NamespacedKey((Plugin)plugin, "buffeditem_id");
    }

    public int getAmount() {
        return this.amount;
    }

    public String getRequiredItemId() {
        return this.requiredItemId;
    }

    @Override
    public String getDisplayString() {
        BuffedItem item = this.plugin.getItemManager().getBuffedItem(this.requiredItemId);
        String displayName = item != null ? ConfigManager.toSection(ConfigManager.fromLegacy(item.getDisplayName())) : this.requiredItemId;
        return "\u00a7f" + this.amount + "x " + displayName;
    }

    @Override
    public boolean hasEnough(Player player) {
        int count = 0;
        for (ItemStack item : player.getInventory().getContents()) {
            if (!this.isMatchingItem(item)) continue;
            count += item.getAmount();
        }
        return count >= this.amount;
    }

    @Override
    public void deduct(Player player) {
        int remainingToRemove = this.amount;
        ItemStack[] contents = player.getInventory().getContents();
        for (int i = 0; i < contents.length; ++i) {
            ItemStack item = contents[i];
            if (!this.isMatchingItem(item)) continue;
            if (item.getAmount() <= remainingToRemove) {
                remainingToRemove -= item.getAmount();
                player.getInventory().setItem(i, null);
            } else {
                item.setAmount(item.getAmount() - remainingToRemove);
                remainingToRemove = 0;
            }
            if (remainingToRemove <= 0) break;
        }
    }

    @Override
    public String getFailureMessage() {
        BuffedItem item = this.plugin.getItemManager().getBuffedItem(this.requiredItemId);
        String displayName = item != null ? item.getDisplayName() : this.requiredItemId;
        return ConfigManager.stripLegacy(this.failureMessage).replace("{amount}", String.valueOf(this.amount)).replace("{item_name}", displayName).replace("{item_id}", this.requiredItemId);
    }

    private boolean isMatchingItem(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        String itemId = (String)item.getItemMeta().getPersistentDataContainer().get(this.nbtKey, PersistentDataType.STRING);
        return this.requiredItemId.equals(itemId);
    }
}

