/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.listener.handler;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.listener.handler.ChatInputHandler;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.config.SetsConfig;
import io.github.altkat.BuffedItems.menu.set.SetBonusesMenu;
import io.github.altkat.BuffedItems.menu.set.SetEditorMenu;
import io.github.altkat.BuffedItems.menu.set.SetListMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import org.bukkit.entity.Player;

public class SetInputHandler
implements ChatInputHandler {
    private final BuffedItems plugin;

    public SetInputHandler(BuffedItems plugin) {
        this.plugin = plugin;
    }

    @Override
    public void handle(Player player, PlayerMenuUtility pmu, String input, String path, String itemId) {
        if (path.equals("create_set")) {
            String newSetId = input.toLowerCase().replace(" ", "_");
            if (ConfigManager.createNewSet(newSetId)) {
                player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aSet '" + newSetId + "' created successfully!"));
                new SetListMenu(pmu, this.plugin).open();
            } else {
                player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: A set with that ID already exists."));
                new SetListMenu(pmu, this.plugin).open();
            }
            pmu.setWaitingForChatInput(false);
            pmu.setChatInputPath(null);
        }
        if (path.equals("set_display_name")) {
            String setId = pmu.getItemToEditId();
            SetsConfig.get().set("sets." + setId + ".display_name", (Object)input);
            SetsConfig.save();
            this.plugin.getSetManager().loadSets(true);
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aSet display name updated!"));
            pmu.setWaitingForChatInput(false);
            pmu.setChatInputPath(null);
            new SetEditorMenu(pmu, this.plugin).open();
        } else if (path.equals("create_bonus_tier")) {
            try {
                int count = Integer.parseInt(input);
                if (count <= 0) {
                    throw new NumberFormatException();
                }
                String setId = pmu.getItemToEditId();
                String basePath = "sets." + setId + ".bonuses." + count;
                if (SetsConfig.get().contains(basePath)) {
                    player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cBonus tier " + count + " already exists."));
                } else {
                    SetsConfig.get().createSection(basePath);
                    SetsConfig.save();
                    this.plugin.getSetManager().loadSets(true);
                    player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aBonus tier " + count + " created!"));
                }
                pmu.setWaitingForChatInput(false);
                pmu.setChatInputPath(null);
                new SetBonusesMenu(pmu, this.plugin).open();
            }
            catch (NumberFormatException e) {
                player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cInvalid number. Enter a positive integer."));
                pmu.setWaitingForChatInput(false);
                pmu.setChatInputPath(null);
                new SetBonusesMenu(pmu, this.plugin).open();
            }
        }
    }
}

