/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.listener.handler;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.listener.handler.ChatInputHandler;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.menu.editor.ItemEditorMenu;
import io.github.altkat.BuffedItems.menu.editor.PermissionSettingsMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import java.util.regex.Pattern;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class BasicInputHandler
implements ChatInputHandler {
    private final BuffedItems plugin;
    private static final Pattern PERMISSION_NODE_PATTERN = Pattern.compile("^[a-z0-9]([a-z0-9._-]*[a-z0-9])?$", 2);

    public BasicInputHandler(BuffedItems plugin) {
        this.plugin = plugin;
    }

    @Override
    public void handle(Player player, PlayerMenuUtility pmu, String input, String path, String itemId) {
        switch (path) {
            case "display_name": {
                this.handleDisplayNameEdit(player, pmu, input, itemId);
                break;
            }
            case "permission": {
                this.handlePermissionEdit(player, pmu, input, itemId, "permission");
                break;
            }
            case "active_permission": {
                this.handlePermissionEdit(player, pmu, input, itemId, "active_permission");
                break;
            }
            case "passive_permission": {
                this.handlePermissionEdit(player, pmu, input, itemId, "passive_permission");
                break;
            }
            case "material.manual": {
                this.handleMaterialManualEdit(player, pmu, input, itemId);
                break;
            }
            case "custom_model_data": {
                this.handleCustomModelDataEdit(player, pmu, input, itemId);
            }
        }
    }

    private void handleDisplayNameEdit(Player player, PlayerMenuUtility pmu, String input, String itemId) {
        ConfigManager.setItemValue(itemId, "display_name", input);
        player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aDisplay name has been updated!"));
        this.closeChatInput(pmu);
        new ItemEditorMenu(pmu, this.plugin).open();
    }

    private void handlePermissionEdit(Player player, PlayerMenuUtility pmu, String input, String itemId, String configKey) {
        if ("none".equalsIgnoreCase(input) || "remove".equalsIgnoreCase(input)) {
            ConfigManager.setItemValue(itemId, configKey, null);
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7a" + configKey + " has been removed/reset."));
            ConfigManager.sendDebugMessage(3, () -> "[BasicHandler] Removed " + configKey + " for " + itemId);
        } else if (this.isValidPermissionNode(input)) {
            ConfigManager.setItemValue(itemId, configKey, input);
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7a" + configKey + " has been set to: " + input));
            ConfigManager.sendDebugMessage(3, () -> "[BasicHandler] Set " + configKey + " for " + itemId + " to: " + input);
        } else {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cInvalid permission node! Permissions can only contain letters, numbers, dots (.), hyphens (-), and underscores (_)."));
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cYour input was: \u00a7e" + input));
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a77(Type 'cancel' to exit)"));
            return;
        }
        this.closeChatInput(pmu);
        new PermissionSettingsMenu(pmu, this.plugin).open();
    }

    private void handleMaterialManualEdit(Player player, PlayerMenuUtility pmu, String input, String itemId) {
        String materialName = input.toUpperCase().replaceAll("\\s+", "_");
        Material selectedMaterial = Material.matchMaterial((String)materialName);
        if (selectedMaterial != null && selectedMaterial.isItem()) {
            ConfigManager.setItemValue(itemId, "material", selectedMaterial.name());
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aMaterial has been updated to " + selectedMaterial.name()));
            this.closeChatInput(pmu);
            new ItemEditorMenu(pmu, this.plugin).open();
        } else {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: Invalid material name: '" + input + "'"));
            player.sendMessage(ConfigManager.fromSection("\u00a7cMaterial not found or is not an item. Please try again."));
            player.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
        }
    }

    private void handleCustomModelDataEdit(Player player, PlayerMenuUtility pmu, String input, String itemId) {
        if ("none".equalsIgnoreCase(input) || "remove".equalsIgnoreCase(input)) {
            ConfigManager.setItemValue(itemId, "custom-model-data", null);
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aCustom Model Data has been removed."));
            this.closeChatInput(pmu);
        } else {
            try {
                int directValue = Integer.parseInt(input);
                if (directValue < 0) {
                    throw new NumberFormatException();
                }
                ConfigManager.setItemValue(itemId, "custom-model-data", directValue);
                player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aCustom Model Data set to: \u00a7e" + directValue));
                this.closeChatInput(pmu);
            }
            catch (NumberFormatException ex) {
                if (input.contains(":")) {
                    ConfigManager.setItemValue(itemId, "custom-model-data", input);
                    player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aCustom Model Data set to: \u00a7e" + input));
                    player.sendMessage(ConfigManager.fromSection("\u00a77It will be resolved on next reload/save."));
                    this.closeChatInput(pmu);
                }
                player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cInvalid format! Use:"));
                player.sendMessage(ConfigManager.fromSection("\u00a7e100001 \u00a77(direct integer)"));
                player.sendMessage(ConfigManager.fromSection("\u00a7eitemsadder:item_id"));
                player.sendMessage(ConfigManager.fromSection("\u00a7enexo:item_id"));
                player.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
                pmu.setWaitingForChatInput(true);
                pmu.setChatInputPath("custom_model_data");
                return;
            }
        }
        new ItemEditorMenu(pmu, this.plugin).open();
    }

    private void closeChatInput(PlayerMenuUtility pmu) {
        pmu.setWaitingForChatInput(false);
        pmu.setChatInputPath(null);
    }

    private boolean isValidPermissionNode(String input) {
        if (input.contains("..") || input.startsWith(".") || input.endsWith(".")) {
            return false;
        }
        return PERMISSION_NODE_PATTERN.matcher(input).matches();
    }
}

