/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.listener;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ItemConsumeListener
implements Listener {
    private final BuffedItems plugin;
    private final NamespacedKey nbtKey;

    public ItemConsumeListener(BuffedItems plugin) {
        this.plugin = plugin;
        this.nbtKey = new NamespacedKey((Plugin)plugin, "buffeditem_id");
    }

    @EventHandler
    public void onItemConsume(PlayerItemConsumeEvent e) {
        ItemStack consumedItem = e.getItem();
        if (consumedItem == null || !consumedItem.hasItemMeta()) {
            return;
        }
        String itemId = (String)consumedItem.getItemMeta().getPersistentDataContainer().get(this.nbtKey, PersistentDataType.STRING);
        if (itemId == null) {
            return;
        }
        BuffedItem buffedItem = this.plugin.getItemManager().getBuffedItem(itemId);
        if (buffedItem == null) {
            return;
        }
        if (buffedItem.getFlag("PREVENT_CONSUME")) {
            e.setCancelled(true);
            String rawMsg = this.plugin.getConfig().getString("messages.protection-prevent-consume", "&cYou cannot consume this.");
            String parsedMsg = this.plugin.getHookManager().processPlaceholders((OfflinePlayer)e.getPlayer(), rawMsg);
            e.getPlayer().sendMessage(ConfigManager.fromLegacyWithPrefix(parsedMsg));
        }
    }
}

