/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.listener;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.crafting.CustomRecipe;
import io.github.altkat.BuffedItems.manager.crafting.RecipeIngredient;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import io.github.altkat.BuffedItems.utility.item.ItemBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.BlockState;
import org.bukkit.block.Crafter;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.CrafterCraftEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class CraftingListener
implements Listener {
    private final BuffedItems plugin;
    private final Set<UUID> isCrafting = new HashSet<UUID>();
    private final Set<UUID> isCalculating = new HashSet<UUID>();

    public CraftingListener(BuffedItems plugin) {
        this.plugin = plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(priority=EventPriority.HIGH)
    public void onPrepareCraft(PrepareItemCraftEvent e) {
        HumanEntity humanEntity = e.getView().getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player p = (Player)humanEntity;
        if (this.isCrafting.contains(p.getUniqueId())) {
            return;
        }
        if (this.isCalculating.contains(p.getUniqueId())) {
            return;
        }
        CraftingInventory inv = e.getInventory();
        ItemStack[] matrix = inv.getMatrix();
        boolean isEmpty = true;
        for (ItemStack item : matrix) {
            if (item == null || item.getType() == Material.AIR) continue;
            isEmpty = false;
            break;
        }
        if (isEmpty) {
            return;
        }
        this.isCalculating.add(p.getUniqueId());
        try {
            CustomRecipe match = this.plugin.getCraftingManager().findRecipe(matrix);
            if (match != null) {
                if (!match.isEnabled()) {
                    inv.setResult(null);
                    return;
                }
                if (match.getPermission() != null && !match.getPermission().isEmpty() && !p.hasPermission(match.getPermission())) {
                    inv.setResult(null);
                    return;
                }
                BuffedItem resultItem = this.plugin.getItemManager().getBuffedItem(match.getResultItemId());
                if (resultItem != null) {
                    ItemStack resultStack = new ItemBuilder(resultItem, (Plugin)this.plugin).build();
                    resultStack.setAmount(match.getAmount());
                    inv.setResult(resultStack);
                } else {
                    inv.setResult(null);
                }
            } else {
                for (ItemStack item : matrix) {
                    if (!this.plugin.getItemManager().isBuffedItem(item)) continue;
                    inv.setResult(null);
                    return;
                }
                ItemStack currentResult = inv.getResult();
                if (currentResult != null && this.plugin.getItemManager().isBuffedItem(currentResult)) {
                    inv.setResult(null);
                }
            }
        }
        finally {
            this.isCalculating.remove(p.getUniqueId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent e) {
        if (e.getSlotType() != InventoryType.SlotType.RESULT) {
            return;
        }
        if (!(e.getClickedInventory() instanceof CraftingInventory)) {
            return;
        }
        CraftingInventory inv = (CraftingInventory)e.getClickedInventory();
        ItemStack result = inv.getResult();
        if (result == null || result.getType() == Material.AIR) {
            return;
        }
        if (!this.plugin.getItemManager().isBuffedItem(result)) {
            ItemStack[] matrix;
            for (ItemStack item : matrix = inv.getMatrix()) {
                if (!this.plugin.getItemManager().isBuffedItem(item)) continue;
                e.setCancelled(true);
                return;
            }
            return;
        }
        ItemStack[] matrix = inv.getMatrix();
        CustomRecipe match = this.plugin.getCraftingManager().findRecipe(matrix);
        if (match == null) {
            e.setCancelled(true);
            e.getWhoClicked().closeInventory();
            return;
        }
        Player player = (Player)e.getWhoClicked();
        if (match.getPermission() != null && !match.getPermission().isEmpty() && !player.hasPermission(match.getPermission())) {
            e.setCancelled(true);
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cYou do not have permission to craft this."));
            return;
        }
        e.setCancelled(true);
        this.isCrafting.add(player.getUniqueId());
        try {
            if (e.isShiftClick()) {
                this.handleShiftClick(player, match, matrix, inv);
            } else {
                this.handleNormalClick(player, e, match, matrix, inv);
            }
        }
        finally {
            this.isCrafting.remove(player.getUniqueId());
            player.updateInventory();
        }
    }

    private void handleNormalClick(Player player, InventoryClickEvent e, CustomRecipe match, ItemStack[] matrix, CraftingInventory inv) {
        ItemStack cursor = e.getCursor();
        BuffedItem resultBuffedItem = this.plugin.getItemManager().getBuffedItem(match.getResultItemId());
        if (resultBuffedItem == null) {
            return;
        }
        ItemStack resultStack = new ItemBuilder(resultBuffedItem, (Plugin)this.plugin).build();
        resultStack.setAmount(match.getAmount());
        if (cursor != null && cursor.getType() != Material.AIR) {
            if (!cursor.isSimilar(resultStack)) {
                return;
            }
            if (cursor.getAmount() + resultStack.getAmount() > cursor.getMaxStackSize()) {
                return;
            }
        }
        this.updateMatrix(inv, matrix, match, 1);
        if (cursor == null || cursor.getType() == Material.AIR) {
            player.setItemOnCursor(resultStack);
        } else {
            cursor.setAmount(cursor.getAmount() + resultStack.getAmount());
            player.setItemOnCursor(cursor);
        }
        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.5f, 1.0f);
    }

    private void handleShiftClick(Player player, CustomRecipe match, ItemStack[] matrix, CraftingInventory inv) {
        BuffedItem resultBuffedItem = this.plugin.getItemManager().getBuffedItem(match.getResultItemId());
        if (resultBuffedItem == null) {
            return;
        }
        ItemStack resultTemplate = new ItemBuilder(resultBuffedItem, (Plugin)this.plugin).build();
        resultTemplate.setAmount(match.getAmount());
        int maxCraftsByMaterials = 576;
        for (ItemStack itemInSlot : matrix) {
            RecipeIngredient matchingIngredient;
            if (itemInSlot == null || itemInSlot.getType() == Material.AIR || (matchingIngredient = this.findMatchingIngredient(itemInSlot, match)) == null) continue;
            int required = matchingIngredient.getAmount();
            int available = itemInSlot.getAmount();
            int canCraft = available / required;
            if (canCraft >= maxCraftsByMaterials) continue;
            maxCraftsByMaterials = canCraft;
        }
        if (maxCraftsByMaterials <= 0) {
            return;
        }
        int maxCraftsByInventory = this.getSpaceFor((Inventory)player.getInventory(), resultTemplate) / match.getAmount();
        int actualCrafts = Math.min(maxCraftsByMaterials, maxCraftsByInventory);
        if (actualCrafts <= 0) {
            return;
        }
        this.updateMatrix(inv, matrix, match, actualCrafts);
        ItemStack toGive = resultTemplate.clone();
        toGive.setAmount(actualCrafts * match.getAmount());
        HashMap leftOvers = player.getInventory().addItem(new ItemStack[]{toGive});
        for (ItemStack drop : leftOvers.values()) {
            player.getWorld().dropItemNaturally(player.getLocation(), drop);
        }
        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.5f, 1.0f);
    }

    private void updateMatrix(CraftingInventory inv, ItemStack[] matrix, CustomRecipe match, int multiplier) {
        for (int i = 0; i < matrix.length; ++i) {
            RecipeIngredient matchingIngredient;
            ItemStack itemInSlot = matrix[i];
            if (itemInSlot == null || itemInSlot.getType() == Material.AIR || (matchingIngredient = this.findMatchingIngredient(itemInSlot, match)) == null) continue;
            int requiredTotal = matchingIngredient.getAmount() * multiplier;
            if (itemInSlot.getAmount() > requiredTotal) {
                itemInSlot.setAmount(itemInSlot.getAmount() - requiredTotal);
            } else if (this.isBucket(itemInSlot.getType())) {
                itemInSlot.setType(Material.BUCKET);
                itemInSlot.setAmount(1);
            } else {
                itemInSlot.setAmount(0);
            }
            inv.setItem(i + 1, itemInSlot);
        }
    }

    private RecipeIngredient findMatchingIngredient(ItemStack item, CustomRecipe recipe) {
        for (RecipeIngredient ing : recipe.getIngredients().values()) {
            if (!this.plugin.getCraftingManager().getItemMatcher().matches(item, ing)) continue;
            return ing;
        }
        return null;
    }

    private int getSpaceFor(Inventory inventory, ItemStack item) {
        int space = 0;
        int maxStack = item.getMaxStackSize();
        for (ItemStack content : inventory.getStorageContents()) {
            if (content == null || content.getType() == Material.AIR) {
                space += maxStack;
                continue;
            }
            if (!content.isSimilar(item)) continue;
            space += Math.max(0, maxStack - content.getAmount());
        }
        return space;
    }

    private boolean isBucket(Material material) {
        return material == Material.WATER_BUCKET || material == Material.LAVA_BUCKET || material == Material.MILK_BUCKET || material == Material.POWDER_SNOW_BUCKET || material == Material.COD_BUCKET || material == Material.SALMON_BUCKET || material == Material.AXOLOTL_BUCKET || material == Material.TADPOLE_BUCKET || material == Material.TROPICAL_FISH_BUCKET || material == Material.PUFFERFISH_BUCKET;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onCrafterCraft(CrafterCraftEvent e) {
        ItemStack[] matrix;
        BlockState blockState = e.getBlock().getState();
        if (!(blockState instanceof Crafter)) {
            return;
        }
        Crafter crafter = (Crafter)blockState;
        for (ItemStack item : matrix = crafter.getInventory().getContents()) {
            if (item == null || item.getType() == Material.AIR || !this.plugin.getItemManager().isBuffedItem(item)) continue;
            e.setCancelled(true);
            return;
        }
        CustomRecipe match = this.plugin.getCraftingManager().findRecipe(matrix);
        if (match != null) {
            e.setCancelled(true);
        }
    }
}

