/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.utility;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.menu.active.ActiveItemSoundsMenu;
import io.github.altkat.BuffedItems.menu.base.Menu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class SoundSettingsMenu
extends Menu {
    private final BuffedItems plugin;
    private final String itemId;
    private final String soundType;

    public SoundSettingsMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin, String soundType) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.itemId = playerMenuUtility.getItemToEditId();
        this.soundType = soundType;
    }

    @Override
    public String getMenuName() {
        String displayType = switch (this.soundType) {
            case "success" -> "Success";
            case "cooldown" -> "Cooldown";
            case "cost-fail" -> "Cost Fail";
            case "depletion" -> "Depletion";
            case "depleted-try" -> "Depleted Try";
            default -> this.soundType;
        };
        return "Set " + displayType + " Sound";
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        String idLine;
        Player p = (Player)e.getWhoClicked();
        if (e.getCurrentItem() == null) {
            return;
        }
        if (e.getCurrentItem().getType() == Material.BARRIER) {
            new ActiveItemSoundsMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
        if (e.getCurrentItem().getType() == Material.JUKEBOX) {
            this.playerMenuUtility.setWaitingForChatInput(true);
            this.playerMenuUtility.setChatInputPath("active.sounds." + this.soundType);
            p.closeInventory();
            p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aEnter the sound name in chat."));
            p.sendMessage(ConfigManager.fromSection("\u00a77Format: SOUND_NAME;VOLUME;PITCH"));
            p.sendMessage(ConfigManager.fromSection("\u00a77Examples:"));
            p.sendMessage(ConfigManager.fromSection("\u00a77- ENTITY_PLAYER_LEVELUP;1.0;2.0"));
            p.sendMessage(ConfigManager.fromSection("\u00a77- custom:my_sword_sound;1;1 (Resource Pack)"));
            return;
        }
        if (e.getCurrentItem().getType() == Material.REDSTONE_BLOCK) {
            ConfigManager.setItemValue(this.itemId, "sounds." + this.soundType, "NONE");
            p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            new ActiveItemSoundsMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
        ItemStack clicked = e.getCurrentItem();
        if (clicked.hasItemMeta() && clicked.getItemMeta().hasLore() && (idLine = ConfigManager.toPlainText((Component)clicked.getItemMeta().lore().get(0))).startsWith("ID: ")) {
            Object soundData = idLine.substring(4) + ";1.0;1.0";
            if (((String)soundData).contains("NOTE_BLOCK_PLING")) {
                soundData = ((String)soundData).replace("1.0", "2.0");
            }
            if (e.isLeftClick()) {
                ConfigManager.setItemValue(this.itemId, "sounds." + this.soundType, soundData);
                p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                new ActiveItemSoundsMenu(this.playerMenuUtility, this.plugin).open();
            } else if (e.isRightClick()) {
                try {
                    float pitch = ((String)soundData).contains("2.0") ? 2.0f : 1.0f;
                    p.playSound(p.getLocation(), Sound.valueOf((String)((String)soundData).split(";")[0]), 1.0f, pitch);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void setMenuItems() {
        this.setFillerGlass();
        this.inventory.setItem(4, this.makeItem(Material.BOOK, "\u00a76Sound Library", "\u00a77Select a preset sound below", "\u00a77or use Jukebox for custom input.", "", "\u00a7aLeft-Click to Set", "\u00a7eRight-Click to Preview"));
        this.inventory.setItem(49, this.makeItem(Material.BARRIER, "\u00a7cBack", new String[0]));
        this.inventory.setItem(45, this.makeItem(Material.REDSTONE_BLOCK, "\u00a7cDisable Sound", "\u00a77Set to NONE."));
        this.inventory.setItem(53, this.makeItem(Material.JUKEBOX, "\u00a7bCustom Sound (Chat)", "\u00a77Type sound ID manually."));
        int i = 10;
        this.inventory.setItem(i++, this.makeSoundItem(Material.EXPERIENCE_BOTTLE, "Level Up", "ENTITY_PLAYER_LEVELUP", "Classic RPG level up sound."));
        this.inventory.setItem(i++, this.makeSoundItem(Material.GOLD_NUGGET, "Exp Orb", "ENTITY_EXPERIENCE_ORB_PICKUP", "Subtle 'ding' sound."));
        this.inventory.setItem(i++, this.makeSoundItem(Material.NOTE_BLOCK, "Pling (High)", "BLOCK_NOTE_BLOCK_PLING", "High pitched note block."));
        this.inventory.setItem(i++, this.makeSoundItem(Material.EMERALD, "Success", "ENTITY_VILLAGER_YES", "Villager agreement sound."));
        this.inventory.setItem(i++, this.makeSoundItem(Material.BEACON, "Beacon Power", "BLOCK_BEACON_POWER_SELECT", "Magical power up."));
        this.inventory.setItem(i++, this.makeSoundItem(Material.TOTEM_OF_UNDYING, "Totem Use", "ITEM_TOTEM_USE", "Divine activation sound."));
        this.inventory.setItem(i++, this.makeSoundItem(Material.ENCHANTING_TABLE, "Enchant", "BLOCK_ENCHANTMENT_TABLE_USE", "Magical hum."));
        i = 19;
        this.inventory.setItem(i++, this.makeSoundItem(Material.REDSTONE, "Villager No", "ENTITY_VILLAGER_NO", "Classic error sound."));
        this.inventory.setItem(i++, this.makeSoundItem(Material.NOTE_BLOCK, "Bass (Fail)", "BLOCK_NOTE_BLOCK_BASS", "Low pitch error sound."));
        this.inventory.setItem(i++, this.makeSoundItem(Material.IRON_TRAPDOOR, "Click/Trapdoor", "BLOCK_IRON_TRAPDOOR_OPEN", "Mechanical click."));
        this.inventory.setItem(i++, this.makeSoundItem(Material.FLINT_AND_STEEL, "Extinguish", "ENTITY_GENERIC_EXTINGUISH_FIRE", "Fizzle sound."));
        this.inventory.setItem(i++, this.makeSoundItem(Material.DISPENSER, "Dispenser Fail", "BLOCK_DISPENSER_FAIL", "Empty click sound."));
        this.inventory.setItem(i++, this.makeSoundItem(Material.LAVA_BUCKET, "Lava Pop", "BLOCK_LAVA_POP", "Bubble pop sound."));
        this.inventory.setItem(i++, this.makeSoundItem(Material.CHAIN, "Chain Break", "BLOCK_CHAIN_BREAK", "Metallic snap."));
        i = 28;
        this.inventory.setItem(i++, this.makeSoundItem(Material.FLINT, "Item Break", "ENTITY_ITEM_BREAK", "Crunchy snapping sound."));
        this.inventory.setItem(i++, this.makeSoundItem(Material.ANVIL, "Anvil Land", "BLOCK_ANVIL_LAND", "Heavy metallic clang."));
        this.inventory.setItem(i++, this.makeSoundItem(Material.TNT, "Explosion", "ENTITY_GENERIC_EXPLODE", "Boom!"));
        this.inventory.setItem(i++, this.makeSoundItem(Material.IRON_DOOR, "Zombie Door", "ENTITY_ZOMBIE_ATTACK_IRON_DOOR", "Loud banging sound."));
        this.inventory.setItem(i++, this.makeSoundItem(Material.GHAST_TEAR, "Ghast Shoot", "ENTITY_GHAST_SHOOT", "Retro arcade shot."));
        this.inventory.setItem(i++, this.makeSoundItem(Material.BLAZE_ROD, "Blaze Shoot", "ENTITY_BLAZE_SHOOT", "Fire shot sound."));
        this.inventory.setItem(i++, this.makeSoundItem(Material.DRAGON_HEAD, "Dragon Growl", "ENTITY_ENDER_DRAGON_GROWL", "Epic boss roar."));
        i = 37;
        this.inventory.setItem(i++, this.makeSoundItem(Material.WITHER_SKELETON_SKULL, "Wither Spawn", "ENTITY_WITHER_SPAWN", "Dark summon sound."));
        this.inventory.setItem(i++, this.makeSoundItem(Material.BELL, "Bell Ring", "BLOCK_BELL_USE", "Clear ding sound."));
        this.inventory.setItem(i++, this.makeSoundItem(Material.CHEST, "Chest Open", "BLOCK_CHEST_OPEN", "Wooden creak."));
        this.inventory.setItem(i++, this.makeSoundItem(Material.ENDER_CHEST, "Ender Chest", "BLOCK_ENDER_CHEST_OPEN", "Mystical open sound."));
        this.inventory.setItem(i++, this.makeSoundItem(Material.SHIELD, "Shield Block", "ITEM_SHIELD_BLOCK", "Thud sound."));
        this.inventory.setItem(i++, this.makeSoundItem(Material.TRIDENT, "Trident Throw", "ITEM_TRIDENT_THROW", "Whoosh sound."));
        this.inventory.setItem(i++, this.makeSoundItem(Material.CROSSBOW, "Crossbow Shoot", "ITEM_CROSSBOW_SHOOT", "Sharp release sound."));
    }

    private ItemStack makeSoundItem(Material mat, String displayName, String soundName, String desc) {
        return this.makeItem(mat, "\u00a7e" + displayName, "\u00a77ID: " + soundName, "\u00a77" + desc, "", "\u00a7aLeft-Click to Set", "\u00a7bRight-Click to Preview");
    }
}

