/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.utility;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.config.RecipesConfig;
import io.github.altkat.BuffedItems.manager.config.SetsConfig;
import io.github.altkat.BuffedItems.manager.config.UpgradesConfig;
import io.github.altkat.BuffedItems.menu.base.Menu;
import io.github.altkat.BuffedItems.menu.utility.MainMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GeneralSettingsMenu
extends Menu {
    private final BuffedItems plugin;

    public GeneralSettingsMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
    }

    @Override
    public String getMenuName() {
        return "General Settings";
    }

    @Override
    public int getSlots() {
        return 27;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        if (e.getCurrentItem() == null) {
            return;
        }
        switch (e.getCurrentItem().getType()) {
            case OBSERVER: {
                int currentLevel = ConfigManager.getDebugLevel();
                int nextLevel = currentLevel >= 4 ? 0 : currentLevel + 1;
                ConfigManager.setDebugLevel(nextLevel);
                this.playClick(p);
                this.open();
                break;
            }
            case POTION: {
                boolean currentShow = ConfigManager.shouldShowPotionIcons();
                ConfigManager.setShowPotionIcons(!currentShow);
                this.playClick(p);
                this.open();
                break;
            }
            case GOLDEN_CHESTPLATE: {
                this.toggleSystem("sets", SetsConfig.get(), silent -> this.plugin.getSetManager().loadSets((boolean)silent));
                this.playClick(p);
                this.open();
                break;
            }
            case SMITHING_TABLE: {
                this.toggleSystem("upgrades", UpgradesConfig.get(), silent -> this.plugin.getUpgradeManager().loadRecipes((boolean)silent));
                this.playClick(p);
                this.open();
                break;
            }
            case CRAFTING_TABLE: {
                this.toggleSystem("recipes", RecipesConfig.get(), silent -> this.plugin.getCraftingManager().loadRecipes((boolean)silent));
                this.playClick(p);
                this.open();
                break;
            }
            case BARRIER: {
                new MainMenu(this.playerMenuUtility, this.plugin).open();
            }
        }
    }

    private void toggleSystem(String name, FileConfiguration config, Consumer<Boolean> loader) {
        boolean current = config.getBoolean("settings.enabled", true);
        config.set("settings.enabled", (Object)(!current ? 1 : 0));
        switch (name) {
            case "sets": {
                SetsConfig.save();
                break;
            }
            case "upgrades": {
                UpgradesConfig.save();
                break;
            }
            case "recipes": {
                RecipesConfig.save();
            }
        }
        loader.accept(true);
    }

    private void playClick(Player p) {
        p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
    }

    @Override
    public void setMenuItems() {
        this.setFillerGlass();
        int currentDebug = ConfigManager.getDebugLevel();
        String debugStatusColor = currentDebug == 0 ? "\u00a7c" : (currentDebug < 3 ? "\u00a7e" : "\u00a7a");
        String debugName = this.getDebugLevelName(currentDebug);
        ArrayList<Object> debugLore = new ArrayList<Object>();
        debugLore.add("\u00a77Controls the verbosity of console logs.");
        debugLore.add("");
        debugLore.add("\u00a77Current Level: " + debugStatusColor + currentDebug + " (" + debugName + ")");
        debugLore.add("");
        debugLore.add("\u00a7fLevels:");
        debugLore.add((currentDebug == 0 ? "\u00a7a" : "\u00a77") + " 0: OFF \u00a78(Errors only)");
        debugLore.add((currentDebug == 1 ? "\u00a7a" : "\u00a77") + " 1: INFO \u00a78(Startup/Shutdown/Reload)");
        debugLore.add((currentDebug == 2 ? "\u00a7a" : "\u00a77") + " 2: TASK \u00a78(Periodic tasks)");
        debugLore.add((currentDebug == 3 ? "\u00a7a" : "\u00a77") + " 3: DETAILED \u00a78(Per-player operations)");
        debugLore.add((currentDebug == 4 ? "\u00a7a" : "\u00a77") + " 4: VERBOSE \u00a78(Spammy - Dev only)");
        debugLore.add("");
        debugLore.add("\u00a7eClick to cycle levels.");
        this.inventory.setItem(10, this.makeItem(Material.OBSERVER, "\u00a76Debug Level", debugLore.toArray(new String[0])));
        boolean showIcons = ConfigManager.shouldShowPotionIcons();
        String iconsStatus = showIcons ? "\u00a7aVisible" : "\u00a7cHidden";
        ArrayList<Object> iconsLore = new ArrayList<Object>();
        iconsLore.add("\u00a77Determines if custom potion effects");
        iconsLore.add("\u00a77should appear in the top-right corner");
        iconsLore.add("\u00a77of the player's screen.");
        iconsLore.add("");
        iconsLore.add("\u00a77Current: " + iconsStatus);
        iconsLore.add("");
        iconsLore.add("\u00a7eClick to toggle.");
        ItemStack potionItem = this.makeItem(Material.POTION, "\u00a7bShow Potion Icons", iconsLore.toArray(new String[0]));
        ItemMeta meta = potionItem.getItemMeta();
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP, ItemFlag.HIDE_ATTRIBUTES});
        potionItem.setItemMeta(meta);
        this.inventory.setItem(11, potionItem);
        this.inventory.setItem(13, this.createSystemToggle(Material.GOLDEN_CHESTPLATE, "Item Sets System", SetsConfig.get().getBoolean("settings.enabled", true), "Enable/Disable set bonuses."));
        this.inventory.setItem(14, this.createSystemToggle(Material.SMITHING_TABLE, "Upgrade System", UpgradesConfig.get().getBoolean("settings.enabled", true), "Enable/Disable item upgrades."));
        this.inventory.setItem(15, this.createSystemToggle(Material.CRAFTING_TABLE, "Crafting System", RecipesConfig.get().getBoolean("settings.enabled", true), "Enable/Disable custom recipes."));
        this.addBackButton(new MainMenu(this.playerMenuUtility, this.plugin));
    }

    private ItemStack createSystemToggle(Material mat, String name, boolean enabled, String desc) {
        String status = enabled ? "\u00a7aEnabled" : "\u00a7cDisabled";
        return this.makeItem(mat, "\u00a7e" + name, "\u00a77" + desc, "", "\u00a77Status: " + status, "", "\u00a7eClick to Toggle");
    }

    private String getDebugLevelName(int level) {
        switch (level) {
            case 0: {
                return "OFF";
            }
            case 1: {
                return "INFO";
            }
            case 2: {
                return "TASK";
            }
            case 3: {
                return "DETAILED";
            }
            case 4: {
                return "VERBOSE";
            }
        }
        return "UNKNOWN";
    }
}

