/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.set;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.config.SetsConfig;
import io.github.altkat.BuffedItems.menu.base.PaginatedMenu;
import io.github.altkat.BuffedItems.menu.selector.BuffedItemSelectorMenu;
import io.github.altkat.BuffedItems.menu.set.SetEditorMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import io.github.altkat.BuffedItems.utility.item.ItemBuilder;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class SetItemsMenu
extends PaginatedMenu {
    private final BuffedItems plugin;
    private final String setId;

    public SetItemsMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.setId = playerMenuUtility.getItemToEditId();
        this.maxItemsPerPage = 36;
    }

    @Override
    public String getMenuName() {
        return "Set Items: " + this.setId;
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        if (e.getCurrentItem() == null) {
            return;
        }
        List items = SetsConfig.get().getStringList("sets." + this.setId + ".items");
        if (this.handlePageChange(e, items.size())) {
            return;
        }
        if (e.getSlot() == 53) {
            new SetEditorMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
        if (e.getSlot() == 49) {
            new BuffedItemSelectorMenu(this.playerMenuUtility, this.plugin, BuffedItemSelectorMenu.SelectionContext.SET_MEMBER).open();
            return;
        }
        if (e.getSlot() >= 9 && e.getSlot() < 45) {
            int index = this.maxItemsPerPage * this.page + (e.getSlot() - 9);
            if (index >= items.size()) {
                return;
            }
            if (e.getClick() == ClickType.RIGHT) {
                String removedId = (String)items.remove(index);
                SetsConfig.get().set("sets." + this.setId + ".items", (Object)items);
                SetsConfig.save();
                this.plugin.getSetManager().loadSets(true);
                e.getWhoClicked().sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cRemoved " + removedId + " from set."));
                this.open();
            }
        }
    }

    @Override
    public void setMenuItems() {
        int index;
        int i;
        ItemStack filler = this.makeItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        for (i = 0; i < 9; ++i) {
            this.inventory.setItem(i, filler);
        }
        for (i = 45; i < 54; ++i) {
            this.inventory.setItem(i, filler);
        }
        this.addMenuControls();
        this.inventory.setItem(53, this.makeItem(Material.BARRIER, "\u00a7cBack", new String[0]));
        this.inventory.setItem(49, this.makeItem(Material.ANVIL, "\u00a7aAdd Item", "\u00a77Add a BuffedItem to this set."));
        List items = SetsConfig.get().getStringList("sets." + this.setId + ".items");
        for (int i2 = 0; i2 < this.maxItemsPerPage && (index = this.maxItemsPerPage * this.page + i2) < items.size(); ++i2) {
            String itemId = (String)items.get(index);
            BuffedItem bItem = this.plugin.getItemManager().getBuffedItem(itemId);
            ItemStack icon = bItem != null ? new ItemBuilder(bItem, (Plugin)this.plugin).build() : this.makeItem(Material.BEDROCK, "\u00a7c" + itemId, "\u00a77Item not found!");
            ItemMeta meta = icon.getItemMeta();
            List lore = meta.hasLore() ? meta.lore() : new ArrayList();
            lore.add(Component.empty());
            lore.add(ConfigManager.fromSection("\u00a77ID: \u00a7f" + itemId));
            lore.add(Component.empty());
            lore.add(ConfigManager.fromSection("\u00a7cRight-Click to Remove"));
            meta.lore(lore);
            icon.setItemMeta(meta);
            this.inventory.setItem(9 + i2, icon);
        }
    }
}

