/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.set;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.menu.base.PaginatedMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import io.github.altkat.BuffedItems.utility.attribute.ParsedAttribute;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import io.github.altkat.BuffedItems.utility.item.BuffedItemEffect;
import io.github.altkat.BuffedItems.utility.item.ItemBuilder;
import io.github.altkat.BuffedItems.utility.set.BuffedSet;
import io.github.altkat.BuffedItems.utility.set.SetBonus;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;

public class PublicSetListMenu
extends PaginatedMenu {
    private final BuffedItems plugin;

    public PublicSetListMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.maxItemsPerPage = 36;
    }

    @Override
    public String getMenuName() {
        return "Item Sets (Page " + (this.page + 1) + ")";
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        List<BuffedSet> sets = this.getSortedSets();
        if (this.handlePageChange(e, sets.size())) {
            return;
        }
        if (e.getSlot() == 49) {
            e.getWhoClicked().closeInventory();
        }
    }

    @Override
    public void setMenuItems() {
        int index;
        int i;
        ItemStack filler = this.makeItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        for (i = 0; i < 9; ++i) {
            this.inventory.setItem(i, filler);
        }
        for (i = 45; i < 54; ++i) {
            this.inventory.setItem(i, filler);
        }
        this.addMenuControls();
        this.inventory.setItem(49, this.makeItem(Material.BARRIER, "\u00a7cClose Menu", new String[0]));
        List<BuffedSet> sets = this.getSortedSets();
        for (int i2 = 0; i2 < this.maxItemsPerPage && (index = this.maxItemsPerPage * this.page + i2) < sets.size(); ++i2) {
            BuffedSet set = sets.get(index);
            this.inventory.setItem(9 + i2, this.createSetIcon(set));
        }
    }

    private ItemStack createSetIcon(BuffedSet set) {
        ItemStack iconStack;
        if (!set.getItemIds().isEmpty()) {
            String firstId = set.getItemIds().get(0);
            BuffedItem bItem = this.plugin.getItemManager().getBuffedItem(firstId);
            iconStack = bItem != null ? new ItemBuilder(bItem, (Plugin)this.plugin).build() : new ItemStack(Material.ARMOR_STAND);
        } else {
            iconStack = new ItemStack(Material.ARMOR_STAND);
        }
        ItemMeta meta = iconStack.getItemMeta();
        if (meta != null) {
            meta.displayName(ConfigManager.fromSection(ConfigManager.toSection(ConfigManager.fromLegacy(set.getDisplayName()))));
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add(Component.empty());
            lore.add(ConfigManager.fromSection("\u00a77Set Pieces (" + set.getItemIds().size() + "):"));
            for (String itemId : set.getItemIds()) {
                BuffedItem item = this.plugin.getItemManager().getBuffedItem(itemId);
                String itemName = item != null ? ConfigManager.toSection(ConfigManager.fromLegacy(item.getDisplayName())) : itemId;
                lore.add(ConfigManager.fromSection(" \u00a78\u2022 \u00a7f" + itemName));
            }
            lore.add(Component.empty());
            lore.add(ConfigManager.fromSection("\u00a76Set Bonuses:"));
            TreeMap<Integer, SetBonus> sortedBonuses = new TreeMap<Integer, SetBonus>(set.getBonuses());
            if (sortedBonuses.isEmpty()) {
                lore.add(ConfigManager.fromSection(" \u00a77None"));
            } else {
                for (Map.Entry entry : sortedBonuses.entrySet()) {
                    int count = (Integer)entry.getKey();
                    SetBonus bonus = (SetBonus)entry.getValue();
                    BuffedItemEffect effects = bonus.getEffects();
                    lore.add(ConfigManager.fromSection(" \u00a7e[" + count + "] Pieces:"));
                    boolean hasEffect = false;
                    if (effects.getPotionEffects() != null) {
                        for (Map.Entry entry2 : effects.getPotionEffects().entrySet()) {
                            String pName = this.formatEnumName(((PotionEffectType)entry2.getKey()).getName());
                            lore.add(ConfigManager.fromSection("   \u00a77\u2022 \u00a7b" + pName + " " + String.valueOf(entry2.getValue())));
                            hasEffect = true;
                        }
                    }
                    if (effects.getParsedAttributes() != null) {
                        for (ParsedAttribute parsedAttribute : effects.getParsedAttributes()) {
                            String attrName = this.formatEnumName(parsedAttribute.getAttribute().name().replace("GENERIC_", ""));
                            String op = parsedAttribute.getOperation() == AttributeModifier.Operation.ADD_NUMBER ? "" : "%";
                            String amountStr = (parsedAttribute.getAmount() > 0.0 ? "+" : "") + parsedAttribute.getAmount();
                            if (parsedAttribute.getOperation() != AttributeModifier.Operation.ADD_NUMBER) {
                                amountStr = (parsedAttribute.getAmount() > 0.0 ? "+" : "") + (int)(parsedAttribute.getAmount() * 100.0);
                            }
                            lore.add(ConfigManager.fromSection("   \u00a77\u2022 \u00a7a" + attrName + " " + amountStr + op));
                            hasEffect = true;
                        }
                    }
                    if (hasEffect) continue;
                    lore.add(ConfigManager.fromSection("   \u00a77\u2022 No Effects"));
                }
            }
            meta.lore(lore);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
            iconStack.setItemMeta(meta);
        }
        iconStack.setAmount(1);
        return iconStack;
    }

    private List<BuffedSet> getSortedSets() {
        ArrayList<BuffedSet> list = new ArrayList<BuffedSet>(this.plugin.getSetManager().getSets().values());
        list.sort(Comparator.comparing(BuffedSet::getId));
        return list;
    }

    private String formatEnumName(String name) {
        String[] words = name.toLowerCase().split("_");
        StringBuilder sb = new StringBuilder();
        for (String word : words) {
            sb.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return sb.toString().trim();
    }
}

