/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.selector;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.menu.base.PaginatedMenu;
import io.github.altkat.BuffedItems.menu.crafting.IngredientSettingsMenu;
import io.github.altkat.BuffedItems.menu.editor.ItemEditorMenu;
import io.github.altkat.BuffedItems.menu.selector.TypeSelectorMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class MaterialSelectorMenu
extends PaginatedMenu {
    private final BuffedItems plugin;
    private final List<Material> materials;

    public MaterialSelectorMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.materials = Arrays.stream(Material.values()).filter(Material::isItem).collect(Collectors.toList());
        this.maxItemsPerPage = 45;
    }

    @Override
    public String getMenuName() {
        return "Select a Material (Page " + (this.page + 1) + ")";
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        if (e.getCurrentItem() == null) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        int clickedSlot = e.getSlot();
        Material clickedType = e.getCurrentItem().getType();
        if (this.handlePageChange(e, this.materials.size())) {
            return;
        }
        if (clickedType == Material.BARRIER && clickedSlot == 49) {
            this.handleBack();
            return;
        }
        if (clickedType == Material.ANVIL && clickedSlot == 48) {
            this.handleManualInput(p);
            return;
        }
        if (clickedSlot < this.maxItemsPerPage) {
            this.handleMaterialSelection(p, clickedType);
        }
    }

    private void handleMaterialSelection(Player p, Material material) {
        PlayerMenuUtility.MaterialSelectionContext context = this.playerMenuUtility.getMaterialContext();
        if (context == PlayerMenuUtility.MaterialSelectionContext.ICON) {
            String itemId = this.playerMenuUtility.getItemToEditId();
            ConfigManager.setItemValue(itemId, "material", material.name());
            p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aMaterial has been updated to " + material.name()));
            new ItemEditorMenu(this.playerMenuUtility, this.plugin).open();
        } else if (context == PlayerMenuUtility.MaterialSelectionContext.COST) {
            this.playerMenuUtility.setTempMaterial(material);
            this.playerMenuUtility.setWaitingForChatInput(true);
            this.playerMenuUtility.setChatInputPath("active.costs.add.ITEM_QUANTITY");
            p.closeInventory();
            p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aSelected: \u00a7e" + material.name()));
            p.sendMessage(ConfigManager.fromSection("\u00a7aPlease enter the Amount in chat."));
            p.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
        } else if (context == PlayerMenuUtility.MaterialSelectionContext.INGREDIENT) {
            this.playerMenuUtility.setTempMaterial(material);
            this.playerMenuUtility.setWaitingForChatInput(true);
            this.playerMenuUtility.setChatInputPath("upgrade.ingredients.add.ITEM_QUANTITY");
            p.closeInventory();
            p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aSelected: \u00a7e" + material.name()));
            p.sendMessage(ConfigManager.fromSection("\u00a7aPlease enter the Amount in chat."));
            p.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
        } else if (context == PlayerMenuUtility.MaterialSelectionContext.CRAFTING_INGREDIENT) {
            this.playerMenuUtility.setTempMaterial(material);
            this.playerMenuUtility.setUnsavedChanges(true);
            new IngredientSettingsMenu(this.playerMenuUtility, this.plugin, true).open();
        }
    }

    private void handleManualInput(Player p) {
        this.playerMenuUtility.setWaitingForChatInput(true);
        p.closeInventory();
        PlayerMenuUtility.MaterialSelectionContext context = this.playerMenuUtility.getMaterialContext();
        if (context == PlayerMenuUtility.MaterialSelectionContext.ICON) {
            this.playerMenuUtility.setChatInputPath("material.manual");
            p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aPlease type the Material name in chat (e.g., 'STONE')."));
        } else if (context == PlayerMenuUtility.MaterialSelectionContext.COST) {
            this.playerMenuUtility.setChatInputPath("active.costs.add.ITEM");
            p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7eFormat: AMOUNT;MATERIAL (e.g. 10;DIAMOND)"));
        } else if (context == PlayerMenuUtility.MaterialSelectionContext.INGREDIENT) {
            this.playerMenuUtility.setChatInputPath("upgrade.ingredients.add.ITEM");
            p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7eFormat: AMOUNT;MATERIAL (e.g. 10;DIAMOND)"));
        } else if (context == PlayerMenuUtility.MaterialSelectionContext.CRAFTING_INGREDIENT) {
            this.playerMenuUtility.setChatInputPath("recipe_ingredient_material_manual");
            this.playerMenuUtility.setUnsavedChanges(true);
            p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aPlease type the Material name in chat (e.g., 'IRON_INGOT')."));
        }
        p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a77(Type 'cancel' to exit)"));
    }

    private void handleBack() {
        PlayerMenuUtility.MaterialSelectionContext context = this.playerMenuUtility.getMaterialContext();
        if (context == PlayerMenuUtility.MaterialSelectionContext.COST) {
            new TypeSelectorMenu(this.playerMenuUtility, this.plugin, context).open();
        } else if (context == PlayerMenuUtility.MaterialSelectionContext.INGREDIENT) {
            new TypeSelectorMenu(this.playerMenuUtility, this.plugin, context).open();
        } else if (context == PlayerMenuUtility.MaterialSelectionContext.CRAFTING_INGREDIENT) {
            new IngredientSettingsMenu(this.playerMenuUtility, this.plugin, false).open();
        } else {
            new ItemEditorMenu(this.playerMenuUtility, this.plugin).open();
        }
        if (context != PlayerMenuUtility.MaterialSelectionContext.ICON) {
            this.playerMenuUtility.setMaterialContext(PlayerMenuUtility.MaterialSelectionContext.ICON);
        }
    }

    @Override
    public void setMenuItems() {
        this.inventory.setItem(45, this.makeItem(Material.ARROW, "\u00a7aPrevious Page", new String[0]));
        this.inventory.setItem(53, this.makeItem(Material.ARROW, "\u00a7aNext Page", new String[0]));
        this.inventory.setItem(49, this.makeItem(Material.BARRIER, "\u00a7cBack to Editor", new String[0]));
        this.inventory.setItem(48, this.makeItem(Material.ANVIL, "\u00a7bEnter Manually", "\u00a77Click to type the material name in chat."));
        for (int i = 0; i < this.maxItemsPerPage; ++i) {
            this.index = this.maxItemsPerPage * this.page + i;
            if (this.index >= this.materials.size()) break;
            Material currentMaterial = this.materials.get(this.index);
            ItemStack itemStack = new ItemStack(currentMaterial);
            this.inventory.setItem(i, itemStack);
        }
        this.setFillerGlass();
    }
}

