/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.selector;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.menu.active.ActiveItemVisualsMenu;
import io.github.altkat.BuffedItems.menu.base.Menu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import org.bukkit.Material;
import org.bukkit.boss.BarStyle;
import org.bukkit.event.inventory.InventoryClickEvent;

public class BossBarStyleMenu
extends Menu {
    private final BuffedItems plugin;
    private final String itemId;

    public BossBarStyleMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.itemId = playerMenuUtility.getItemToEditId();
    }

    @Override
    public String getMenuName() {
        return "Select BossBar Style";
    }

    @Override
    public int getSlots() {
        return 27;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        if (e.getCurrentItem() == null) {
            return;
        }
        if (e.getCurrentItem().getType() == Material.BLACK_STAINED_GLASS_PANE) {
            return;
        }
        if (e.getCurrentItem().getType() == Material.BARRIER) {
            new ActiveItemVisualsMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
        if (e.getSlot() < 9) {
            String styleName = e.getCurrentItem().getItemMeta().getDisplayName().substring(2);
            try {
                BarStyle style = BarStyle.valueOf((String)styleName);
                ConfigManager.setItemValue(this.itemId, "visuals.boss-bar-style", style.name());
                new ActiveItemVisualsMenu(this.playerMenuUtility, this.plugin).open();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setMenuItems() {
        this.setFillerGlass();
        this.inventory.setItem(0, this.makeItem(Material.STONE_BRICKS, "\u00a7bSOLID", "\u00a77Full continuous bar."));
        this.inventory.setItem(1, this.makeItem(Material.CRACKED_STONE_BRICKS, "\u00a7bSEGMENTED_6", "\u00a77Divided into 6 parts."));
        this.inventory.setItem(2, this.makeItem(Material.MOSSY_STONE_BRICKS, "\u00a7bSEGMENTED_10", "\u00a77Divided into 10 parts."));
        this.inventory.setItem(3, this.makeItem(Material.BRICKS, "\u00a7bSEGMENTED_12", "\u00a77Divided into 12 parts."));
        this.inventory.setItem(4, this.makeItem(Material.NETHER_BRICKS, "\u00a7bSEGMENTED_20", "\u00a77Divided into 20 parts."));
        this.inventory.setItem(22, this.makeItem(Material.BARRIER, "\u00a7cCancel", new String[0]));
    }
}

