/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.editor;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.menu.base.PaginatedMenu;
import io.github.altkat.BuffedItems.menu.editor.ItemEditorMenu;
import io.github.altkat.BuffedItems.menu.utility.ItemListMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class LoreEditorMenu
extends PaginatedMenu {
    private final BuffedItems plugin;
    private final int MAX_TOTAL_LORE_LINES = 100;

    public LoreEditorMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.maxItemsPerPage = 36;
    }

    @Override
    public String getMenuName() {
        return "Editing Lore (Page " + (this.page + 1) + ")";
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        BuffedItem item = this.plugin.getItemManager().getBuffedItem(this.playerMenuUtility.getItemToEditId());
        if (item == null) {
            new ItemListMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
        ArrayList<String> lore = new ArrayList<String>(item.getLore());
        if (this.handlePageChange(e, lore.size())) {
            return;
        }
        if (e.getCurrentItem() == null) {
            return;
        }
        if (e.getSlot() == 53) {
            new ItemEditorMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
        if (e.getSlot() == 49) {
            if (lore.size() >= 100) {
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: You cannot add more than 100 lines of lore."));
                p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                return;
            }
            this.playerMenuUtility.setWaitingForChatInput(true);
            this.playerMenuUtility.setChatInputPath("lore.add");
            p.closeInventory();
            p.sendMessage(ConfigManager.fromLegacyWithPrefix("\u00a7aPlease type the new lore line in chat. Use '&' for color codes."));
            p.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
            return;
        }
        if (e.getSlot() == 51) {
            if (lore.size() >= 100) {
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: You cannot add more than 100 lines of lore."));
                p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                return;
            }
            lore.add("");
            ConfigManager.setItemValue(item.getId(), "lore", lore);
            this.open();
            return;
        }
        if (e.getSlot() >= 9 && e.getSlot() < 45) {
            int slotIndex = e.getSlot() - 9;
            int loreIndex = this.maxItemsPerPage * this.page + slotIndex;
            if (loreIndex >= lore.size()) {
                return;
            }
            if (e.isLeftClick()) {
                this.playerMenuUtility.setWaitingForChatInput(true);
                this.playerMenuUtility.setChatInputPath("lore." + loreIndex);
                p.closeInventory();
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aPlease type the edited lore line in chat."));
                p.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
            } else if (e.isRightClick()) {
                lore.remove(loreIndex);
                ConfigManager.setItemValue(item.getId(), "lore", lore);
                this.open();
            }
        }
    }

    @Override
    public void setMenuItems() {
        int i;
        ItemStack filler = this.makeItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        for (i = 0; i < 9; ++i) {
            this.inventory.setItem(i, filler);
        }
        for (i = 45; i < 54; ++i) {
            this.inventory.setItem(i, filler);
        }
        this.addMenuControls();
        this.inventory.setItem(49, this.makeItem(Material.ANVIL, "\u00a7bAdd New Line (Chat)", "\u00a77Click to add a new line of text via chat."));
        this.inventory.setItem(51, this.makeItem(Material.PAPER, "\u00a7eAdd Blank Line", "\u00a77Click to insert an empty line."));
        this.inventory.setItem(53, this.makeItem(Material.BARRIER, "\u00a7cBack", new String[0]));
        BuffedItem item = this.plugin.getItemManager().getBuffedItem(this.playerMenuUtility.getItemToEditId());
        if (item == null) {
            new ItemListMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
        List<String> lore = item.getLore();
        if (!lore.isEmpty()) {
            int index;
            for (int i2 = 0; i2 < this.maxItemsPerPage && (index = this.maxItemsPerPage * this.page + i2) < lore.size(); ++i2) {
                String line = lore.get(index);
                String formattedLine = ConfigManager.toSection(ConfigManager.fromLegacy(line));
                String displayName = line.isEmpty() ? "\u00a77(Empty Line)" : formattedLine;
                ArrayList<Object> itemLore = new ArrayList<Object>();
                if (line.isEmpty()) {
                    itemLore.add("\u00a78(This is a blank line)");
                }
                itemLore.add(" ");
                itemLore.add("\u00a7aLeft-Click to Edit");
                itemLore.add("\u00a7cRight-Click to Delete");
                itemLore.add("\u00a78(Line " + (index + 1) + ")");
                this.inventory.setItem(9 + i2, this.makeItem(Material.BOOK, displayName, itemLore.toArray(new String[0])));
            }
        }
    }
}

