/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.editor;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.cost.ICost;
import io.github.altkat.BuffedItems.menu.active.ActiveItemSettingsMenu;
import io.github.altkat.BuffedItems.menu.base.Menu;
import io.github.altkat.BuffedItems.menu.editor.EnchantmentListMenu;
import io.github.altkat.BuffedItems.menu.editor.ItemFlagsMenu;
import io.github.altkat.BuffedItems.menu.editor.LoreEditorMenu;
import io.github.altkat.BuffedItems.menu.editor.PermissionSettingsMenu;
import io.github.altkat.BuffedItems.menu.passive.PassiveItemSettingsMenu;
import io.github.altkat.BuffedItems.menu.selector.MaterialSelectorMenu;
import io.github.altkat.BuffedItems.menu.utility.ItemListMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import io.github.altkat.BuffedItems.utility.item.BuffedItemEffect;
import io.github.altkat.BuffedItems.utility.item.DepletionAction;
import io.github.altkat.BuffedItems.utility.item.ItemBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class ItemEditorMenu
extends Menu {
    private final BuffedItems plugin;

    public ItemEditorMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
    }

    @Override
    public String getMenuName() {
        return "Editing: " + this.playerMenuUtility.getItemToEditId();
    }

    @Override
    public int getSlots() {
        return 36;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        if (e.getCurrentItem() == null) {
            return;
        }
        if (e.getSlot() == 4) {
            BuffedItem item;
            if (e.isLeftClick()) {
                this.playerMenuUtility.toggleShowPreviewDetails();
                this.setMenuItems();
            } else if (e.isRightClick() && (item = this.plugin.getItemManager().getBuffedItem(this.playerMenuUtility.getItemToEditId())) != null) {
                List<Component> infoLore = this.generateItemInfoLore(item);
                p.sendMessage(ConfigManager.fromSection("\u00a78\u00a7m---[ \u00a7bItem Report: " + item.getId() + " \u00a78\u00a7m]---"));
                for (int i = 1; i < infoLore.size(); ++i) {
                    p.sendMessage(infoLore.get(i));
                }
                p.sendMessage(ConfigManager.fromSection("\u00a78\u00a7m---------------------------------"));
            }
            return;
        }
        switch (e.getCurrentItem().getType()) {
            case BARRIER: {
                new ItemListMenu(this.playerMenuUtility, this.plugin).open();
                break;
            }
            case NAME_TAG: {
                this.playerMenuUtility.setWaitingForChatInput(true);
                this.playerMenuUtility.setChatInputPath("display_name");
                p.closeInventory();
                p.sendMessage(ConfigManager.fromLegacyWithPrefix("\u00a7aPlease type the new display name in chat. Use '&' for color codes. &7[ &#E12B5DH&#E12B5De&#E12B5Dx &#E12B5Dc&#E12B5Do&#DD3266l&#D83870o&#D43F79r&#D04583s &#C75295s&#C3599Fu&#BF5FA8p&#BB66B2p&#B66CBBo&#B273C4r&#AE79CEt&#AA80D7e&#A586E1d&#A18DEA! &7]"));
                p.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
                break;
            }
            case BOOK: {
                new LoreEditorMenu(this.playerMenuUtility, this.plugin).open();
                break;
            }
            case PAPER: {
                new PermissionSettingsMenu(this.playerMenuUtility, this.plugin).open();
                break;
            }
            case BEACON: {
                BuffedItem item = this.plugin.getItemManager().getBuffedItem(this.playerMenuUtility.getItemToEditId());
                if (item == null) break;
                ConfigManager.setItemValue(item.getId(), "glow", !item.hasGlow());
                this.open();
                break;
            }
            case GRASS_BLOCK: {
                new MaterialSelectorMenu(this.playerMenuUtility, this.plugin).open();
                break;
            }
            case REDSTONE_TORCH: {
                new ItemFlagsMenu(this.playerMenuUtility, this.plugin).open();
                break;
            }
            case ENCHANTED_BOOK: {
                new EnchantmentListMenu(this.playerMenuUtility, this.plugin).open();
                break;
            }
            case ARMOR_STAND: {
                this.playerMenuUtility.setWaitingForChatInput(true);
                this.playerMenuUtility.setChatInputPath("custom_model_data");
                p.closeInventory();
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aEnter Custom Model Data:"));
                p.sendMessage(ConfigManager.fromSection("\u00a77Direct integer: \u00a7e100001"));
                p.sendMessage(ConfigManager.fromSection("\u00a77ItemsAdder: \u00a7eitemsadder:fire_sword"));
                p.sendMessage(ConfigManager.fromSection("\u00a77Nexo: \u00a7enexo:custom_helmet"));
                p.sendMessage(ConfigManager.fromSection("\u00a77Type \u00a76'none'\u00a77 or \u00a76'remove'\u00a77 to clear."));
                p.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
                break;
            }
            case CHEST_MINECART: {
                new PassiveItemSettingsMenu(this.playerMenuUtility, this.plugin).open();
                break;
            }
            case CLOCK: {
                new ActiveItemSettingsMenu(this.playerMenuUtility, this.plugin).open();
            }
        }
    }

    @Override
    public void setMenuItems() {
        Object cmdDisplay;
        BuffedItem item = this.plugin.getItemManager().getBuffedItem(this.playerMenuUtility.getItemToEditId());
        if (item == null) {
            this.playerMenuUtility.getOwner().sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: Item could not be found. Returning to main menu."));
            new ItemListMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
        ItemStack previewItem = new ItemBuilder(item, (Plugin)this.plugin).build();
        ItemMeta previewMeta = previewItem.getItemMeta();
        if (previewMeta != null) {
            ArrayList originalLore = previewMeta.hasLore() ? new ArrayList(previewMeta.lore()) : new ArrayList();
            ArrayList<Object> combinedLore = new ArrayList<Object>(originalLore);
            if (!originalLore.isEmpty()) {
                combinedLore.add(Component.empty());
            }
            if (this.playerMenuUtility.isShowPreviewDetails()) {
                List<Component> infoLore = this.generateItemInfoLore(item);
                combinedLore.addAll(infoLore);
                combinedLore.add(Component.empty());
                combinedLore.add(ConfigManager.fromSection("\u00a78\u00a7m------------------"));
                combinedLore.add(ConfigManager.fromSection("\u00a77(Live Preview)"));
                combinedLore.add(ConfigManager.fromSection("\u00a7eLeft-click to hide details."));
                combinedLore.add(ConfigManager.fromSection("\u00a7eRight-click to print info to chat."));
            } else {
                combinedLore.add(ConfigManager.fromSection("\u00a78\u00a7m------------------"));
                combinedLore.add(ConfigManager.fromSection("\u00a77(Live Preview)"));
                combinedLore.add(ConfigManager.fromSection("\u00a7aLeft-click to see details."));
                combinedLore.add(ConfigManager.fromSection("\u00a7eRight-click to print info to chat."));
            }
            previewMeta.lore(combinedLore);
            previewMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            previewItem.setItemMeta(previewMeta);
        }
        this.inventory.setItem(4, previewItem);
        String currentName = item.getDisplayName().replace('&', '\u00a7');
        this.inventory.setItem(11, this.makeItem(Material.NAME_TAG, "\u00a7aChange Display Name", "\u00a77Current: " + currentName));
        this.inventory.setItem(12, this.makeItem(Material.GRASS_BLOCK, "\u00a7aChange Material", "\u00a77Current: \u00a7e" + item.getMaterial().name()));
        this.inventory.setItem(13, this.makeItem(Material.BOOK, "\u00a7aEdit Lore", "\u00a77Click to modify the item's lore."));
        String permDisplay = item.getPermission() != null ? item.getPermission() : "\u00a7cNone";
        this.inventory.setItem(14, this.makeItem(Material.PAPER, "\u00a7aPermission Settings", "\u00a77Click to modify permission settings"));
        if (item.getCustomModelData().isPresent()) {
            String raw;
            cmdDisplay = "\u00a7e" + String.valueOf(item.getCustomModelData().get());
            if (item.getCustomModelDataRaw().isPresent() && !(raw = item.getCustomModelDataRaw().get()).equals(String.valueOf(item.getCustomModelData().get()))) {
                cmdDisplay = (String)cmdDisplay + " \u00a77(" + raw + ")";
            }
        } else {
            cmdDisplay = "\u00a7cNone";
        }
        this.inventory.setItem(15, this.makeItem(Material.ARMOR_STAND, "\u00a7dSet Custom Model Data", "\u00a77Current: " + (String)cmdDisplay, "\u00a77Used for custom resource pack models.", "\u00a77Supports: Direct, ItemsAdder, Nexo"));
        this.inventory.setItem(20, this.makeItem(Material.BEACON, "\u00a7aToggle Glow", "\u00a77Current: " + (item.hasGlow() ? "\u00a7aEnabled" : "\u00a7cDisabled")));
        this.inventory.setItem(21, this.makeItem(Material.ENCHANTED_BOOK, "\u00a7dEdit Enchantments", "\u00a77Click to add, remove, or modify", "\u00a77the item's enchantments."));
        this.inventory.setItem(22, this.makeItem(Material.REDSTONE_TORCH, "\u00a76Edit Item Flags", "\u00a77Control item behaviors like 'Unbreakable',", "\u00a77'Prevent Anvil Use', 'Hide Attributes', etc."));
        this.inventory.setItem(23, this.makeItem(Material.CHEST_MINECART, "\u00a7b\u00a7lPassive Effects", "\u00a77Effects that apply when holding", "\u00a77or wearing the item.", "", "\u00a7f\u2022 Potion Effects", "\u00a7f\u2022 Attribute Modifiers", "", "\u00a7eClick to Manage"));
        this.inventory.setItem(24, this.makeItem(Material.CLOCK, "\u00a76\u00a7lActive Abilities", "\u00a77Features triggered by", "\u00a77right-clicking the item.", "", "\u00a7f\u2022 Cooldowns & Visuals", "\u00a7f\u2022 Commands & Sounds", "\u00a7f\u2022 Temporary Effects", "", "\u00a7eClick to Manage"));
        this.addBackButton(new ItemListMenu(this.playerMenuUtility, this.plugin));
        this.setFillerGlass();
    }

    private List<Component> generateItemInfoLore(BuffedItem item) {
        Map<String, BuffedItemEffect> effects;
        ArrayList<Component> infoLore = new ArrayList<Component>();
        infoLore.add(ConfigManager.fromSection("\u00a78\u00a7m------------------"));
        infoLore.add(ConfigManager.fromSection("\u00a77Item ID: \u00a7b" + item.getId()));
        infoLore.add(ConfigManager.fromSection("\u00a77Material: \u00a7f" + item.getMaterial().name()));
        String glowStatus = item.hasGlow() ? "\u00a7aYes" : "\u00a7cNo";
        infoLore.add(ConfigManager.fromSection("\u00a77Glow: " + glowStatus));
        String mainPerm = item.getPermission() != null ? item.getPermission() : "\u00a77None";
        infoLore.add(ConfigManager.fromSection("\u00a77Permission: \u00a7f" + mainPerm));
        if (item.getActivePermissionRaw() != null) {
            infoLore.add(ConfigManager.fromSection("\u00a77- Active Perm: \u00a7b" + item.getActivePermissionRaw()));
        }
        if (item.getPassivePermissionRaw() != null) {
            infoLore.add(ConfigManager.fromSection("\u00a77- Passive Perm: \u00a7d" + item.getPassivePermissionRaw()));
        }
        if (item.getCustomModelData().isPresent()) {
            String raw;
            String cmdDisplay = "\u00a7e" + String.valueOf(item.getCustomModelData().get());
            if (item.getCustomModelDataRaw().isPresent() && !(raw = item.getCustomModelDataRaw().get()).equals(String.valueOf(item.getCustomModelData().get()))) {
                cmdDisplay = cmdDisplay + " \u00a77(" + raw + ")";
            }
            infoLore.add(ConfigManager.fromSection("\u00a77Model Data: " + cmdDisplay));
        }
        infoLore.add((Component)Component.empty());
        if (item.isActiveMode()) {
            BuffedItemEffect activeEffects;
            infoLore.add(ConfigManager.fromSection("\u00a76\u00a7l[Active Ability: ON]"));
            infoLore.add(ConfigManager.fromSection("\u00a77Cooldown: \u00a7f" + item.getCooldown() + "s \u00a77| Duration: \u00a7f" + item.getActiveDuration() + "s"));
            int maxUses = item.getMaxUses();
            if (maxUses > 0) {
                infoLore.add(ConfigManager.fromSection("\u00a77Usage Limit: \u00a7e" + maxUses));
                infoLore.add(ConfigManager.fromSection("\u00a77Depletion: \u00a7f" + item.getDepletionAction().name()));
                if (item.getDepletionAction() == DepletionAction.TRANSFORM) {
                    String target = item.getDepletionTransformId();
                    infoLore.add(ConfigManager.fromSection("\u00a77Transform: \u00a7b" + (target != null ? target : "None")));
                }
            } else {
                infoLore.add(ConfigManager.fromSection("\u00a77Usage Limit: \u00a7aUnlimited"));
            }
            StringBuilder visuals = new StringBuilder();
            visuals.append(item.isVisualChat() ? "\u00a7a[Chat] " : "\u00a78[Chat] ");
            visuals.append(item.isVisualTitle() ? "\u00a7a[Title] " : "\u00a78[Title] ");
            visuals.append(item.isVisualActionBar() ? "\u00a7a[Action] " : "\u00a78[Action] ");
            visuals.append(item.isVisualBossBar() ? "\u00a7a[BossBar]" : "\u00a78[BossBar]");
            infoLore.add(ConfigManager.fromSection("\u00a77Visuals: " + visuals.toString()));
            List<ICost> costs = item.getCosts();
            if (!costs.isEmpty()) {
                infoLore.add(ConfigManager.fromSection("\u00a77Costs:"));
                for (ICost cost : costs) {
                    infoLore.add(ConfigManager.fromSection("  \u00a7c- " + cost.getDisplayString()));
                }
            } else {
                infoLore.add(ConfigManager.fromSection("\u00a77Costs: \u00a7aFree"));
            }
            if (!item.getActiveCommands().isEmpty()) {
                infoLore.add(ConfigManager.fromSection("\u00a77Commands: \u00a7f" + item.getActiveCommands().size() + " active"));
            }
            if (!((activeEffects = item.getActiveEffects()) == null || activeEffects.getPotionEffects().isEmpty() && activeEffects.getParsedAttributes().isEmpty())) {
                infoLore.add(ConfigManager.fromSection("\u00a77On-Click Effects:"));
                activeEffects.getPotionEffects().forEach((type, level) -> infoLore.add(ConfigManager.fromSection("  \u00a77+ Potion: \u00a7d" + type.getName() + " " + level)));
                activeEffects.getParsedAttributes().forEach(attr -> {
                    String attrName = attr.getAttribute().name().replace("GENERIC_", "");
                    infoLore.add(ConfigManager.fromSection("  \u00a77+ Attr: \u00a7d" + attrName + " " + attr.getAmount()));
                });
            }
        } else {
            infoLore.add(ConfigManager.fromSection("\u00a77Active Ability: \u00a7cOFF"));
        }
        Map<Enchantment, Integer> enchants = item.getEnchantments();
        if (!enchants.isEmpty()) {
            infoLore.add((Component)Component.empty());
            infoLore.add(ConfigManager.fromSection("\u00a7b\u00a7l[Enchantments]"));
            enchants.forEach((enchant, level) -> {
                String enchantName = enchant.getKey().getKey().replace("minecraft:", "").toUpperCase();
                infoLore.add(ConfigManager.fromSection("\u00a77- " + enchantName + " " + level));
            });
        }
        if (!(effects = item.getEffects()).isEmpty()) {
            infoLore.add((Component)Component.empty());
            infoLore.add(ConfigManager.fromSection("\u00a7d\u00a7l[Passive Effects]"));
            effects.forEach((slot, effect) -> {
                boolean hasContent;
                boolean bl = hasContent = !effect.getPotionEffects().isEmpty() || !effect.getParsedAttributes().isEmpty();
                if (hasContent) {
                    infoLore.add(ConfigManager.fromSection("\u00a7eSlot: " + slot));
                    effect.getPotionEffects().forEach((type, level) -> infoLore.add(ConfigManager.fromSection("  \u00a77\u2022 Potion: \u00a7f" + type.getName() + " " + level)));
                    effect.getParsedAttributes().forEach(attr -> {
                        String attrName = attr.getAttribute().name().replace("GENERIC_", "");
                        String opSymbol = attr.getOperation() == AttributeModifier.Operation.ADD_NUMBER ? "+" : "%";
                        infoLore.add(ConfigManager.fromSection("  \u00a77\u2022 Attr: \u00a7f" + attrName + " " + opSymbol + attr.getAmount()));
                    });
                }
            });
        }
        Map<String, Boolean> flags = item.getFlags();
        ArrayList activeFlags = new ArrayList();
        flags.forEach((flag, value) -> {
            if (value.booleanValue()) {
                activeFlags.add(flag);
            }
        });
        if (!activeFlags.isEmpty()) {
            infoLore.add((Component)Component.empty());
            infoLore.add(ConfigManager.fromSection("\u00a7c\u00a7l[Flags]"));
            for (String flag2 : activeFlags) {
                infoLore.add(ConfigManager.fromSection("\u00a77- " + flag2));
            }
        }
        return infoLore;
    }
}

