/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.base;

import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class Menu
implements InventoryHolder {
    protected Inventory inventory;
    protected PlayerMenuUtility playerMenuUtility;

    public Menu(PlayerMenuUtility playerMenuUtility) {
        this.playerMenuUtility = playerMenuUtility;
    }

    public abstract String getMenuName();

    public abstract int getSlots();

    public abstract void handleMenu(InventoryClickEvent var1);

    public abstract void setMenuItems();

    public void open() {
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.getSlots(), (Component)ConfigManager.fromSection(this.getMenuName()));
        this.setMenuItems();
        this.playerMenuUtility.getOwner().openInventory(this.inventory);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    protected void setFillerGlass() {
        for (int i = 0; i < this.getSlots(); ++i) {
            if (this.inventory.getItem(i) != null) continue;
            ItemStack filler = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
            ItemMeta fillerMeta = filler.getItemMeta();
            fillerMeta.displayName(ConfigManager.fromSection(" "));
            filler.setItemMeta(fillerMeta);
            this.inventory.setItem(i, filler);
        }
    }

    protected void addBackButton(Menu targetMenu) {
        ItemStack back = new ItemStack(Material.BARRIER);
        ItemMeta backMeta = back.getItemMeta();
        backMeta.displayName(ConfigManager.fromSection("\u00a7cBack"));
        back.setItemMeta(backMeta);
        this.inventory.setItem(this.getSlots() - 1, back);
    }

    protected ItemStack makeItem(Material material, String displayName, String ... lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(ConfigManager.fromSection(displayName));
        List loreComponents = Arrays.stream(lore).map(ConfigManager::fromSection).collect(Collectors.toList());
        meta.lore(loreComponents);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_ADDITIONAL_TOOLTIP, ItemFlag.HIDE_UNBREAKABLE, ItemFlag.HIDE_DESTROYS, ItemFlag.HIDE_PLACED_ON, ItemFlag.HIDE_ADDITIONAL_TOOLTIP, ItemFlag.HIDE_DYE, ItemFlag.HIDE_ARMOR_TRIM, ItemFlag.HIDE_STORED_ENCHANTS});
        item.setItemMeta(meta);
        return item;
    }

    public void handleClose(InventoryCloseEvent e) {
    }

    public boolean allowBottomInventoryClick() {
        return false;
    }
}

