/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.active;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.menu.active.ActiveItemSettingsMenu;
import io.github.altkat.BuffedItems.menu.base.Menu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import io.github.altkat.BuffedItems.menu.utility.SoundSettingsMenu;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class ActiveItemSoundsMenu
extends Menu {
    private final BuffedItems plugin;
    private final String itemId;

    public ActiveItemSoundsMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.itemId = playerMenuUtility.getItemToEditId();
    }

    @Override
    public String getMenuName() {
        return "Sound Settings: " + this.itemId;
    }

    @Override
    public int getSlots() {
        return 36;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        if (e.getCurrentItem() == null) {
            return;
        }
        Material type = e.getCurrentItem().getType();
        if (type == Material.BARRIER && e.getSlot() == 35) {
            new ActiveItemSettingsMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
        if (e.getSlot() == 10) {
            new SoundSettingsMenu(this.playerMenuUtility, this.plugin, "success").open();
        } else if (e.getSlot() == 12) {
            new SoundSettingsMenu(this.playerMenuUtility, this.plugin, "cost-fail").open();
        } else if (e.getSlot() == 14) {
            new SoundSettingsMenu(this.playerMenuUtility, this.plugin, "cooldown").open();
        } else if (e.getSlot() == 16) {
            new SoundSettingsMenu(this.playerMenuUtility, this.plugin, "depletion").open();
        } else if (e.getSlot() == 25) {
            new SoundSettingsMenu(this.playerMenuUtility, this.plugin, "depleted-try").open();
        }
    }

    @Override
    public void setMenuItems() {
        BuffedItem item = this.plugin.getItemManager().getBuffedItem(this.itemId);
        if (item == null) {
            return;
        }
        this.setFillerGlass();
        Object currSuccess = item.getCustomSuccessSound();
        currSuccess = currSuccess == null ? "\u00a7a" + ConfigManager.getGlobalSuccessSound() + " \u00a78(Default)" : "\u00a7a" + (String)currSuccess;
        this.inventory.setItem(10, this.makeItem(Material.EXPERIENCE_BOTTLE, "\u00a7aSuccess Sound", "\u00a77Sound played on successful use.", "\u00a77Current: " + (String)currSuccess, "", "\u00a7eClick to Change"));
        Object currCostFail = item.getCustomCostFailSound();
        currCostFail = currCostFail == null ? "\u00a76" + ConfigManager.getGlobalCostFailSound() + " \u00a78(Default)" : "\u00a76" + (String)currCostFail;
        this.inventory.setItem(12, this.makeItem(Material.REDSTONE, "\u00a76Cost Fail Sound", "\u00a77Sound played when a cost is not met.", "\u00a77Current: " + (String)currCostFail, "", "\u00a7eClick to Change"));
        Object currCool = item.getCustomCooldownSound();
        currCool = currCool == null ? "\u00a7c" + ConfigManager.getGlobalCooldownSound() + " \u00a78(Default)" : "\u00a7c" + (String)currCool;
        this.inventory.setItem(14, this.makeItem(Material.ANVIL, "\u00a7cCooldown Sound", "\u00a77Sound played when on cooldown.", "\u00a77Current: " + (String)currCool, "", "\u00a7eClick to Change"));
        Object currDepletion = item.getCustomDepletionSound();
        currDepletion = currDepletion == null ? "\u00a75" + ConfigManager.getGlobalDepletionSound() + " \u00a78(Default)" : "\u00a75" + (String)currDepletion;
        this.inventory.setItem(16, this.makeItem(Material.JUKEBOX, "\u00a75Depletion Sound", "\u00a77Sound played when item breaks/depletes.", "\u00a77Current: " + (String)currDepletion, "", "\u00a7eClick to Change"));
        Object currTry = item.getCustomDepletedTrySound();
        currTry = currTry == null ? "\u00a77" + ConfigManager.getGlobalDepletedTrySound() + " \u00a78(Default)" : "\u00a77" + (String)currTry;
        this.inventory.setItem(25, this.makeItem(Material.DISPENSER, "\u00a78Depleted Try Sound", "\u00a77Sound played when trying to use", "\u00a77an empty/depleted item.", "\u00a77Current: " + (String)currTry, "", "\u00a7eClick to Change"));
        this.inventory.setItem(35, this.makeItem(Material.BARRIER, "\u00a7cBack", new String[0]));
    }
}

