/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.manager.set;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.config.SetsConfig;
import io.github.altkat.BuffedItems.utility.attribute.ParsedAttribute;
import io.github.altkat.BuffedItems.utility.item.BuffedItemEffect;
import io.github.altkat.BuffedItems.utility.set.BuffedSet;
import io.github.altkat.BuffedItems.utility.set.SetBonus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.potion.PotionEffectType;

public class SetManager {
    private final BuffedItems plugin;
    private final Map<String, BuffedSet> sets = new HashMap<String, BuffedSet>();
    private final Map<String, String> itemToSetMap = new HashMap<String, String>();

    public SetManager(BuffedItems plugin) {
        this.plugin = plugin;
    }

    public void loadSets(boolean silent) {
        long startTime = System.currentTimeMillis();
        this.sets.clear();
        this.itemToSetMap.clear();
        if (!SetsConfig.get().getBoolean("settings.enabled", true)) {
            ConfigManager.sendDebugMessage(1, () -> "Item Sets system is disabled in sets.yml");
            return;
        }
        ConfigurationSection section = SetsConfig.get().getConfigurationSection("sets");
        if (section == null) {
            if (!silent) {
                ConfigManager.logInfo("&eNo item sets found in sets.yml.");
            }
            return;
        }
        if (!silent) {
            ConfigManager.sendDebugMessage(1, () -> "[SetManager] Loading sets...");
        }
        int validCount = 0;
        int invalidCount = 0;
        ArrayList<String> setsWithErrors = new ArrayList<String>();
        for (String setId : section.getKeys(false)) {
            ConfigurationSection setSection = section.getConfigurationSection(setId);
            if (setSection == null) continue;
            ArrayList<String> errors = new ArrayList<String>();
            boolean isValid = true;
            String displayName = setSection.getString("display_name", setId);
            List items = setSection.getStringList("items");
            if (items.isEmpty()) {
                isValid = false;
                errors.add("Set has no items defined.");
            }
            for (String itemId : items) {
                if (this.plugin.getItemManager().getBuffedItem(itemId) == null) {
                    isValid = false;
                    errors.add("Item '" + itemId + "' does not exist (not loaded in ItemManager).");
                    continue;
                }
                if (!this.itemToSetMap.containsKey(itemId)) continue;
                isValid = false;
                errors.add("Item '" + itemId + "' is already assigned to set '" + this.itemToSetMap.get(itemId) + "'.");
            }
            if (isValid) {
                for (String itemId : items) {
                    this.itemToSetMap.put(itemId, setId);
                }
            }
            HashMap<Integer, SetBonus> bonuses = new HashMap<Integer, SetBonus>();
            ConfigurationSection bonusesSection = setSection.getConfigurationSection("bonuses");
            ArrayList<Integer> exceedingBonuses = new ArrayList<Integer>();
            if (bonusesSection != null) {
                for (String countStr : bonusesSection.getKeys(false)) {
                    try {
                        int count = Integer.parseInt(countStr);
                        if (count <= 0) {
                            errors.add("Invalid bonus count '" + countStr + "'. Must be positive.");
                            isValid = false;
                            continue;
                        }
                        if (count > items.size()) {
                            exceedingBonuses.add(count);
                            isValid = false;
                            continue;
                        }
                        BuffedItemEffect effects = this.parseEffects(bonusesSection.getConfigurationSection(countStr), setId, count, errors);
                        bonuses.put(count, new SetBonus(count, effects));
                    }
                    catch (NumberFormatException e) {
                        errors.add("Invalid bonus key '" + countStr + "'. Must be a number.");
                        isValid = false;
                    }
                }
            }
            if (!exceedingBonuses.isEmpty()) {
                Collections.sort(exceedingBonuses);
                String countsStr = ((Object)exceedingBonuses).toString().replace("[", "").replace("]", "");
                errors.add("Bonuses configured for pieces " + countsStr + " exceed set size (Total items: " + items.size() + ").");
            }
            if (isValid) {
                ++validCount;
            } else {
                ++invalidCount;
                setsWithErrors.add(setId);
            }
            this.sets.put(setId, new BuffedSet(setId, displayName, items, bonuses, isValid, errors));
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        if (!silent) {
            ConfigManager.logInfo("&aLoaded &e" + this.sets.size() + "&a item sets (&e" + validCount + "&a valid, &e" + invalidCount + "&c with errors&a) in &e" + elapsedTime + "&ams");
            if (invalidCount > 0) {
                String separator = "============================================================";
                this.plugin.getLogger().warning(separator);
                this.plugin.getLogger().warning("\u26a0 " + invalidCount + " item set(s) have configuration errors:");
                for (String setId : setsWithErrors) {
                    BuffedSet set = this.sets.get(setId);
                    this.plugin.getLogger().warning("  \u2022 " + setId + " (" + set.getErrorMessages().size() + " error(s))");
                    for (String error : set.getErrorMessages()) {
                        this.plugin.getLogger().warning("    - " + ConfigManager.stripLegacy(error));
                    }
                }
                this.plugin.getLogger().warning(separator);
            }
        }
    }

    private BuffedItemEffect parseEffects(ConfigurationSection section, String setId, int count, List<String> errors) {
        String[] parts;
        HashMap<PotionEffectType, Integer> potions = new HashMap<PotionEffectType, Integer>();
        ArrayList<ParsedAttribute> attributes = new ArrayList<ParsedAttribute>();
        if (section == null) {
            return new BuffedItemEffect(potions, attributes);
        }
        for (String s : section.getStringList("potion_effects")) {
            try {
                parts = s.split(";");
                if (parts.length < 2) {
                    throw new IllegalArgumentException("Missing level");
                }
                PotionEffectType type = PotionEffectType.getByName((String)parts[0].toUpperCase());
                if (type == null) {
                    throw new IllegalArgumentException("Invalid potion type: " + parts[0]);
                }
                int level = Integer.parseInt(parts[1]);
                potions.put(type, level);
            }
            catch (Exception e) {
                errors.add("Set Bonus (" + count + " pcs) Potion Error: " + e.getMessage() + " in '" + s + "'");
            }
        }
        for (String s : section.getStringList("attributes")) {
            try {
                parts = s.split(";");
                if (parts.length < 3) {
                    throw new IllegalArgumentException("Invalid format");
                }
                Attribute attr = Attribute.valueOf((String)parts[0].toUpperCase());
                AttributeModifier.Operation op = AttributeModifier.Operation.valueOf((String)parts[1].toUpperCase());
                double amount = Double.parseDouble(parts[2]);
                UUID uuid = UUID.nameUUIDFromBytes(("buffeditems.set." + setId + "." + count + "." + attr.name()).getBytes());
                attributes.add(new ParsedAttribute(attr, op, amount, uuid));
            }
            catch (IllegalArgumentException e) {
                errors.add("Set Bonus (" + count + " pcs) Attribute Error: Invalid Enum/Number in '" + s + "'");
            }
            catch (Exception e) {
                errors.add("Set Bonus (" + count + " pcs) Attribute Error: " + e.getMessage());
            }
        }
        return new BuffedItemEffect(potions, attributes);
    }

    public BuffedSet getSet(String setId) {
        return this.sets.get(setId);
    }

    public String getSetIdByItem(String itemId) {
        return this.itemToSetMap.get(itemId);
    }

    public Map<String, BuffedSet> getSets() {
        return Collections.unmodifiableMap(this.sets);
    }
}

