/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.manager.effect;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.utility.attribute.ParsedAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class EffectManager {
    private final BuffedItems plugin;
    private static final int REFRESH_THRESHOLD_TICKS = 440;
    private static final int EFFECT_DURATION_TICKS = 600;

    public EffectManager(BuffedItems plugin) {
        this.plugin = plugin;
    }

    public static UUID getUuidForItem(String itemId, String slot, Attribute attribute) {
        String uniqueKey = "buffeditems." + itemId + "." + slot + "." + attribute.name();
        return UUID.nameUUIDFromBytes(uniqueKey.getBytes());
    }

    public void applyOrRefreshPotionEffects(Player player, Map<PotionEffectType, Integer> desiredEffects, boolean debugTick) {
        boolean showIcon = ConfigManager.shouldShowPotionIcons();
        for (Map.Entry<PotionEffectType, Integer> entry : desiredEffects.entrySet()) {
            PotionEffectType type = entry.getKey();
            int amplifier = entry.getValue() - 1;
            PotionEffect existingEffect = player.getPotionEffect(type);
            if (existingEffect == null) {
                ConfigManager.sendDebugMessage(3, () -> "[Potion] Applying new effect to " + player.getName() + ": " + type.getName() + " " + (amplifier + 1));
                player.addPotionEffect(new PotionEffect(type, 600, amplifier, true, false, showIcon));
                continue;
            }
            if (existingEffect.getAmplifier() < amplifier || existingEffect.getAmplifier() == amplifier && existingEffect.getDuration() < 440) {
                if (existingEffect.getAmplifier() < amplifier) {
                    ConfigManager.sendDebugMessage(3, () -> "[Potion] Upgrading effect for " + player.getName() + ": " + type.getName() + " " + (existingEffect.getAmplifier() + 1) + " -> " + (amplifier + 1));
                } else {
                    ConfigManager.sendDebugMessage(3, () -> "[Potion] Refreshing effect for " + player.getName() + ": " + type.getName() + " (duration: " + existingEffect.getDuration() + " -> 600)");
                }
                player.addPotionEffect(new PotionEffect(type, 600, amplifier, true, false, showIcon));
                continue;
            }
            if (!debugTick) continue;
            ConfigManager.sendDebugMessage(3, () -> "[Potion] Effect already optimal for " + player.getName() + ": " + type.getName() + " (skipping)");
        }
    }

    public void removeObsoletePotionEffects(Player player, Set<PotionEffectType> lastAppliedEffects, Set<PotionEffectType> desiredEffects, boolean debugTick) {
        HashSet<PotionEffectType> effectsToRemove = new HashSet<PotionEffectType>(lastAppliedEffects);
        effectsToRemove.removeAll(desiredEffects);
        for (PotionEffectType type : effectsToRemove) {
            boolean isManagedByBuffedItems;
            PotionEffect currentEffect = player.getPotionEffect(type);
            if (currentEffect == null) continue;
            boolean bl = isManagedByBuffedItems = currentEffect.getDuration() <= 600;
            if (isManagedByBuffedItems) {
                player.removePotionEffect(type);
                ConfigManager.sendDebugMessage(3, () -> "[Potion] REMOVED obsolete effect from " + player.getName() + ": " + type.getName() + " (duration was: " + currentEffect.getDuration() + ")");
                continue;
            }
            if (!debugTick) continue;
            ConfigManager.sendDebugMessage(3, () -> "[Potion] NOT removing effect " + type.getName() + " from " + player.getName() + " (duration: " + currentEffect.getDuration() + " suggests external source)");
        }
    }

    public void applySingleAttribute(Player player, ParsedAttribute parsedAttr, String slot) {
        UUID modifierUUID = parsedAttr.getUuid();
        Attribute attribute = parsedAttr.getAttribute();
        if (this.plugin.getActiveAttributeManager().hasModifier(player.getUniqueId(), attribute, modifierUUID)) {
            ConfigManager.sendDebugMessage(3, () -> "[Attribute-Fast Path] Modifier " + String.valueOf(modifierUUID) + " already tracked for " + player.getName() + " (skipping apply)");
            return;
        }
        AttributeInstance instance = player.getAttribute(attribute);
        if (instance == null) {
            this.plugin.getLogger().warning("Player " + player.getName() + " does not have attribute '" + attribute.name() + "'");
            return;
        }
        AttributeModifier existingMod = null;
        for (AttributeModifier mod : instance.getModifiers()) {
            if (!mod.getUniqueId().equals(modifierUUID)) continue;
            existingMod = mod;
            break;
        }
        if (existingMod != null) {
            this.plugin.getActiveAttributeManager().addModifier(player.getUniqueId(), attribute, existingMod);
            ConfigManager.sendDebugMessage(3, () -> "[Attribute-Fast Path] Modifier " + String.valueOf(modifierUUID) + " found on player but wasn't tracked. Re-tracking now.");
            return;
        }
        EquipmentSlot equipmentSlot = this.getEquipmentSlot(slot);
        String modifierName = "buffeditems." + String.valueOf(modifierUUID);
        AttributeModifier modifier = new AttributeModifier(modifierUUID, modifierName, parsedAttr.getAmount(), parsedAttr.getOperation(), equipmentSlot);
        try {
            instance.addModifier(modifier);
            this.plugin.getActiveAttributeManager().addModifier(player.getUniqueId(), attribute, modifier);
            ConfigManager.sendDebugMessage(3, () -> "[Attribute-Fast Path] Applied modifier " + String.valueOf(modifierUUID) + " to " + player.getName() + ": " + attribute.name());
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to apply single attribute modifier " + String.valueOf(modifierUUID) + ": " + e.getMessage());
        }
    }

    public void clearAllAttributes(Player player) {
        UUID playerUUID = player.getUniqueId();
        ConfigManager.sendDebugMessage(2, () -> "[Attribute] Clearing all tracked attributes for " + player.getName());
        Map<Attribute, List<AttributeModifier>> trackedModifiersMap = this.plugin.getActiveAttributeManager().getAndClearModifiers(playerUUID);
        if (trackedModifiersMap == null || trackedModifiersMap.isEmpty()) {
            ConfigManager.sendDebugMessage(3, () -> "[Attribute] No tracked modifiers to remove for " + player.getName());
            this.cleanupOrphanedModifiers(player);
            return;
        }
        int attemptedRemoveCount = 0;
        for (Map.Entry<Attribute, List<AttributeModifier>> entry : trackedModifiersMap.entrySet()) {
            Attribute attribute = entry.getKey();
            List<AttributeModifier> modifiersToRemove = entry.getValue();
            AttributeInstance instance = player.getAttribute(attribute);
            if (instance == null) {
                ConfigManager.sendDebugMessage(3, () -> "[Attribute] Player " + player.getName() + " missing attribute " + attribute.name() + " during clear operation.");
                continue;
            }
            for (AttributeModifier modifier : modifiersToRemove) {
                try {
                    instance.removeModifier(modifier);
                    ++attemptedRemoveCount;
                    ConfigManager.sendDebugMessage(3, () -> "[Attribute] Attempted removal of tracked modifier " + String.valueOf(modifier.getUniqueId()) + " from " + attribute.name());
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Error removing modifier " + String.valueOf(modifier.getUniqueId()) + " for attribute " + attribute.name() + " from player " + player.getName() + ": " + e.getMessage());
                }
            }
        }
        int finalAttemptedRemoveCount = attemptedRemoveCount;
        ConfigManager.sendDebugMessage(2, () -> "[Attribute] Finished clearing tracked attributes for " + player.getName() + " (Attempted removals: " + finalAttemptedRemoveCount + ")");
        this.cleanupOrphanedModifiers(player);
    }

    public void removeAttributeModifier(Player player, Attribute attribute, UUID modifierUUID) {
        boolean removedFromTracking;
        AttributeInstance instance = player.getAttribute(attribute);
        AttributeModifier modifierToRemove = null;
        if (instance != null) {
            for (AttributeModifier mod : instance.getModifiers()) {
                if (!mod.getUniqueId().equals(modifierUUID)) continue;
                modifierToRemove = mod;
                break;
            }
            if (modifierToRemove != null) {
                try {
                    instance.removeModifier(modifierToRemove);
                    ConfigManager.sendDebugMessage(3, () -> "[Attribute] REMOVED modifier " + String.valueOf(modifierUUID) + " from " + attribute.name() + " for player " + player.getName());
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Error removing modifier " + String.valueOf(modifierUUID) + " for attribute " + attribute.name() + " from player " + player.getName() + ": " + e.getMessage());
                }
            }
        }
        if (removedFromTracking = this.plugin.getActiveAttributeManager().removeModifier(player.getUniqueId(), attribute, modifierUUID)) {
            ConfigManager.sendDebugMessage(3, () -> "[Attribute] Removed modifier " + String.valueOf(modifierUUID) + " from tracking for attribute " + attribute.name() + " for player " + player.getName());
        }
    }

    private void cleanupOrphanedModifiers(Player player) {
        Set<UUID> managedUUIDs = this.plugin.getItemManager().getManagedAttributeUUIDs();
        if (managedUUIDs.isEmpty()) {
            return;
        }
        int orphanAttemptCount = 0;
        UUID playerUUID = player.getUniqueId();
        for (Attribute attribute : Attribute.values()) {
            AttributeInstance instance = player.getAttribute(attribute);
            if (instance == null) continue;
            ArrayList<AttributeModifier> orphansToRemove = new ArrayList<AttributeModifier>();
            for (AttributeModifier modifier : instance.getModifiers()) {
                UUID currentUUID = modifier.getUniqueId();
                if (!managedUUIDs.contains(currentUUID) || this.plugin.getActiveAttributeManager().hasModifier(playerUUID, attribute, currentUUID)) continue;
                orphansToRemove.add(modifier);
            }
            for (AttributeModifier orphan : orphansToRemove) {
                try {
                    instance.removeModifier(orphan);
                    ++orphanAttemptCount;
                    ConfigManager.sendDebugMessage(3, () -> "[Attribute] Attempted cleanup of orphaned modifier from " + attribute.name() + ": " + String.valueOf(orphan.getUniqueId()));
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Failed to remove orphaned modifier " + String.valueOf(orphan.getUniqueId()) + " for attribute " + attribute.name() + " from player " + player.getName() + ": " + e.getMessage());
                }
            }
        }
        if (orphanAttemptCount > 0) {
            int finalOrphanAttemptCount = orphanAttemptCount;
            String playerName = player.getName();
            ConfigManager.sendDebugMessage(2, () -> "[Attribute] Attempted to clean " + finalOrphanAttemptCount + " orphaned modifier(s) for player " + playerName);
        }
    }

    private EquipmentSlot getEquipmentSlot(String slot) {
        switch (slot.toUpperCase()) {
            case "MAIN_HAND": {
                return EquipmentSlot.HAND;
            }
            case "OFF_HAND": {
                return EquipmentSlot.OFF_HAND;
            }
            case "HELMET": {
                return EquipmentSlot.HEAD;
            }
            case "CHESTPLATE": {
                return EquipmentSlot.CHEST;
            }
            case "LEGGINGS": {
                return EquipmentSlot.LEGS;
            }
            case "BOOTS": {
                return EquipmentSlot.FEET;
            }
        }
        return null;
    }
}

