/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.manager.crafting;

import io.github.altkat.BuffedItems.manager.crafting.MatchType;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class RecipeIngredient {
    private final MatchType matchType;
    private final Material material;
    private final String data;
    private final int amount;
    private ItemStack cachedPreviewItem;
    private ItemStack exactReferenceItem;

    public RecipeIngredient(MatchType matchType, Material material, String data, int amount) {
        this.matchType = matchType;
        this.material = material;
        this.data = data;
        this.amount = Math.max(1, amount);
    }

    public MatchType getMatchType() {
        return this.matchType;
    }

    public Material getMaterial() {
        return this.material;
    }

    public String getData() {
        return this.data;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setExactReferenceItem(ItemStack item) {
        this.exactReferenceItem = item;
    }

    public ItemStack getExactReferenceItem() {
        return this.exactReferenceItem;
    }

    public void setCachedPreviewItem(ItemStack item) {
        this.cachedPreviewItem = item;
    }

    public ItemStack getCachedPreviewItem() {
        if (this.cachedPreviewItem == null) {
            ItemStack stack = new ItemStack(this.material != null ? this.material : Material.BARRIER);
            stack.setAmount(this.amount);
            return stack;
        }
        this.cachedPreviewItem.setAmount(this.amount);
        return this.cachedPreviewItem;
    }
}

