/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.listener.handler;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.listener.handler.ChatInputHandler;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.menu.editor.ItemEditorMenu;
import io.github.altkat.BuffedItems.menu.utility.ItemListMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import org.bukkit.entity.Player;

public class CreationInputHandler
implements ChatInputHandler {
    private final BuffedItems plugin;

    public CreationInputHandler(BuffedItems plugin) {
        this.plugin = plugin;
    }

    @Override
    public void handle(Player player, PlayerMenuUtility pmu, String input, String path, String itemId) {
        if (path.equals("createnewitem")) {
            this.handleCreateNewItem(player, pmu, input);
        } else if (path.equals("duplicateitem")) {
            this.handleDuplicateItem(player, pmu, input);
        }
    }

    private void handleCreateNewItem(Player player, PlayerMenuUtility pmu, String input) {
        String newItemId = input.toLowerCase().replaceAll("\\s+", "_");
        ConfigManager.sendDebugMessage(1, () -> "[CreationHandler] Creating new item: " + newItemId);
        if (ConfigManager.createNewItem(newItemId)) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aNew item '" + newItemId + "' created. Now editing..."));
            pmu.setItemToEditId(newItemId);
            this.closeChatInput(pmu);
            new ItemEditorMenu(pmu, this.plugin).open();
        } else {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: An item with the ID '" + newItemId + "' already exists."));
            this.closeChatInput(pmu);
            new ItemListMenu(pmu, this.plugin).open();
        }
    }

    private void handleDuplicateItem(Player player, PlayerMenuUtility pmu, String input) {
        String sourceItemId = pmu.getItemToEditId();
        String newItemId = input.toLowerCase().replaceAll("\\s+", "_");
        if (newItemId.equals(sourceItemId)) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: New ID cannot be the same as the source ID."));
            player.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
            pmu.setWaitingForChatInput(true);
            pmu.setChatInputPath("duplicateitem");
            return;
        }
        ConfigManager.sendDebugMessage(1, () -> "[CreationHandler] Attempting to duplicate '" + sourceItemId + "' as '" + newItemId + "'");
        String createdId = ConfigManager.duplicateItem(sourceItemId, newItemId);
        if (createdId != null) {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aItem '\u00a7e" + sourceItemId + "\u00a7a' successfully duplicated as '\u00a7e" + createdId + "\u00a7a'."));
            this.closeChatInput(pmu);
            new ItemListMenu(pmu, this.plugin).open();
        } else {
            player.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cError: An item with the ID '\u00a7e" + newItemId + "\u00a7c' already exists."));
            player.sendMessage(ConfigManager.fromSection("\u00a7aPlease try a different ID."));
            player.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
            pmu.setWaitingForChatInput(true);
            pmu.setChatInputPath("duplicateitem");
        }
    }

    private void closeChatInput(PlayerMenuUtility pmu) {
        pmu.setWaitingForChatInput(false);
        pmu.setChatInputPath(null);
    }
}

