/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.command;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.RecipesConfig;
import io.github.altkat.BuffedItems.manager.config.SetsConfig;
import io.github.altkat.BuffedItems.manager.config.UpgradesConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class TabCompleteHandler
implements TabCompleter {
    private final BuffedItems plugin;

    public TabCompleteHandler(BuffedItems plugin) {
        this.plugin = plugin;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            ArrayList<String> subcommands = new ArrayList<String>();
            if (sender.hasPermission("buffeditems.command.give")) {
                subcommands.add("give");
            }
            if (sender.hasPermission("buffeditems.command.reload")) {
                subcommands.add("reload");
            }
            if (sender.hasPermission("buffeditems.command.list")) {
                subcommands.add("list");
            }
            if (sender.hasPermission("buffeditems.command.menu")) {
                subcommands.add("menu");
            }
            if (sender.hasPermission("buffeditems.command.wiki")) {
                subcommands.add("wiki");
            }
            if (sender.hasPermission("buffeditems.command.update")) {
                subcommands.add("update");
            }
            if (sender.hasPermission("buffeditems.command.upgrade") && UpgradesConfig.get().getBoolean("settings.enabled", true)) {
                subcommands.add("upgrade");
            }
            if (sender.hasPermission("buffeditems.command.recipes") && RecipesConfig.get().getBoolean("settings.enabled", true)) {
                subcommands.add("recipes");
            }
            if (sender.hasPermission("buffeditems.command.sets") && SetsConfig.get().getBoolean("settings.enabled", true)) {
                subcommands.add("sets");
            }
            StringUtil.copyPartialMatches((String)args[0], subcommands, completions);
        } else if (args.length == 2 && args[0].equalsIgnoreCase("give")) {
            List playerNames = Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
            StringUtil.copyPartialMatches((String)args[1], playerNames, completions);
        } else if (args.length == 3 && args[0].equalsIgnoreCase("give")) {
            ArrayList<String> itemIds = new ArrayList<String>(this.plugin.getItemManager().getLoadedItems().keySet());
            StringUtil.copyPartialMatches((String)args[2], itemIds, completions);
        }
        return completions;
    }
}

