/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.command;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.hooks.HookManager;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.config.RecipesConfig;
import io.github.altkat.BuffedItems.manager.config.SetsConfig;
import io.github.altkat.BuffedItems.manager.config.UpgradesConfig;
import io.github.altkat.BuffedItems.menu.crafting.PublicRecipeListMenu;
import io.github.altkat.BuffedItems.menu.set.PublicSetListMenu;
import io.github.altkat.BuffedItems.menu.upgrade.UpgradeMenu;
import io.github.altkat.BuffedItems.menu.utility.MainMenu;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import io.github.altkat.BuffedItems.utility.item.ItemBuilder;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class BuffedItemCommand
implements CommandExecutor {
    private final BuffedItems plugin;
    private final Component noPermissionMessage = ConfigManager.fromSection("\u00a7cYou do not have permission to use this command.");
    private final HookManager hooks;

    public BuffedItemCommand(BuffedItems plugin) {
        this.plugin = plugin;
        this.hooks = plugin.getHookManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (args.length == 0) {
            this.sendHelpMessage(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "give": {
                if (!sender.hasPermission("buffeditems.command.give")) {
                    sender.sendMessage(this.noPermissionMessage);
                    return true;
                }
                return this.handleGiveCommand(sender, args);
            }
            case "reload": {
                if (!sender.hasPermission("buffeditems.command.reload")) {
                    sender.sendMessage(this.noPermissionMessage);
                    return true;
                }
                return this.handleReloadCommand(sender, args);
            }
            case "list": {
                if (!sender.hasPermission("buffeditems.command.list")) {
                    sender.sendMessage(this.noPermissionMessage);
                    return true;
                }
                return this.handleListCommand(sender);
            }
            case "menu": {
                if (!sender.hasPermission("buffeditems.command.menu")) {
                    sender.sendMessage(this.noPermissionMessage);
                    return true;
                }
                if (sender instanceof Player) {
                    Player p = (Player)sender;
                    BuffedItems.getPlayerMenuUtility(p).flushData();
                    ConfigManager.sendDebugMessage(1, () -> "[Command] Opening main menu for " + p.getName());
                    new MainMenu(BuffedItems.getPlayerMenuUtility(p), this.plugin).open();
                } else {
                    sender.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cThis command can only be used by players."));
                }
                return true;
            }
            case "upgrade": {
                if (!sender.hasPermission("buffeditems.command.upgrade")) {
                    sender.sendMessage(this.noPermissionMessage);
                    return true;
                }
                if (!UpgradesConfig.get().getBoolean("settings.enabled", true)) {
                    sender.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cThe Upgrade system is currently disabled."));
                    return true;
                }
                if (sender instanceof Player) {
                    Player p = (Player)sender;
                    new UpgradeMenu(BuffedItems.getPlayerMenuUtility(p), this.plugin).open();
                } else {
                    sender.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cOnly players can use this command."));
                }
                return true;
            }
            case "wiki": {
                if (!sender.hasPermission("buffeditems.command.wiki")) {
                    sender.sendMessage(this.noPermissionMessage);
                    return true;
                }
                this.handleWikiCommand(sender);
                return true;
            }
            case "recipes": {
                if (!sender.hasPermission("buffeditems.command.recipes")) {
                    sender.sendMessage(this.noPermissionMessage);
                    return true;
                }
                if (!RecipesConfig.get().getBoolean("settings.enabled", true)) {
                    sender.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cThe Crafting system is currently disabled."));
                    return true;
                }
                if (sender instanceof Player) {
                    Player p = (Player)sender;
                    new PublicRecipeListMenu(BuffedItems.getPlayerMenuUtility(p), this.plugin).open();
                } else {
                    sender.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cOnly players can use this command."));
                }
                return true;
            }
            case "sets": {
                if (!sender.hasPermission("buffeditems.command.sets")) {
                    sender.sendMessage(this.noPermissionMessage);
                    return true;
                }
                if (!SetsConfig.get().getBoolean("settings.enabled", true)) {
                    sender.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cThe Item Set system is currently disabled."));
                    return true;
                }
                if (sender instanceof Player) {
                    Player p = (Player)sender;
                    new PublicSetListMenu(BuffedItems.getPlayerMenuUtility(p), this.plugin).open();
                } else {
                    sender.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cOnly players can use this command."));
                }
                return true;
            }
            case "update": {
                if (!sender.hasPermission("buffeditems.command.update")) {
                    sender.sendMessage(this.noPermissionMessage);
                    return true;
                }
                if (this.plugin.getUpdateHandler() != null) {
                    this.plugin.getUpdateHandler().checkManually(sender);
                } else {
                    sender.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cUpdate handler is not initialized."));
                }
                return true;
            }
        }
        sender.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cUnknown subcommand. Use /buffeditems for help."));
        return true;
    }

    private void handleWikiCommand(CommandSender sender) {
        Component message = ConfigManager.fromSectionWithPrefix("\u00a7bOfficial Wiki & Documentation:").append(((TextComponent)Component.text((String)" [Click to Open]", (TextColor)NamedTextColor.YELLOW, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}).clickEvent(ClickEvent.openUrl((String)"https://github.com/AltKat/BuffedItems/wiki"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Go to https://github.com/AltKat/BuffedItems/wiki"))));
        sender.sendMessage(message);
    }

    private void sendHelpMessage(CommandSender sender) {
        sender.sendMessage(ConfigManager.fromSection("\u00a7#FFD700--- \u00a7#FF6347BuffedItems Help \u00a7#FFD700---"));
        if (sender.hasPermission("buffeditems.command.give")) {
            sender.sendMessage(ConfigManager.fromSection("\u00a76/bi give <player> <item_id> [amount]"));
        }
        if (sender.hasPermission("buffeditems.command.reload")) {
            sender.sendMessage(ConfigManager.fromSection("\u00a76/bi reload (Reloads all config files from disk)"));
        }
        if (sender.hasPermission("buffeditems.command.list")) {
            sender.sendMessage(ConfigManager.fromSection("\u00a76/bi list"));
        }
        if (sender.hasPermission("buffeditems.command.menu")) {
            sender.sendMessage(ConfigManager.fromSection("\u00a76/bi menu"));
        }
        if (sender.hasPermission("buffeditems.command.upgrade")) {
            sender.sendMessage(ConfigManager.fromSection("\u00a76/bi upgrade \u00a77(Upgrade Station)"));
        }
        if (sender.hasPermission("buffeditems.command.recipes")) {
            sender.sendMessage(ConfigManager.fromSection("\u00a76/bi recipes \u00a77(View Crafting Recipes)"));
        }
        if (sender.hasPermission("buffeditems.command.sets")) {
            sender.sendMessage(ConfigManager.fromSection("\u00a76/bi sets \u00a77(View Item Sets)"));
        }
        if (sender.hasPermission("buffeditems.command.wiki")) {
            sender.sendMessage(ConfigManager.fromSection("\u00a76/bi wiki \u00a77(Get Wiki Link)"));
        }
        if (sender.hasPermission("buffeditems.command.update")) {
            sender.sendMessage(ConfigManager.fromSection("\u00a76/bi update \u00a77(Check Updates)"));
        }
    }

    private boolean handleGiveCommand(CommandSender sender, String[] args) {
        if (args.length < 3) {
            sender.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cUsage: /buffeditems give <player> <item_id> [amount]"));
            return true;
        }
        ConfigManager.sendDebugMessage(1, () -> "[Command] Give command: player=" + args[1] + ", item=" + args[2] + ", amount=" + (args.length >= 4 ? args[3] : "1"));
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            sender.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cPlayer not found: " + args[1]));
            ConfigManager.sendDebugMessage(1, () -> "[Command] Player not found: " + args[1]);
            return true;
        }
        String itemId = args[2];
        BuffedItem buffedItem = this.plugin.getItemManager().getBuffedItem(itemId);
        if (buffedItem == null) {
            sender.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cItem not found in config: " + itemId));
            ConfigManager.sendDebugMessage(1, () -> "[Command] Item not found: " + itemId);
            return true;
        }
        if (!buffedItem.isValid()) {
            sender.sendMessage(ConfigManager.fromSection("\u00a7c\u26a0 WARNING: Item '" + itemId + "' has configuration errors!"));
            sender.sendMessage(ConfigManager.fromSection("\u00a7eErrors:"));
            for (String error : buffedItem.getErrorMessages()) {
                sender.sendMessage(ConfigManager.fromSection("\u00a77  \u2022 " + error));
            }
            sender.sendMessage(ConfigManager.fromSection("\u00a7eThe item will still be given, but may not work as intended."));
            sender.sendMessage(ConfigManager.fromSection("\u00a7ePlease fix errors via /bi menu"));
        }
        int amount = 1;
        if (args.length >= 4) {
            try {
                amount = Integer.parseInt(args[3]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cInvalid amount: " + args[3]));
                ConfigManager.sendDebugMessage(1, () -> "[Command] Invalid amount: " + args[3]);
                return true;
            }
        }
        ItemStack itemStack = new ItemBuilder(buffedItem, (Plugin)this.plugin).build();
        itemStack.setAmount(amount);
        ItemMeta meta = itemStack.getItemMeta();
        if (meta != null) {
            List originalLore;
            Component originalName;
            if (meta.hasDisplayName() && (originalName = meta.displayName()) != null) {
                String legacyNameWithSection = ConfigManager.toSection(originalName);
                String parsedName = this.hooks.processPlaceholders((OfflinePlayer)target, legacyNameWithSection);
                meta.displayName(ConfigManager.fromSection(parsedName));
            }
            if (meta.hasLore() && (originalLore = meta.lore()) != null) {
                List parsedLore = originalLore.stream().map(ConfigManager::toSection).map(line -> this.hooks.processPlaceholders((OfflinePlayer)target, (String)line)).map(ConfigManager::fromSection).collect(Collectors.toList());
                meta.lore(parsedLore);
            }
            itemStack.setItemMeta(meta);
        }
        target.getInventory().addItem(new ItemStack[]{itemStack});
        sender.sendMessage(ConfigManager.fromLegacyWithPrefix("&aGave &e" + amount + "x &r" + buffedItem.getDisplayName() + "&a to " + target.getName()));
        String rawMsg = this.plugin.getConfig().getString("messages.give-success-receiver", "&#00FF00You have received &#FFD700{amount}x &#00FF00{item_name}&#00FF00.");
        String papiMsg = this.hooks.processPlaceholders((OfflinePlayer)target, rawMsg);
        Component baseComp = ConfigManager.fromLegacyWithPrefix(papiMsg);
        int finalAmount = amount;
        Component finalMessage = baseComp.replaceText(builder -> builder.matchLiteral("{amount}").replacement(String.valueOf(finalAmount))).replaceText(builder -> builder.matchLiteral("{item_name}").replacement((ComponentLike)ConfigManager.fromLegacy(buffedItem.getDisplayName())));
        target.sendMessage(finalMessage);
        ConfigManager.logInfo("&aGave &e" + amount + "x " + itemId + "&a to &e" + target.getName() + "&a (by: &e" + sender.getName() + "&a)");
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            this.plugin.getEffectApplicatorTask().markPlayerForUpdate(target.getUniqueId());
            ConfigManager.sendDebugMessage(2, () -> "[Command] Marked " + target.getName() + " for update after receiving item via /bi give.");
        }, 1L);
        return true;
    }

    private boolean handleReloadCommand(CommandSender sender, String[] args) {
        boolean isForce;
        boolean bl = isForce = args.length > 1 && args[1].equalsIgnoreCase("force");
        if (!isForce) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!BuffedItems.getPlayerMenuUtility(p).hasUnsavedChanges()) continue;
                sender.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7c\u00a7lWARNING: \u00a7r\u00a7cPlayer '" + p.getName() + "' is currently editing a recipe!"));
                sender.sendMessage(ConfigManager.fromSection("\u00a7cReloading now will discard their unsaved changes."));
                sender.sendMessage(ConfigManager.fromSection("\u00a7eType \u00a76/bi reload force \u00a7eto ignore this warning."));
                return true;
            }
        }
        ConfigManager.sendDebugMessage(1, () -> "[Reload] Reload triggered by " + sender.getName());
        ConfigManager.reloadConfig();
        sender.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aConfigurations has been reloaded."));
        return true;
    }

    private boolean handleListCommand(CommandSender sender) {
        Map<String, BuffedItem> items = this.plugin.getItemManager().getLoadedItems();
        sender.sendMessage(ConfigManager.fromSection("\u00a7#FFD700--- \u00a7#FF6347Available Buffed Items \u00a7#FFD700---"));
        int validCount = 0;
        int errorCount = 0;
        for (Map.Entry<String, BuffedItem> entry : items.entrySet()) {
            String itemId = entry.getKey();
            BuffedItem item = entry.getValue();
            if (item.isValid()) {
                sender.sendMessage(ConfigManager.fromSection("\u00a76\u2713 " + itemId));
                ++validCount;
                continue;
            }
            sender.sendMessage(ConfigManager.fromSection("\u00a7c\u2717 " + itemId + "\u00a78 (" + item.getErrorMessages().size() + " error(s))"));
            ++errorCount;
        }
        sender.sendMessage(ConfigManager.fromSection(""));
        sender.sendMessage(ConfigManager.fromSection("\u00a77Total: " + items.size() + " | \u00a7aValid: " + validCount + " | \u00a7cErrors: " + errorCount));
        if (errorCount > 0) {
            sender.sendMessage(ConfigManager.fromSection("\u00a7eUse \u00a76/bi menu\u00a7e to view and fix errors."));
        }
        return true;
    }
}

