/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.utility.item;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.utility.attribute.ParsedAttribute;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import io.github.altkat.BuffedItems.utility.item.BuffedItemEffect;
import io.github.altkat.BuffedItems.utility.item.ItemBuilder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ItemUpdater {
    private final BuffedItems plugin;
    private final NamespacedKey idKey;
    private final NamespacedKey usesKey;

    public ItemUpdater(BuffedItems plugin) {
        this.plugin = plugin;
        this.idKey = new NamespacedKey((Plugin)plugin, "buffeditem_id");
        this.usesKey = new NamespacedKey((Plugin)plugin, "remaining_active_uses");
    }

    public ItemStack updateItem(ItemStack oldItem, Player player) {
        if (oldItem == null || !oldItem.hasItemMeta()) {
            return null;
        }
        String itemId = (String)oldItem.getItemMeta().getPersistentDataContainer().get(this.idKey, PersistentDataType.STRING);
        if (itemId == null) {
            return null;
        }
        BuffedItem template = this.plugin.getItemManager().getBuffedItem(itemId);
        if (template == null) {
            return null;
        }
        ItemStack newItem = oldItem.clone();
        if (newItem.getType() != template.getMaterial()) {
            newItem.setType(template.getMaterial());
        }
        ItemMeta meta = newItem.getItemMeta();
        String rawName = template.getDisplayName();
        String parsedName = this.plugin.getHookManager().processPlaceholders((OfflinePlayer)player, rawName);
        meta.displayName(ConfigManager.fromLegacy(parsedName));
        ArrayList<Component> baseLore = new ArrayList<Component>();
        for (String line : template.getLore()) {
            String string = this.plugin.getHookManager().processPlaceholders((OfflinePlayer)player, line);
            baseLore.add(ConfigManager.fromLegacy(string));
        }
        int currentUses = template.getMaxUses();
        if (template.isActiveMode() && template.getMaxUses() > 0) {
            if (meta.getPersistentDataContainer().has(this.usesKey, PersistentDataType.INTEGER)) {
                currentUses = (Integer)meta.getPersistentDataContainer().get(this.usesKey, PersistentDataType.INTEGER);
            } else {
                meta.getPersistentDataContainer().set(this.usesKey, PersistentDataType.INTEGER, (Object)currentUses);
            }
            String usageLineRaw = currentUses > 0 ? template.getUsageLore(currentUses) : template.getDepletedLore();
            String string = this.plugin.getHookManager().processPlaceholders((OfflinePlayer)player, usageLineRaw);
            baseLore.add(ConfigManager.fromLegacy(string));
        } else {
            meta.getPersistentDataContainer().remove(this.usesKey);
        }
        meta.lore(baseLore);
        if (template.getCustomModelData().isPresent()) {
            meta.setCustomModelData(template.getCustomModelData().get());
        } else {
            meta.setCustomModelData(null);
        }
        for (Map.Entry entry : template.getEnchantments().entrySet()) {
            meta.addEnchant((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue(), true);
        }
        meta.setUnbreakable(template.getFlag("UNBREAKABLE"));
        meta.setAttributeModifiers(null);
        boolean forceHideAttributes = false;
        if (template.getAttributeMode() == BuffedItem.AttributeMode.STATIC) {
            boolean bl;
            boolean bl2 = false;
            for (Map.Entry<String, BuffedItemEffect> effectEntry : template.getEffects().entrySet()) {
                String slotKey = effectEntry.getKey().toUpperCase();
                BuffedItemEffect itemEffect = effectEntry.getValue();
                EquipmentSlot equipmentSlot = this.getEquipmentSlot(slotKey);
                if (equipmentSlot == null) continue;
                for (ParsedAttribute parsedAttr : itemEffect.getParsedAttributes()) {
                    AttributeModifier modifier = new AttributeModifier(parsedAttr.getUuid(), "buffeditems." + template.getId() + "." + slotKey, parsedAttr.getAmount(), parsedAttr.getOperation(), equipmentSlot);
                    meta.addAttributeModifier(parsedAttr.getAttribute(), modifier);
                    bl = true;
                }
            }
            if (!bl) {
                Attribute dummyAttr = Attribute.GENERIC_LUCK;
                for (EquipmentSlot slot : ItemBuilder.VALID_SLOTS) {
                    UUID dummyUUID = UUID.nameUUIDFromBytes(("buffeditems.dummy.static." + template.getId() + "." + slot.name()).getBytes(StandardCharsets.UTF_8));
                    AttributeModifier dummyMod = new AttributeModifier(dummyUUID, "buffeditems.dummy." + slot.name(), 0.0, AttributeModifier.Operation.ADD_NUMBER, slot);
                    meta.addAttributeModifier(dummyAttr, dummyMod);
                }
                forceHideAttributes = true;
            }
        } else {
            Attribute attribute = Attribute.GENERIC_LUCK;
            for (EquipmentSlot slot : ItemBuilder.VALID_SLOTS) {
                UUID dummyUUID = UUID.nameUUIDFromBytes(("buffeditems.dummy.dynamic." + template.getId() + "." + slot.name()).getBytes(StandardCharsets.UTF_8));
                AttributeModifier dummyMod = new AttributeModifier(dummyUUID, "buffeditems.dummy." + slot.name(), 0.0, AttributeModifier.Operation.ADD_NUMBER, slot);
                meta.addAttributeModifier(attribute, dummyMod);
            }
            forceHideAttributes = true;
        }
        meta.removeItemFlags(ItemFlag.values());
        if (template.getFlag("HIDE_ENCHANTS")) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        if (template.getFlag("HIDE_ATTRIBUTES") || forceHideAttributes) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        }
        if (template.getFlag("HIDE_UNBREAKABLE")) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
        }
        if (template.getFlag("HIDE_DESTROYS")) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
        }
        if (template.getFlag("HIDE_PLACED_ON")) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_PLACED_ON});
        }
        if (template.getFlag("HIDE_ADDITIONAL_TOOLTIP")) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
        }
        if (template.getFlag("HIDE_ARMOR_TRIM")) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ARMOR_TRIM});
        }
        if (template.hasGlow() && !meta.hasEnchants()) {
            meta.addEnchant(Enchantment.LUCK_OF_THE_SEA, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        newItem.setItemMeta(meta);
        return newItem;
    }

    private EquipmentSlot getEquipmentSlot(String slot) {
        switch (slot.toUpperCase()) {
            case "MAIN_HAND": {
                return EquipmentSlot.HAND;
            }
            case "OFF_HAND": {
                return EquipmentSlot.OFF_HAND;
            }
            case "HELMET": {
                return EquipmentSlot.HEAD;
            }
            case "CHESTPLATE": {
                return EquipmentSlot.CHEST;
            }
            case "LEGGINGS": {
                return EquipmentSlot.LEGS;
            }
            case "BOOTS": {
                return EquipmentSlot.FEET;
            }
        }
        return null;
    }
}

