/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.task;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.attribute.ActiveAttributeManager;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.effect.EffectManager;
import io.github.altkat.BuffedItems.utility.attribute.ParsedAttribute;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import io.github.altkat.BuffedItems.utility.item.BuffedItemEffect;
import io.github.altkat.BuffedItems.utility.set.BuffedSet;
import io.github.altkat.BuffedItems.utility.set.SetBonus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class EffectApplicatorTask
extends BukkitRunnable {
    private final BuffedItems plugin;
    private final NamespacedKey nbtKey;
    private final ActiveAttributeManager attributeManager;
    private final EffectManager effectManager;
    private final Map<UUID, Set<PotionEffectType>> managedPotions = new ConcurrentHashMap<UUID, Set<PotionEffectType>>();
    private final Set<UUID> playersToUpdate = ConcurrentHashMap.newKeySet();
    private final Map<UUID, CachedPlayerData> playerCache = new ConcurrentHashMap<UUID, CachedPlayerData>();
    private int tickCount = 0;
    private final Map<UUID, Map<String, Boolean>> permissionCache = new ConcurrentHashMap<UUID, Map<String, Boolean>>();
    private long lastCacheClearTime = 0L;
    private static final long CACHE_EXPIRE_MS = 1000L;
    private Iterator<UUID> staleCheckIterator = null;
    private static final int PLAYERS_TO_CHECK_PER_TICK = 2;

    public EffectApplicatorTask(BuffedItems plugin) {
        this.plugin = plugin;
        this.nbtKey = new NamespacedKey((Plugin)plugin, "buffeditem_id");
        this.attributeManager = plugin.getActiveAttributeManager();
        this.effectManager = plugin.getEffectManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        HashSet<UUID> playersToScanFully;
        ++this.tickCount;
        boolean debugTick = this.tickCount % 20 == 0;
        long now = System.currentTimeMillis();
        if (now - this.lastCacheClearTime > 1000L) {
            this.permissionCache.clear();
            this.lastCacheClearTime = now;
            if (debugTick) {
                ConfigManager.sendDebugMessage(4, () -> "[Task] Permission cache auto-cleared.");
            }
        }
        this.processDistributedStaleCheck(debugTick);
        Iterator iterator = this.playersToUpdate;
        synchronized (iterator) {
            playersToScanFully = new HashSet<UUID>(this.playersToUpdate);
            this.playersToUpdate.clear();
        }
        for (UUID uuid : playersToScanFully) {
            this.permissionCache.remove(uuid);
        }
        if (debugTick && !playersToScanFully.isEmpty()) {
            ConfigManager.sendDebugMessage(2, () -> "[Task] Running 'Slow Path' (Full Scan) for " + playersToScanFully.size() + " modified players...");
        }
        for (UUID playerUUID : playersToScanFully) {
            Player player = Bukkit.getPlayer((UUID)playerUUID);
            if (player == null || !player.isOnline()) {
                this.playerCache.remove(playerUUID);
                this.permissionCache.remove(playerUUID);
                continue;
            }
            this.processPlayer(player, debugTick);
        }
        ArrayList<UUID> offlinePlayers = new ArrayList<UUID>();
        HashMap<PotionEffectType, Integer> desiredPotionEffects = new HashMap<PotionEffectType, Integer>();
        HashSet<UUID> desiredInventoryAttributeUUIDs = new HashSet<UUID>();
        for (Map.Entry<UUID, CachedPlayerData> cacheEntry : this.playerCache.entrySet()) {
            Set<PotionEffectType> set;
            UUID playerUUID = cacheEntry.getKey();
            CachedPlayerData cachedData = cacheEntry.getValue();
            Player player = Bukkit.getPlayer((UUID)playerUUID);
            if (player == null || !player.isOnline()) {
                offlinePlayers.add(playerUUID);
                continue;
            }
            if (cachedData == null || cachedData.activeItems == null) continue;
            desiredPotionEffects.clear();
            desiredInventoryAttributeUUIDs.clear();
            HashMap<String, Integer> currentSetCounts = new HashMap<String, Integer>();
            for (CachedItem cachedItem : cachedData.activeItems) {
                BuffedItem item = cachedItem.item;
                String slot = cachedItem.slot;
                if (!this.checkCachedPermission(player, item)) {
                    if (!debugTick) continue;
                    ConfigManager.sendDebugMessage(3, () -> "[Task-Fast Path] Player " + player.getName() + " lacks permission for " + item.getId() + ". Skipping effects.");
                    continue;
                }
                if (cachedItem.setId != null && !slot.equals("INVENTORY")) {
                    boolean isHandSlot = slot.equals("MAIN_HAND") || slot.equals("OFF_HAND");
                    boolean isArmorItem = this.isArmor(item.getMaterial());
                    if (!isHandSlot || !isArmorItem) {
                        currentSetCounts.merge(cachedItem.setId, 1, Integer::sum);
                    }
                }
                if (!item.getEffects().containsKey(slot)) continue;
                BuffedItemEffect itemEffects = item.getEffects().get(slot);
                itemEffects.getPotionEffects().forEach((type, level) -> desiredPotionEffects.merge((PotionEffectType)type, (Integer)level, Integer::max));
                if (item.getAttributeMode() != BuffedItem.AttributeMode.DYNAMIC && !slot.equals("INVENTORY")) continue;
                for (ParsedAttribute parsedAttr : itemEffects.getParsedAttributes()) {
                    desiredInventoryAttributeUUIDs.add(parsedAttr.getUuid());
                    if (this.attributeManager.hasModifier(playerUUID, parsedAttr.getAttribute(), parsedAttr.getUuid())) continue;
                    this.effectManager.applySingleAttribute(player, parsedAttr, slot);
                }
            }
            for (Map.Entry entry : currentSetCounts.entrySet()) {
                String setId = (String)entry.getKey();
                int count = (Integer)entry.getValue();
                BuffedSet set2 = this.plugin.getSetManager().getSet(setId);
                if (set2 == null) continue;
                for (int i = 1; i <= count; ++i) {
                    SetBonus bonus = set2.getBonusFor(i);
                    if (bonus == null) continue;
                    BuffedItemEffect effects = bonus.getEffects();
                    effects.getPotionEffects().forEach((type, level) -> desiredPotionEffects.merge((PotionEffectType)type, (Integer)level, Integer::max));
                    for (ParsedAttribute parsedAttr : effects.getParsedAttributes()) {
                        desiredInventoryAttributeUUIDs.add(parsedAttr.getUuid());
                        if (this.attributeManager.hasModifier(playerUUID, parsedAttr.getAttribute(), parsedAttr.getUuid())) continue;
                        this.effectManager.applySingleAttribute(player, parsedAttr, "SET_BONUS");
                    }
                }
            }
            Set<PotionEffectType> lastAppliedPotions = this.managedPotions.getOrDefault(playerUUID, Collections.emptySet());
            if (!lastAppliedPotions.equals(set = desiredPotionEffects.keySet())) {
                this.effectManager.removeObsoletePotionEffects(player, lastAppliedPotions, set, debugTick);
                if (!desiredPotionEffects.isEmpty()) {
                    this.effectManager.applyOrRefreshPotionEffects(player, desiredPotionEffects, debugTick);
                }
                this.managedPotions.put(playerUUID, new HashSet<PotionEffectType>(set));
            } else if (!desiredPotionEffects.isEmpty()) {
                this.effectManager.applyOrRefreshPotionEffects(player, desiredPotionEffects, debugTick);
            }
            Map<Attribute, List<AttributeModifier>> trackedModifiersMap = this.attributeManager.getActiveModifiers(playerUUID);
            ArrayList<ModifierToRemove> modifiersToRemove = new ArrayList<ModifierToRemove>();
            for (Map.Entry<Attribute, List<AttributeModifier>> trackedEntry : trackedModifiersMap.entrySet()) {
                Attribute trackedAttribute = trackedEntry.getKey();
                for (AttributeModifier trackedModifier : trackedEntry.getValue()) {
                    if (desiredInventoryAttributeUUIDs.contains(trackedModifier.getUniqueId())) continue;
                    modifiersToRemove.add(new ModifierToRemove(trackedAttribute, trackedModifier.getUniqueId()));
                }
            }
            for (ModifierToRemove toRemove : modifiersToRemove) {
                this.effectManager.removeAttributeModifier(player, toRemove.attribute, toRemove.uuid);
                ConfigManager.sendDebugMessage(3, () -> "[Task-Fast Path] REMOVED attribute modifier: " + String.valueOf(toRemove.uuid) + " for " + player.getName());
            }
        }
        if (!offlinePlayers.isEmpty()) {
            for (UUID offlineUUID : offlinePlayers) {
                this.playerCache.remove(offlineUUID);
                this.managedPotions.remove(offlineUUID);
            }
            if (debugTick) {
                ConfigManager.sendDebugMessage(2, () -> "[Task] Cleaned up " + offlinePlayers.size() + " offline player(s) from cache");
            }
        }
    }

    private void processPlayer(Player player, boolean debugTick) {
        UUID playerUUID = player.getUniqueId();
        if (debugTick) {
            ConfigManager.sendDebugMessage(2, () -> "[Task-Slow Path] Scanning inventory and updating cache for " + player.getName());
        }
        List<CachedItem> activeItems = this.findActiveItems(player, debugTick);
        if (debugTick && !activeItems.isEmpty()) {
            ConfigManager.sendDebugMessage(3, () -> "[Task-Slow Path] Found " + activeItems.size() + " active item(s) for " + player.getName());
        }
        this.playerCache.put(playerUUID, new CachedPlayerData(activeItems));
    }

    private List<CachedItem> findActiveItems(Player player, boolean debugTick) {
        ArrayList<CachedItem> activeItems = new ArrayList<CachedItem>();
        PlayerInventory inventory = player.getInventory();
        this.checkItem(inventory.getItemInMainHand(), "MAIN_HAND", activeItems, player, debugTick);
        this.checkItem(inventory.getItemInOffHand(), "OFF_HAND", activeItems, player, debugTick);
        this.checkItem(inventory.getHelmet(), "HELMET", activeItems, player, debugTick);
        this.checkItem(inventory.getChestplate(), "CHESTPLATE", activeItems, player, debugTick);
        this.checkItem(inventory.getLeggings(), "LEGGINGS", activeItems, player, debugTick);
        this.checkItem(inventory.getBoots(), "BOOTS", activeItems, player, debugTick);
        for (ItemStack item : inventory.getStorageContents()) {
            if (item == null || !item.hasItemMeta()) continue;
            this.checkItem(item, "INVENTORY", activeItems, player, debugTick);
        }
        return activeItems;
    }

    private void checkItem(ItemStack item, String slot, List<CachedItem> activeItems, Player player, boolean debugTick) {
        if (item == null || item.getType().isAir() || !item.hasItemMeta()) {
            return;
        }
        String itemId = (String)item.getItemMeta().getPersistentDataContainer().get(this.nbtKey, PersistentDataType.STRING);
        if (itemId != null) {
            BuffedItem buffedItem = this.plugin.getItemManager().getBuffedItem(itemId);
            if (buffedItem != null) {
                String setId = this.plugin.getSetManager().getSetIdByItem(itemId);
                activeItems.add(new CachedItem(buffedItem, slot, setId));
                if (debugTick) {
                    ConfigManager.sendDebugMessage(4, () -> "[Task-FindItem] Detected " + itemId + " (Set: " + setId + ") in " + slot);
                }
            } else if (debugTick) {
                ConfigManager.sendDebugMessage(4, () -> "[Task-FindItem] Unknown BuffedItem ID found on item: " + itemId + " (player: " + player.getName() + ", slot: " + slot + ")");
            }
        }
    }

    private void processDistributedStaleCheck(boolean debugTick) {
        if (this.playerCache.isEmpty()) {
            return;
        }
        if (this.staleCheckIterator == null || !this.staleCheckIterator.hasNext()) {
            this.staleCheckIterator = this.playerCache.keySet().iterator();
        }
        for (int checkedCount = 0; this.staleCheckIterator.hasNext() && checkedCount < 2; ++checkedCount) {
            UUID playerUUID = this.staleCheckIterator.next();
            Player player = Bukkit.getPlayer((UUID)playerUUID);
            if (player == null || !player.isOnline()) continue;
            CachedPlayerData cachedData = this.playerCache.get(playerUUID);
            List<CachedItem> currentItems = this.findActiveItems(player, false);
            if (cachedData == null || this.isSameActiveItems(cachedData.activeItems, currentItems)) continue;
            this.markPlayerForUpdate(playerUUID);
            if (!debugTick) continue;
            ConfigManager.sendDebugMessage(2, () -> "[Task-StaleCheck] Stale cache detected for " + player.getName() + " (Distributed check)");
        }
    }

    private boolean checkCachedPermission(Player player, BuffedItem item) {
        String permNode = item.getPassivePermissionRaw();
        if (permNode == null && item.getPermission() != null) {
            permNode = item.getPermission();
        }
        if (permNode == null || permNode.equalsIgnoreCase("NONE")) {
            return true;
        }
        UUID uuid = player.getUniqueId();
        Map playerPerms = this.permissionCache.computeIfAbsent(uuid, k -> new ConcurrentHashMap());
        return playerPerms.computeIfAbsent(permNode, arg_0 -> ((Player)player).hasPermission(arg_0));
    }

    private boolean isSameActiveItems(List<CachedItem> cacheList, List<CachedItem> realList) {
        if (cacheList.size() != realList.size()) {
            return false;
        }
        for (int i = 0; i < cacheList.size(); ++i) {
            CachedItem cacheItem = cacheList.get(i);
            CachedItem realItem = realList.get(i);
            if (cacheItem.item.getId().equals(realItem.item.getId()) && cacheItem.slot.equals(realItem.slot) && Objects.equals(cacheItem.setId, realItem.setId)) continue;
            return false;
        }
        return true;
    }

    public void playerQuit(Player player) {
        ConfigManager.sendDebugMessage(1, () -> "[Task] Removing player data: " + player.getName());
        UUID uuid = player.getUniqueId();
        this.managedPotions.remove(uuid);
        this.playerCache.remove(uuid);
        this.playersToUpdate.remove(uuid);
        this.permissionCache.remove(uuid);
        this.attributeManager.clearPlayer(uuid);
    }

    public void markPlayerForUpdate(UUID playerUUID) {
        this.playersToUpdate.add(playerUUID);
    }

    public void invalidateCacheForHolding(String itemId) {
        ConfigManager.sendDebugMessage(2, () -> "[Task] Invalidating cache for players holding: " + itemId);
        int markedCount = 0;
        for (Map.Entry<UUID, CachedPlayerData> entry : this.playerCache.entrySet()) {
            UUID playerUUID = entry.getKey();
            CachedPlayerData data = entry.getValue();
            if (data == null || data.activeItems == null) continue;
            boolean isHolding = false;
            for (CachedItem itemEntry : data.activeItems) {
                if (!itemEntry.item.getId().equals(itemId)) continue;
                isHolding = true;
                break;
            }
            if (!isHolding) continue;
            this.markPlayerForUpdate(playerUUID);
            ++markedCount;
            ConfigManager.sendDebugMessage(3, () -> "[Task] --> Marked player " + String.valueOf(playerUUID) + " due to holding " + itemId);
        }
        int finalMarkedCount = markedCount;
        ConfigManager.sendDebugMessage(2, () -> "[Task] Marked " + finalMarkedCount + " player(s) for update due to holding " + itemId);
    }

    public Set<PotionEffectType> getManagedEffects(UUID playerUUID) {
        return this.managedPotions.getOrDefault(playerUUID, Collections.emptySet());
    }

    private boolean isArmor(Material m) {
        String name = m.name();
        return name.endsWith("_HELMET") || name.endsWith("_CHESTPLATE") || name.endsWith("_LEGGINGS") || name.endsWith("_BOOTS") || name.equals("ELYTRA") || name.equals("TURTLE_HELMET");
    }

    private static class CachedPlayerData {
        final List<CachedItem> activeItems;

        CachedPlayerData(List<CachedItem> activeItems) {
            this.activeItems = new ArrayList<CachedItem>(activeItems);
        }
    }

    private static class CachedItem {
        final BuffedItem item;
        final String slot;
        final String setId;

        CachedItem(BuffedItem item, String slot, String setId) {
            this.item = item;
            this.slot = slot;
            this.setId = setId;
        }
    }

    private static class ModifierToRemove {
        final Attribute attribute;
        final UUID uuid;

        ModifierToRemove(Attribute attribute, UUID uuid) {
            this.attribute = attribute;
            this.uuid = uuid;
        }
    }
}

