/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.utility;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.menu.base.Menu;
import io.github.altkat.BuffedItems.menu.utility.ItemListMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class ConfirmationMenu
extends Menu {
    private final BuffedItems plugin;
    private final String itemToDeleteId;

    public ConfirmationMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin, String itemToDeleteId) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.itemToDeleteId = itemToDeleteId;
    }

    @Override
    public String getMenuName() {
        return "Delete: " + this.itemToDeleteId + "?";
    }

    @Override
    public int getSlots() {
        return 27;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        if (e.getCurrentItem() == null) {
            return;
        }
        switch (e.getCurrentItem().getType()) {
            case GREEN_WOOL: {
                ConfigManager.setItemValue(this.itemToDeleteId, null, null);
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aItem '" + this.itemToDeleteId + "' has been successfully deleted."));
                new ItemListMenu(this.playerMenuUtility, this.plugin).open();
                break;
            }
            case RED_WOOL: {
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cDeletion cancelled."));
                new ItemListMenu(this.playerMenuUtility, this.plugin).open();
            }
        }
    }

    @Override
    public void setMenuItems() {
        this.inventory.setItem(11, this.makeItem(Material.GREEN_WOOL, "\u00a7aConfirm Deletion", "\u00a77This action cannot be undone."));
        this.inventory.setItem(15, this.makeItem(Material.RED_WOOL, "\u00a7cCancel", "\u00a77Return to the main menu."));
        this.setFillerGlass();
    }
}

