/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.upgrade;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.cost.ICost;
import io.github.altkat.BuffedItems.manager.cost.types.BuffedItemCost;
import io.github.altkat.BuffedItems.manager.upgrade.FailureAction;
import io.github.altkat.BuffedItems.manager.upgrade.UpgradeRecipe;
import io.github.altkat.BuffedItems.menu.base.PaginatedMenu;
import io.github.altkat.BuffedItems.menu.upgrade.UpgradeMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import io.github.altkat.BuffedItems.utility.item.ItemBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class UpgradeRecipeBrowserMenu
extends PaginatedMenu {
    private final BuffedItems plugin;

    public UpgradeRecipeBrowserMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.maxItemsPerPage = 36;
    }

    @Override
    public String getMenuName() {
        return "Available Upgrades (Page " + (this.page + 1) + ")";
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        if (e.getCurrentItem() == null) {
            return;
        }
        List<UpgradeRecipe> recipes = this.getSortedRecipes();
        if (this.handlePageChange(e, recipes.size())) {
            return;
        }
        if (e.getCurrentItem().getType() == Material.BARRIER && e.getSlot() == 49) {
            new UpgradeMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
    }

    @Override
    public void setMenuItems() {
        int index;
        int i;
        ItemStack filler = this.makeItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        for (i = 0; i < 9; ++i) {
            this.inventory.setItem(i, filler);
        }
        for (i = 45; i < 54; ++i) {
            this.inventory.setItem(i, filler);
        }
        this.addMenuControls();
        this.inventory.setItem(49, this.makeItem(Material.BARRIER, "\u00a7cBack to Station", new String[0]));
        List<UpgradeRecipe> recipes = this.getSortedRecipes();
        for (int i2 = 0; i2 < this.maxItemsPerPage && (index = this.maxItemsPerPage * this.page + i2) < recipes.size(); ++i2) {
            UpgradeRecipe recipe = recipes.get(index);
            this.inventory.setItem(9 + i2, this.createRecipeIcon(recipe));
        }
    }

    private ItemStack createRecipeIcon(UpgradeRecipe recipe) {
        String resultName;
        ItemStack icon;
        BuffedItem resultItem = this.plugin.getItemManager().getBuffedItem(recipe.getResultItemId());
        if (resultItem != null) {
            icon = new ItemBuilder(resultItem, (Plugin)this.plugin).build();
            resultName = ConfigManager.toSection(ConfigManager.fromLegacy(resultItem.getDisplayName()));
        } else {
            icon = new ItemStack(Material.BARRIER);
            resultName = "\u00a7cUnknown Item";
        }
        icon.setAmount(Math.max(1, recipe.getResultAmount()));
        ArrayList<Component> lore = new ArrayList<Component>();
        lore.add(ConfigManager.fromSection(""));
        lore.add(ConfigManager.fromSection("\u00a77Recipe: \u00a7f" + ConfigManager.toSection(ConfigManager.fromLegacy(recipe.getDisplayName()))));
        lore.add(ConfigManager.fromSection(""));
        Object baseName = "\u00a7cUnknown";
        if (recipe.getBaseCost() instanceof BuffedItemCost) {
            String bId = ((BuffedItemCost)recipe.getBaseCost()).getRequiredItemId();
            BuffedItem bItem = this.plugin.getItemManager().getBuffedItem(bId);
            baseName = bItem != null ? ConfigManager.toSection(ConfigManager.fromLegacy(bItem.getDisplayName())) : bId;
        } else if (recipe.getBaseCost() != null) {
            baseName = recipe.getBaseCost().getDisplayString();
        }
        lore.add(ConfigManager.fromSection("\u00a77From: \u00a7f" + (String)baseName));
        lore.add(ConfigManager.fromSection("   \u00a77\u2b07"));
        lore.add(ConfigManager.fromSection("\u00a77To: \u00a7f" + resultName + (String)(recipe.getResultAmount() > 1 ? " \u00a7e(x" + recipe.getResultAmount() + ")" : "")));
        lore.add(ConfigManager.fromSection(""));
        lore.add(ConfigManager.fromSection("\u00a77Requires:"));
        for (ICost cost : recipe.getIngredients()) {
            lore.add(ConfigManager.fromSection(" \u00a78- \u00a77" + cost.getDisplayString()));
        }
        lore.add(ConfigManager.fromSection(""));
        String chanceColor = recipe.getSuccessRate() >= 100.0 ? "\u00a7a" : (recipe.getSuccessRate() >= 50.0 ? "\u00a7e" : "\u00a7c");
        lore.add(ConfigManager.fromSection("\u00a77Chance: " + chanceColor + recipe.getSuccessRate() + "%"));
        String risk = switch (recipe.getFailureAction()) {
            default -> throw new IncompatibleClassChangeError();
            case FailureAction.KEEP_EVERYTHING -> "\u00a7aSafe (No Loss)";
            case FailureAction.KEEP_BASE_ONLY -> "\u00a7eModerate (Item Kept)";
            case FailureAction.LOSE_EVERYTHING -> "\u00a7cRisky (Lose All)";
        };
        lore.add(ConfigManager.fromSection("\u00a77Risk: " + risk));
        ItemMeta meta = icon.getItemMeta();
        if (meta != null) {
            meta.lore(lore);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ADDITIONAL_TOOLTIP, ItemFlag.HIDE_ENCHANTS});
            icon.setItemMeta(meta);
        }
        return icon;
    }

    private List<UpgradeRecipe> getSortedRecipes() {
        ArrayList<UpgradeRecipe> recipes = new ArrayList<UpgradeRecipe>(this.plugin.getUpgradeManager().getRecipes().values());
        recipes.removeIf(r -> !r.isValid());
        recipes.sort(Comparator.comparing(UpgradeRecipe::getId));
        return recipes;
    }
}

